/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.buildproperties.BuildProperty;
import tech.jhipster.lite.module.domain.buildproperties.PropertyKey;
import tech.jhipster.lite.module.domain.buildproperties.PropertyValue;
import tech.jhipster.lite.module.domain.javabuild.MavenBuildExtension;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectMavenPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradlePlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaBuildProfile;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenBuildExtension;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPluginManagement;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.SetBuildProperty;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileActivation;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileId;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyClassifier;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginConfiguration;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecution;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecutionGoal;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecutionId;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.JavaDependenciesCommandHandler;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MalformedAdditionalInformationException;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MavenScope;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MavenType;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MissingMavenProfileException;
import tech.jhipster.lite.shared.enumeration.domain.Enums;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.error.domain.GeneratorException;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public class MavenCommandHandler
implements JavaDependenciesCommandHandler {
    private static final MavenXpp3Writer mavenWriter = new MavenXpp3Writer();
    private static final String COMMAND = "command";
    private static final int DEFAULT_MAVEN_INDENTATION = 2;
    private final Indentation indentation;
    private final Path pomPath;
    private final Model pomModel;

    public MavenCommandHandler(Indentation indentation, Path pomPath) {
        Assert.notNull("indentation", indentation);
        Assert.notNull("pomPath", pomPath);
        this.indentation = indentation;
        this.pomPath = pomPath;
        this.pomModel = this.readModel(pomPath);
    }

    private Model readModel(Path pomPath) {
        Model model;
        block8: {
            InputStream input = Files.newInputStream(pomPath, new OpenOption[0]);
            try {
                MavenXpp3Reader reader = new MavenXpp3Reader();
                model = reader.read(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    throw GeneratorException.technicalError("Error reading pom file: " + e.getMessage(), e);
                }
            }
            input.close();
        }
        return model;
    }

    @Override
    public void handle(SetVersion command) {
        Assert.notNull(COMMAND, command);
        BuildProperty property = new BuildProperty(new PropertyKey(command.property()), new PropertyValue(command.dependencyVersion()));
        this.handle(new SetBuildProperty(property));
    }

    @Override
    public void handle(SetBuildProperty command) {
        Assert.notNull(COMMAND, command);
        ModelBase model = command.buildProfile().map(this::findProfile).map(ModelBase.class::cast).orElse((ModelBase)this.pomModel);
        model.addProperty(command.property().key().get(), command.property().value().get());
        this.writePom();
    }

    private Profile findProfile(BuildProfileId buildProfileId) {
        return this.pomModel.getProfiles().stream().filter(MavenCommandHandler.profileMatch(buildProfileId)).findFirst().orElseThrow(() -> new MissingMavenProfileException(buildProfileId));
    }

    private static Predicate<Profile> profileMatch(BuildProfileId buildProfileId) {
        return profile -> profile.getId().equals(buildProfileId.value());
    }

    @Override
    public void handle(AddJavaBuildProfile command) {
        Assert.notNull(COMMAND, command);
        List profiles = this.pomModel.getProfiles();
        if (profiles.stream().noneMatch(MavenCommandHandler.profileMatch(command.buildProfileId()))) {
            Profile profile = MavenCommandHandler.toMavenProfile(command);
            this.pomModel.addProfile(profile);
        }
        this.writePom();
    }

    private static Profile toMavenProfile(AddJavaBuildProfile command) {
        Profile profile = new Profile();
        profile.setId(command.buildProfileId().value());
        command.activation().ifPresent(activation -> profile.setActivation(MavenCommandHandler.toMavenActivation(activation)));
        return profile;
    }

    private static Activation toMavenActivation(BuildProfileActivation activation) {
        Activation mavenActivation = new Activation();
        activation.activeByDefault().ifPresent(arg_0 -> ((Activation)mavenActivation).setActiveByDefault(arg_0));
        return mavenActivation;
    }

    @Override
    public void handle(RemoveJavaDependencyManagement command) {
        Assert.notNull(COMMAND, command);
        DependencyManagement dependenciesManagement = this.pomModel.getDependencyManagement();
        if (dependenciesManagement != null) {
            this.removeDependencyFrom(command.dependency(), dependenciesManagement.getDependencies());
        }
    }

    @Override
    public void handle(RemoveDirectJavaDependency command) {
        Assert.notNull(COMMAND, command);
        this.removeDependencyFrom(command.dependency(), this.pomModel.getDependencies());
    }

    private void removeDependencyFrom(DependencyId dependency, List<Dependency> dependencies) {
        dependencies.removeIf(this.dependencyMatch(dependency));
        this.writePom();
    }

    private Predicate<Dependency> dependencyMatch(DependencyId dependencyId) {
        return mavenDependency -> {
            boolean sameGroupId = mavenDependency.getGroupId().equals(dependencyId.groupId().get());
            boolean sameArtifactId = mavenDependency.getArtifactId().equals(dependencyId.artifactId().get());
            return sameGroupId && sameArtifactId;
        };
    }

    @Override
    public void handle(AddMavenBuildExtension command) {
        Assert.notNull(COMMAND, command);
        this.projectBuild().addExtension(MavenCommandHandler.toMavenExtension(command.buildExtension()));
        this.writePom();
    }

    private Build projectBuild() {
        if (this.pomModel.getBuild() == null) {
            this.pomModel.setBuild(new Build());
        }
        return this.pomModel.getBuild();
    }

    private static Extension toMavenExtension(MavenBuildExtension mavenBuildExtension) {
        Extension extension = new Extension();
        extension.setArtifactId(mavenBuildExtension.artifactId().get());
        extension.setGroupId(mavenBuildExtension.groupId().get());
        mavenBuildExtension.versionSlug().map(VersionSlug::mavenVariable).ifPresent(arg_0 -> ((Extension)extension).setVersion(arg_0));
        return extension;
    }

    @Override
    public void handle(AddJavaDependencyManagement command) {
        Assert.notNull(COMMAND, command);
        this.addDependencyTo(command.dependency(), this.dependencyManagement().getDependencies());
    }

    private DependencyManagement dependencyManagement() {
        if (this.pomModel.getDependencyManagement() == null) {
            this.pomModel.setDependencyManagement(new DependencyManagement());
        }
        return this.pomModel.getDependencyManagement();
    }

    @Override
    public void handle(AddDirectJavaDependency command) {
        Assert.notNull(COMMAND, command);
        this.addDependencyTo(command.dependency(), this.pomModel.getDependencies());
    }

    private void addDependencyTo(JavaDependency dependency, List<Dependency> dependencies) {
        if (dependency.scope() == JavaDependencyScope.TEST) {
            dependencies.add(this.toMavenDependency(dependency));
        } else {
            Dependency mavenDependency = this.toMavenDependency(dependency);
            this.insertDependencyBeforeFirstTestDependency(mavenDependency, dependencies);
        }
        this.writePom();
    }

    private void insertDependencyBeforeFirstTestDependency(Dependency mavenDependency, List<Dependency> dependencies) {
        List<Dependency> nonTestDependencies = dependencies.stream().filter(dependency -> !MavenScope.TEST.key().equals(dependency.getScope())).toList();
        if (nonTestDependencies.isEmpty()) {
            dependencies.add(mavenDependency);
        } else {
            dependencies.add(dependencies.indexOf(nonTestDependencies.getLast()) + 1, mavenDependency);
        }
    }

    private Dependency toMavenDependency(JavaDependency javaDependency) {
        Dependency mavenDependency = new Dependency();
        mavenDependency.setGroupId(javaDependency.id().groupId().get());
        mavenDependency.setArtifactId(javaDependency.id().artifactId().get());
        javaDependency.version().map(VersionSlug::mavenVariable).ifPresent(arg_0 -> ((Dependency)mavenDependency).setVersion(arg_0));
        javaDependency.classifier().map(JavaDependencyClassifier::get).ifPresent(arg_0 -> ((Dependency)mavenDependency).setClassifier(arg_0));
        javaDependency.type().map(type -> Enums.map(type, MavenType.class)).map(MavenType::key).ifPresent(arg_0 -> ((Dependency)mavenDependency).setType(arg_0));
        javaDependency.exclusions().stream().map(this.toMavenExclusion()).forEach(arg_0 -> ((Dependency)mavenDependency).addExclusion(arg_0));
        if (javaDependency.scope() != JavaDependencyScope.COMPILE) {
            mavenDependency.setScope(Enums.map(javaDependency.scope(), MavenScope.class).key());
        }
        if (javaDependency.optional()) {
            mavenDependency.setOptional(true);
        }
        return mavenDependency;
    }

    private Function<DependencyId, Exclusion> toMavenExclusion() {
        return dependencyId -> {
            Exclusion mavenExclusion = new Exclusion();
            mavenExclusion.setGroupId(dependencyId.groupId().get());
            mavenExclusion.setArtifactId(dependencyId.artifactId().get());
            return mavenExclusion;
        };
    }

    @Override
    public void handle(AddMavenPluginManagement command) {
        Assert.notNull(COMMAND, command);
        command.pluginVersion().ifPresent(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
        command.dependenciesVersions().forEach(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
        PluginManagement pluginManagement = command.buildProfile().map(this::findProfile).map(this::pluginManagement).orElse(this.pluginManagement());
        pluginManagement.addPlugin(this.toMavenPlugin(command));
        this.writePom();
    }

    private PluginManagement pluginManagement(Profile mavenProfile) {
        if (this.profileBuild(mavenProfile).getPluginManagement() == null) {
            this.profileBuild(mavenProfile).setPluginManagement(new PluginManagement());
        }
        return this.profileBuild(mavenProfile).getPluginManagement();
    }

    private PluginManagement pluginManagement() {
        if (this.projectBuild().getPluginManagement() == null) {
            this.projectBuild().setPluginManagement(new PluginManagement());
        }
        return this.projectBuild().getPluginManagement();
    }

    @Override
    public void handle(AddDirectMavenPlugin command) {
        Assert.notNull(COMMAND, command);
        command.pluginVersion().ifPresent(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
        command.dependenciesVersions().forEach(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
        BuildBase projectBuild = command.buildProfile().map(this::findProfile).map(this::profileBuild).orElse((BuildBase)this.projectBuild());
        projectBuild.addPlugin(this.toMavenPlugin(command));
        this.writePom();
    }

    private BuildBase profileBuild(Profile mavenProfile) {
        if (mavenProfile.getBuild() == null) {
            mavenProfile.setBuild((BuildBase)new Build());
        }
        return mavenProfile.getBuild();
    }

    @Override
    public void handle(AddGradlePlugin command) {
    }

    private Plugin toMavenPlugin(AddMavenPlugin command) {
        Plugin mavenPlugin = new Plugin();
        mavenPlugin.setArtifactId(command.dependencyId().artifactId().get());
        mavenPlugin.setGroupId(command.dependencyId().groupId().get());
        command.versionSlug().map(VersionSlug::mavenVariable).ifPresent(arg_0 -> ((Plugin)mavenPlugin).setVersion(arg_0));
        command.configuration().map(this.toMavenConfiguration()).ifPresent(arg_0 -> ((Plugin)mavenPlugin).setConfiguration(arg_0));
        command.executions().stream().map(this.toMavenExecution()).forEach(arg_0 -> ((Plugin)mavenPlugin).addExecution(arg_0));
        command.dependencies().stream().map(this::toMavenDependency).forEach(arg_0 -> ((Plugin)mavenPlugin).addDependency(arg_0));
        return mavenPlugin;
    }

    private Function<MavenPluginExecution, PluginExecution> toMavenExecution() {
        return execution -> {
            PluginExecution mavenExecution = new PluginExecution();
            execution.id().map(MavenPluginExecutionId::get).ifPresent(arg_0 -> ((PluginExecution)mavenExecution).setId(arg_0));
            execution.phase().map(MavenBuildPhase::mavenKey).ifPresent(arg_0 -> ((PluginExecution)mavenExecution).setPhase(arg_0));
            execution.goals().stream().map(MavenPluginExecutionGoal::get).forEach(arg_0 -> ((PluginExecution)mavenExecution).addGoal(arg_0));
            execution.configuration().map(this.toMavenConfiguration()).ifPresent(arg_0 -> ((PluginExecution)mavenExecution).setConfiguration(arg_0));
            return mavenExecution;
        };
    }

    private Function<MavenPluginConfiguration, Xpp3Dom> toMavenConfiguration() {
        return configuration -> {
            Xpp3Dom xpp3Dom;
            StringReader reader = new StringReader("<configuration>" + configuration.get() + "</configuration>");
            try {
                xpp3Dom = Xpp3DomBuilder.build((Reader)reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    throw new MalformedAdditionalInformationException(e);
                }
            }
            ((Reader)reader).close();
            return xpp3Dom;
        };
    }

    @ExcludeFromGeneratedCodeCoverage(reason="The exception handling is hard to test and an implementation detail")
    private void writePom() {
        try (BufferedWriter fileWriter = Files.newBufferedWriter(this.pomPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            StringWriter stringWriter = new StringWriter();
            mavenWriter.write((Writer)stringWriter, this.pomModel);
            fileWriter.write(this.applyIndentation(stringWriter.getBuffer().toString()));
        }
        catch (IOException e) {
            throw GeneratorException.technicalError("Error writing pom: " + e.getMessage(), e);
        }
    }

    private String applyIndentation(String pomContent) {
        if (this.indentation.spacesCount() == 2) {
            return pomContent;
        }
        return pomContent.replace(" ".repeat(2), this.indentation.spaces());
    }
}

