/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.javadependency;

import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.springframework.stereotype.Service;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectMavenPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradlePlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaBuildProfile;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenBuildExtension;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPluginManagement;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.SetBuildProperty;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.JavaDependenciesCommandHandler;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.MissingJavaBuildConfigurationException;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.gradle.GradleCommandHandler;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MavenCommandHandler;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

@Service
public class FileSystemJavaBuildCommandsHandler {
    public void handle(Indentation indentation, JHipsterProjectFolder projectFolder, JavaBuildCommands commands) {
        Assert.notNull("indentation", indentation);
        Assert.notNull("projectFolder", projectFolder);
        Assert.notNull("commands", commands);
        if (commands.isEmpty()) {
            return;
        }
        JavaDependenciesCommandHandler handler = FileSystemJavaBuildCommandsHandler.buildCommandHandler(indentation, projectFolder);
        commands.get().forEach(command -> this.handle(handler, (JavaBuildCommand)command));
    }

    private static JavaDependenciesCommandHandler buildCommandHandler(Indentation indentation, JHipsterProjectFolder projectFolder) {
        Path pomPath = projectFolder.filePath("pom.xml");
        if (Files.exists(pomPath, new LinkOption[0])) {
            return new MavenCommandHandler(indentation, pomPath);
        }
        if (Files.exists(projectFolder.filePath("build.gradle.kts"), new LinkOption[0])) {
            return new GradleCommandHandler(indentation, projectFolder);
        }
        throw new MissingJavaBuildConfigurationException(projectFolder);
    }

    @ExcludeFromGeneratedCodeCoverage(reason="Jacoco thinks there is a missed branch")
    private void handle(JavaDependenciesCommandHandler handler, JavaBuildCommand command) {
        JavaBuildCommand javaBuildCommand = command;
        Objects.requireNonNull(javaBuildCommand);
        JavaBuildCommand javaBuildCommand2 = javaBuildCommand;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SetVersion.class, SetBuildProperty.class, RemoveJavaDependencyManagement.class, AddJavaDependencyManagement.class, RemoveDirectJavaDependency.class, AddDirectJavaDependency.class, AddDirectMavenPlugin.class, AddMavenPluginManagement.class, AddMavenBuildExtension.class, AddJavaBuildProfile.class, AddGradlePlugin.class}, (Object)javaBuildCommand2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                SetVersion setVersion = (SetVersion)javaBuildCommand2;
                handler.handle(setVersion);
                break;
            }
            case 1: {
                SetBuildProperty setBuildProperty = (SetBuildProperty)javaBuildCommand2;
                handler.handle(setBuildProperty);
                break;
            }
            case 2: {
                RemoveJavaDependencyManagement removeJavaDependencyManagement = (RemoveJavaDependencyManagement)javaBuildCommand2;
                handler.handle(removeJavaDependencyManagement);
                break;
            }
            case 3: {
                AddJavaDependencyManagement addJavaDependencyManagement = (AddJavaDependencyManagement)javaBuildCommand2;
                handler.handle(addJavaDependencyManagement);
                break;
            }
            case 4: {
                RemoveDirectJavaDependency removeDirectJavaDependency = (RemoveDirectJavaDependency)javaBuildCommand2;
                handler.handle(removeDirectJavaDependency);
                break;
            }
            case 5: {
                AddDirectJavaDependency addDirectJavaDependency = (AddDirectJavaDependency)javaBuildCommand2;
                handler.handle(addDirectJavaDependency);
                break;
            }
            case 6: {
                AddDirectMavenPlugin addDirectMavenPlugin = (AddDirectMavenPlugin)javaBuildCommand2;
                handler.handle(addDirectMavenPlugin);
                break;
            }
            case 7: {
                AddMavenPluginManagement addMavenPluginManagement = (AddMavenPluginManagement)javaBuildCommand2;
                handler.handle(addMavenPluginManagement);
                break;
            }
            case 8: {
                AddMavenBuildExtension addMavenBuildExtension = (AddMavenBuildExtension)javaBuildCommand2;
                handler.handle(addMavenBuildExtension);
                break;
            }
            case 9: {
                AddJavaBuildProfile addJavaBuildProfile = (AddJavaBuildProfile)javaBuildCommand2;
                handler.handle(addJavaBuildProfile);
                break;
            }
            case 10: {
                AddGradlePlugin addGradlePlugin = (AddGradlePlugin)javaBuildCommand2;
                handler.handle(addGradlePlugin);
            }
        }
    }
}

