/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.error.domain.GeneratorException;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public class PropertiesFileSpringFactoriesHandler {
    private final Path file;
    private static final String EQUAL = "=";
    private static final String COLLECTION_SEPARATOR = ",";
    private static final String LINE_BREAK = System.lineSeparator();

    public PropertiesFileSpringFactoriesHandler(Path file) {
        Assert.notNull("file", file);
        this.file = file;
    }

    public void append(PropertyKey key, PropertyValue value) {
        Assert.notNull("key", key);
        Assert.notNull("value", value);
        this.updateFactories(key, value);
    }

    @ExcludeFromGeneratedCodeCoverage(reason="Hard to cover IOException")
    private void updateFactories(PropertyKey key, PropertyValue value) {
        try {
            String properties = this.buildFactories(key, value);
            Files.writeString(this.file, (CharSequence)properties, new OpenOption[0]);
        }
        catch (IOException e) {
            throw GeneratorException.technicalError("Error updating Spring Factories properties: " + e.getMessage(), e);
        }
    }

    private String buildFactories(PropertyKey key, PropertyValue value) throws IOException {
        String currentProperties = this.readOrInitFactories();
        int propertyIndex = currentProperties.indexOf(this.propertyId(key));
        if (propertyIndex != -1) {
            return PropertiesFileSpringFactoriesHandler.appendValuesToExistingPropertyKey(propertyIndex, value, currentProperties);
        }
        return this.addNewFactory(key, value, currentProperties);
    }

    private String addNewFactory(PropertyKey key, PropertyValue value, String currentProperties) {
        return currentProperties + this.propertyLine(key, value) + LINE_BREAK;
    }

    private static String appendValuesToExistingPropertyKey(int propertyIndex, PropertyValue value, String currentProperties) {
        StringBuilder newProperties = new StringBuilder(currentProperties);
        int eolIndex = newProperties.indexOf(LINE_BREAK, propertyIndex);
        for (Object propertyValue : value.get()) {
            if (newProperties.substring(propertyIndex, eolIndex).contains(propertyValue.toString())) continue;
            newProperties.insert(eolIndex, COLLECTION_SEPARATOR + String.valueOf(propertyValue));
            eolIndex = eolIndex + COLLECTION_SEPARATOR.length() + propertyValue.toString().length();
        }
        return newProperties.toString();
    }

    private String readOrInitFactories() throws IOException {
        if (Files.notExists(this.file, new LinkOption[0])) {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            Files.createFile(this.file, new FileAttribute[0]);
            return "";
        }
        return Files.readString(this.file);
    }

    private String propertyLine(PropertyKey key, PropertyValue value) {
        return this.propertyId(key) + PropertiesFileSpringFactoriesHandler.joinedPropertyValues(value);
    }

    private static String joinedPropertyValues(PropertyValue value) {
        return value.get().stream().map(Object::toString).collect(Collectors.joining(COLLECTION_SEPARATOR));
    }

    private String propertyId(PropertyKey key) {
        return key.get() + EQUAL;
    }
}

