/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.nio.file.Path;
import java.util.function.Consumer;
import org.springframework.stereotype.Service;
import tech.jhipster.lite.module.domain.javaproperties.SpringFactories;
import tech.jhipster.lite.module.domain.javaproperties.SpringFactory;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.PropertiesFileSpringFactoriesHandler;
import tech.jhipster.lite.shared.error.domain.Assert;

@Service
class FileSystemSpringFactoriesCommandsHandler {
    FileSystemSpringFactoriesCommandsHandler() {
    }

    public void handle(JHipsterProjectFolder projectFolder, SpringFactories factories) {
        Assert.notNull("projectFolder", projectFolder);
        Assert.notNull("factories", factories);
        factories.get().forEach(this.setProperty(projectFolder));
    }

    private Consumer<SpringFactory> setProperty(JHipsterProjectFolder projectFolder) {
        return property -> new PropertiesFileSpringFactoriesHandler(FileSystemSpringFactoriesCommandsHandler.getPath(projectFolder, property)).append(property.key(), property.value());
    }

    private static Path getPath(JHipsterProjectFolder projectFolder, SpringFactory factory) {
        switch (factory.type()) {
            default: {
                throw new MatchException(null, null);
            }
            case TEST_FACTORIES: 
        }
        return projectFolder.filePath("src/test/resources/META-INF/spring.factories");
    }
}

