/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.primary;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import tech.jhipster.lite.module.domain.JHipsterModuleSlug;
import tech.jhipster.lite.module.domain.JHipsterModulesToApply;
import tech.jhipster.lite.module.infrastructure.primary.RestJHipsterModuleProperties;
import tech.jhipster.lite.shared.projectfolder.domain.ProjectFolder;

@Schema(name="JHipsterModulesToApply", description="Information to apply multiple modules")
class RestJHipsterModulesToApply {
    private final Collection<String> modules;
    private final RestJHipsterModuleProperties properties;

    RestJHipsterModulesToApply(@JsonProperty(value="modules") Collection<String> modules, @JsonProperty(value="properties") RestJHipsterModuleProperties properties) {
        this.modules = modules;
        this.properties = properties;
    }

    public JHipsterModulesToApply toDomain(ProjectFolder projectFolder) {
        return new JHipsterModulesToApply(this.getModules().stream().map(JHipsterModuleSlug::new).toList(), this.properties.toDomain(projectFolder));
    }

    @NotEmpty
    @Schema(description="Slugs of the modules to apply", requiredMode=Schema.RequiredMode.REQUIRED)
    public Collection<String> getModules() {
        return this.modules;
    }

    @NotNull
    @Schema(description="Properties for the modules to apply")
    public RestJHipsterModuleProperties getProperties() {
        return this.properties;
    }
}

