/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.gradleplugin;

import java.util.Optional;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginConfiguration;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class GradleCorePlugin
implements GradlePlugin {
    private final GradlePluginId id;
    private final Optional<GradlePluginConfiguration> configuration;
    private final Optional<VersionSlug> toolVersionSlug;

    private GradleCorePlugin(GradleCorePluginBuilder builder) {
        Assert.notNull("id", builder.id);
        this.id = builder.id;
        this.configuration = Optional.ofNullable(builder.configuration);
        this.toolVersionSlug = Optional.ofNullable(builder.toolVersionSlug);
    }

    @Override
    public GradlePluginId id() {
        return this.id;
    }

    @Override
    public Optional<GradlePluginConfiguration> configuration() {
        return this.configuration;
    }

    public Optional<VersionSlug> toolVersionSlug() {
        return this.toolVersionSlug;
    }

    public static GradleCorePluginIdBuilder builder() {
        return new GradleCorePluginBuilder();
    }

    private static class GradleCorePluginBuilder
    implements GradleCorePluginIdBuilder,
    GradleCorePluginOptionalBuilder {
        private GradlePluginId id;
        private GradlePluginConfiguration configuration;
        private VersionSlug toolVersionSlug;

        private GradleCorePluginBuilder() {
        }

        @Override
        public GradleCorePluginOptionalBuilder id(GradlePluginId id) {
            this.id = id;
            return this;
        }

        @Override
        public GradleCorePluginOptionalBuilder configuration(GradlePluginConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public GradleCorePluginOptionalBuilder toolVersionSlug(VersionSlug versionSlug) {
            this.toolVersionSlug = versionSlug;
            return this;
        }

        @Override
        public GradleCorePlugin build() {
            return new GradleCorePlugin(this);
        }
    }

    public static interface GradleCorePluginOptionalBuilder {
        public GradleCorePluginOptionalBuilder configuration(GradlePluginConfiguration var1);

        default public GradleCorePluginOptionalBuilder configuration(String configuration) {
            return this.configuration(new GradlePluginConfiguration(configuration));
        }

        public GradleCorePluginOptionalBuilder toolVersionSlug(VersionSlug var1);

        default public GradleCorePluginOptionalBuilder toolVersionSlug(String versionSlug) {
            return this.toolVersionSlug(new VersionSlug(versionSlug));
        }

        public GradleCorePlugin build();
    }

    public static interface GradleCorePluginIdBuilder {
        public GradleCorePluginOptionalBuilder id(GradlePluginId var1);

        default public GradleCorePluginOptionalBuilder id(String id) {
            return this.id(new GradlePluginId(id));
        }
    }
}

