/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterModuleUpgrade;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterDestinations;
import tech.jhipster.lite.module.domain.file.JHipsterFileContent;
import tech.jhipster.lite.module.domain.file.JHipsterFileToMove;
import tech.jhipster.lite.module.domain.file.JHipsterFilesToDelete;
import tech.jhipster.lite.module.domain.file.JHipsterFilesToMove;
import tech.jhipster.lite.module.domain.file.JHipsterModuleFile;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.shared.collection.domain.JHipsterCollections;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterModuleFiles {
    private final Collection<JHipsterModuleFile> filesToAdd;
    private final JHipsterFilesToDelete filesToDelete;
    private final JHipsterFilesToMove filesToMove;

    private JHipsterModuleFiles(JHipsterModuleFilesBuilder builder) {
        this.filesToAdd = JHipsterCollections.immutable(builder.filesToAdd);
        this.filesToMove = new JHipsterFilesToMove(builder.filesToMove);
        this.filesToDelete = new JHipsterFilesToDelete(builder.filesToDelete);
    }

    private JHipsterModuleFiles(JHipsterModuleFiles source, JHipsterModuleUpgrade upgrade) {
        Assert.notNull("ignoredFiles", upgrade);
        this.filesToAdd = this.buildFilesToAdd(source, upgrade.skippedFiles());
        this.filesToDelete = source.filesToDelete.add(upgrade.filesToDelete());
        this.filesToMove = source.filesToMove;
    }

    private List<JHipsterModuleFile> buildFilesToAdd(JHipsterModuleFiles source, JHipsterDestinations skippedFiles) {
        return source.filesToAdd.stream().filter(file -> skippedFiles.doesNotContain(file.destination())).toList();
    }

    public static JHipsterModuleFilesBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleFilesBuilder(module);
    }

    public JHipsterModuleFiles forUpgrade(JHipsterModuleUpgrade upgrade) {
        return new JHipsterModuleFiles(this, upgrade);
    }

    public Collection<JHipsterModuleFile> filesToAdd() {
        return this.filesToAdd;
    }

    public JHipsterFilesToMove filesToMove() {
        return this.filesToMove;
    }

    public JHipsterFilesToDelete filesToDelete() {
        return this.filesToDelete;
    }

    public static class JHipsterModuleFilesBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Collection<JHipsterModuleFile> filesToAdd = new ArrayList<JHipsterModuleFile>();
        private final Collection<JHipsterFileToMove> filesToMove = new ArrayList<JHipsterFileToMove>();
        private final Collection<JHipsterProjectFilePath> filesToDelete = new ArrayList<JHipsterProjectFilePath>();

        private JHipsterModuleFilesBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModuleFilesBuilder add(JHipsterSource source, JHipsterDestination destination) {
            this.filesToAdd.add(new JHipsterModuleFile(new JHipsterFileContent(source), destination, false));
            return this;
        }

        public JHipsterModuleFilesBuilder addExecutable(JHipsterSource source, JHipsterDestination destination) {
            this.filesToAdd.add(new JHipsterModuleFile(new JHipsterFileContent(source), destination, true));
            return this;
        }

        public JHipsterModuleFileBatchBuilder batch(JHipsterSource source, JHipsterDestination destination) {
            return new JHipsterModuleFileBatchBuilder(source, destination, this);
        }

        public JHipsterModuleFilesBuilder move(JHipsterProjectFilePath source, JHipsterDestination destination) {
            this.filesToMove.add(new JHipsterFileToMove(source, destination));
            return this;
        }

        public JHipsterModuleFilesBuilder delete(JHipsterProjectFilePath path) {
            Assert.notNull("path", path);
            this.filesToDelete.add(path);
            return this;
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        public JHipsterModuleFiles build() {
            return new JHipsterModuleFiles(this);
        }
    }

    public static class JHipsterModuleFileBatchBuilder {
        private final JHipsterSource source;
        private final JHipsterDestination destination;
        private final JHipsterModuleFilesBuilder files;

        private JHipsterModuleFileBatchBuilder(JHipsterSource source, JHipsterDestination destination, JHipsterModuleFilesBuilder files) {
            this.source = source;
            this.destination = destination;
            this.files = files;
        }

        public JHipsterModuleFileBatchBuilder addTemplate(String file) {
            return this.add(this.source.template(file), this.destination.append(file));
        }

        public JHipsterModuleFileBatchBuilder addFile(String file) {
            return this.add(this.source.file(file), this.destination.append(file));
        }

        private JHipsterModuleFileBatchBuilder add(JHipsterSource source, JHipsterDestination destination) {
            this.files.add(source, destination);
            return this;
        }

        public JHipsterModuleFilesBuilder and() {
            return this.files;
        }
    }
}

