/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.file;

import java.nio.charset.StandardCharsets;
import tech.jhipster.lite.module.domain.JHipsterModuleContext;
import tech.jhipster.lite.module.domain.ProjectFiles;
import tech.jhipster.lite.module.domain.file.ArgumentsReplacer;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.shared.error.domain.Assert;

class JHipsterFileContent {
    private final JHipsterSource source;

    JHipsterFileContent(JHipsterSource source) {
        Assert.notNull("source", source);
        this.source = source;
    }

    public byte[] read(ProjectFiles files, JHipsterModuleContext context) {
        Assert.notNull("files", files);
        Assert.notNull("context", context);
        if (this.source.isNotTemplate()) {
            return files.readBytes(this.source.get().toString());
        }
        String rawContent = files.readString(this.source.get().toString());
        return ArgumentsReplacer.replaceArguments(rawContent, context.get()).getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        return this.source.toString();
    }
}

