/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import java.nio.file.Paths;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import tech.jhipster.lite.module.domain.DocumentationTitle;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterFileMatcher;
import tech.jhipster.lite.module.domain.JHipsterModuleContext;
import tech.jhipster.lite.module.domain.JHipsterModulePreActions;
import tech.jhipster.lite.module.domain.JHipsterModuleShortcuts;
import tech.jhipster.lite.module.domain.JHipsterModuleUpgrade;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.LocalEnvironment;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.buildproperties.PropertyKey;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterFilesToDelete;
import tech.jhipster.lite.module.domain.file.JHipsterFilesToMove;
import tech.jhipster.lite.module.domain.file.JHipsterModuleFile;
import tech.jhipster.lite.module.domain.file.JHipsterModuleFiles;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.file.JHipsterTemplatedFile;
import tech.jhipster.lite.module.domain.file.JHipsterTemplatedFiles;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCommunityPlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCorePlugin;
import tech.jhipster.lite.module.domain.gradleplugin.JHipsterModuleGradlePlugin;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.JHipsterModuleMavenBuildExtensions;
import tech.jhipster.lite.module.domain.javabuild.MavenBuildExtension;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileActivation;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileId;
import tech.jhipster.lite.module.domain.javabuildprofile.JHipsterModuleJavaBuildProfiles;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JHipsterModuleJavaDependencies;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.javaproperties.Comment;
import tech.jhipster.lite.module.domain.javaproperties.JHipsterModuleSpringFactories;
import tech.jhipster.lite.module.domain.javaproperties.JHipsterModuleSpringProperties;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.javaproperties.SpringComment;
import tech.jhipster.lite.module.domain.javaproperties.SpringComments;
import tech.jhipster.lite.module.domain.javaproperties.SpringFactories;
import tech.jhipster.lite.module.domain.javaproperties.SpringFactory;
import tech.jhipster.lite.module.domain.javaproperties.SpringFactoryType;
import tech.jhipster.lite.module.domain.javaproperties.SpringProfile;
import tech.jhipster.lite.module.domain.javaproperties.SpringProperties;
import tech.jhipster.lite.module.domain.javaproperties.SpringProperty;
import tech.jhipster.lite.module.domain.javaproperties.SpringPropertyType;
import tech.jhipster.lite.module.domain.mavenplugin.JHipsterModuleMavenPlugins;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecution;
import tech.jhipster.lite.module.domain.packagejson.JHipsterModulePackageJson;
import tech.jhipster.lite.module.domain.packagejson.PackageName;
import tech.jhipster.lite.module.domain.packagejson.ScriptCommand;
import tech.jhipster.lite.module.domain.packagejson.ScriptKey;
import tech.jhipster.lite.module.domain.postaction.JHipsterModulePostActions;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.domain.replacement.FileStartReplacer;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleOptionalReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.RegexNeedleAfterReplacer;
import tech.jhipster.lite.module.domain.replacement.RegexNeedleBeforeReplacer;
import tech.jhipster.lite.module.domain.replacement.RegexReplacer;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;
import tech.jhipster.lite.module.domain.replacement.TextNeedleAfterReplacer;
import tech.jhipster.lite.module.domain.replacement.TextNeedleBeforeReplacer;
import tech.jhipster.lite.module.domain.replacement.TextReplacer;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterModule {
    public static final String LINE_BREAK = "\n";
    private final JHipsterModuleProperties properties;
    private final JHipsterModuleFiles files;
    private final JHipsterModuleMandatoryReplacementsFactory mandatoryReplacements;
    private final JHipsterModuleOptionalReplacementsFactory optionalReplacements;
    private final JHipsterModuleContext context;
    private final JHipsterModuleJavaDependencies javaDependencies;
    private final JHipsterModuleJavaBuildProfiles javaBuildProfiles;
    private final JHipsterModuleMavenPlugins mavenPlugins;
    private final JHipsterModuleGradlePlugin gradlePlugins;
    private final JHipsterModuleMavenBuildExtensions mavenBuildExtensions;
    private final JHipsterModulePackageJson packageJson;
    private final JHipsterModulePreActions preActions;
    private final JHipsterModulePostActions postActions;
    private final SpringProperties springProperties;
    private final SpringComments springComments;
    private final SpringFactories springFactories;

    private JHipsterModule(JHipsterModuleBuilder builder) {
        this.properties = builder.properties;
        this.files = builder.files.build();
        this.mandatoryReplacements = builder.mandatoryReplacements.build();
        this.optionalReplacements = builder.optionalReplacements.build();
        this.context = builder.context.build();
        this.javaDependencies = builder.javaDependencies.build();
        this.javaBuildProfiles = builder.javaBuildProfiles.build();
        this.mavenPlugins = builder.mavenPlugins.build();
        this.gradlePlugins = builder.gradlePlugins.build();
        this.mavenBuildExtensions = builder.mavenBuildExtensions.build();
        this.packageJson = builder.packageJson.build();
        this.preActions = builder.preActions.build();
        this.postActions = builder.postActions.build();
        this.springProperties = this.buildSpringProperties(builder);
        this.springComments = this.buildSpringComments(builder);
        this.springFactories = this.buildSpringFactories(builder);
    }

    private JHipsterModule(JHipsterModule source, JHipsterModuleUpgrade upgrade) {
        Assert.notNull("upgrade", upgrade);
        this.properties = source.properties;
        this.files = source.files.forUpgrade(upgrade);
        this.mandatoryReplacements = source.mandatoryReplacements;
        this.optionalReplacements = source.optionalReplacements.add(upgrade.replacements());
        this.context = source.context;
        this.javaDependencies = source.javaDependencies;
        this.javaBuildProfiles = source.javaBuildProfiles;
        this.mavenPlugins = source.mavenPlugins;
        this.gradlePlugins = source.gradlePlugins;
        this.mavenBuildExtensions = source.mavenBuildExtensions;
        this.packageJson = source.packageJson;
        this.preActions = source.preActions;
        this.postActions = source.postActions;
        this.springProperties = source.springProperties;
        this.springComments = source.springComments;
        this.springFactories = source.springFactories;
    }

    private SpringProperties buildSpringProperties(JHipsterModuleBuilder builder) {
        return new SpringProperties(builder.springProperties.entrySet().stream().flatMap(this.toSpringProperties()).toList());
    }

    private Function<Map.Entry<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder>, Stream<SpringProperty>> toSpringProperties() {
        return inputProperties -> ((JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder)inputProperties.getValue()).build().properties().entrySet().stream().map(this.toSpringProperty((Map.Entry<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder>)inputProperties));
    }

    private Function<Map.Entry<tech.jhipster.lite.module.domain.javaproperties.PropertyKey, PropertyValue>, SpringProperty> toSpringProperty(Map.Entry<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder> inputProperties) {
        return property -> SpringProperty.builder(((PropertiesKey)inputProperties.getKey()).type()).key((tech.jhipster.lite.module.domain.javaproperties.PropertyKey)property.getKey()).value((PropertyValue)property.getValue()).profile(((PropertiesKey)inputProperties.getKey()).profile()).build();
    }

    private SpringComments buildSpringComments(JHipsterModuleBuilder builder) {
        return new SpringComments(builder.springProperties.entrySet().stream().flatMap(this.toSpringComments()).toList());
    }

    private Function<Map.Entry<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder>, Stream<SpringComment>> toSpringComments() {
        return inputProperties -> ((JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder)inputProperties.getValue()).build().comments().entrySet().stream().map(this.toSpringComment((Map.Entry<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder>)inputProperties));
    }

    private Function<Map.Entry<tech.jhipster.lite.module.domain.javaproperties.PropertyKey, Comment>, SpringComment> toSpringComment(Map.Entry<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder> inputProperties) {
        return propertyComment -> SpringComment.builder(((PropertiesKey)inputProperties.getKey()).type()).key((tech.jhipster.lite.module.domain.javaproperties.PropertyKey)propertyComment.getKey()).comment((Comment)propertyComment.getValue()).profile(((PropertiesKey)inputProperties.getKey()).profile()).build();
    }

    private SpringFactories buildSpringFactories(JHipsterModuleBuilder builder) {
        return new SpringFactories(builder.springFactories.entrySet().stream().flatMap(this.toSpringFactories()).toList());
    }

    private Function<Map.Entry<SpringFactoryType, JHipsterModuleSpringFactories.JHipsterModuleSpringFactoriesBuilder>, Stream<SpringFactory>> toSpringFactories() {
        return inputFactories -> ((JHipsterModuleSpringFactories.JHipsterModuleSpringFactoriesBuilder)inputFactories.getValue()).build().factories().entrySet().stream().map(this.toSpringFactory((Map.Entry<SpringFactoryType, JHipsterModuleSpringFactories.JHipsterModuleSpringFactoriesBuilder>)inputFactories));
    }

    private Function<Map.Entry<tech.jhipster.lite.module.domain.javaproperties.PropertyKey, PropertyValue>, SpringFactory> toSpringFactory(Map.Entry<SpringFactoryType, JHipsterModuleSpringFactories.JHipsterModuleSpringFactoriesBuilder> inputFactories) {
        return property -> SpringFactory.builder((SpringFactoryType)((Object)((Object)inputFactories.getKey()))).key((tech.jhipster.lite.module.domain.javaproperties.PropertyKey)property.getKey()).value((PropertyValue)property.getValue());
    }

    public static JHipsterModuleBuilder moduleBuilder(JHipsterModuleProperties properties) {
        return new JHipsterModuleBuilder(properties);
    }

    public static JavaDependency.JavaDependencyGroupIdBuilder javaDependency() {
        return JavaDependency.builder();
    }

    public static MavenBuildExtension.MavenBuildExtensionGroupIdBuilder mavenBuildExtension() {
        return MavenBuildExtension.builder();
    }

    public static JavaDependencyVersion javaDependencyVersion(String slug, String version) {
        return new JavaDependencyVersion(slug, version);
    }

    public static DependencyId dependencyId(String groupId, String artifactId) {
        return DependencyId.of(JHipsterModule.groupId(groupId), JHipsterModule.artifactId(artifactId));
    }

    public static MavenPlugin.MavenPluginGroupIdBuilder mavenPlugin() {
        return MavenPlugin.builder();
    }

    public static JHipsterSource from(String source) {
        Assert.notBlank("source", source);
        return new JHipsterSource(Paths.get("/generator", source));
    }

    public static JHipsterProjectFilePath path(String path) {
        return new JHipsterProjectFilePath(path);
    }

    public static JHipsterDestination to(String destination) {
        return new JHipsterDestination(destination);
    }

    public static JHipsterDestination toSrcMainJava() {
        return JHipsterDestination.SRC_MAIN_JAVA;
    }

    public static JHipsterDestination toSrcMainDocker() {
        return JHipsterDestination.SRC_MAIN_DOCKER;
    }

    public static JHipsterDestination toSrcTestJava() {
        return JHipsterDestination.SRC_TEST_JAVA;
    }

    public static JHipsterDestination toSrcMainResources() {
        return JHipsterDestination.SRC_MAIN_RESOURCES;
    }

    public static JHipsterFileMatcher filesWithExtension(String extension) {
        return path -> StringUtils.endsWithIgnoreCase((CharSequence)path.get(), (CharSequence)("." + extension));
    }

    public static GroupId groupId(String groupId) {
        return new GroupId(groupId);
    }

    public static ArtifactId artifactId(String artifactId) {
        return new ArtifactId(artifactId);
    }

    public static VersionSlug versionSlug(String versionSlug) {
        return new VersionSlug(versionSlug);
    }

    public static TextReplacer text(String text) {
        return new TextReplacer(ReplacementCondition.always(), text);
    }

    public static RegexReplacer regex(String regex) {
        return new RegexReplacer(ReplacementCondition.always(), regex);
    }

    public static FileStartReplacer fileStart() {
        return new FileStartReplacer(ReplacementCondition.notContainingReplacement());
    }

    public static TextNeedleBeforeReplacer lineBeforeText(String needle) {
        return new TextNeedleBeforeReplacer(ReplacementCondition.notContainingReplacement(), needle);
    }

    public static TextNeedleAfterReplacer lineAfterText(String needle) {
        return new TextNeedleAfterReplacer(ReplacementCondition.notContainingReplacement(), needle);
    }

    public static RegexNeedleBeforeReplacer lineBeforeRegex(String regex) {
        return new RegexNeedleBeforeReplacer(ReplacementCondition.notContainingReplacement(), Pattern.compile(regex, 8));
    }

    public static RegexNeedleAfterReplacer lineAfterRegex(String regex) {
        return new RegexNeedleAfterReplacer(ReplacementCondition.notContainingReplacement(), Pattern.compile(regex, 8));
    }

    public static BuildProfileId buildProfileId(String id) {
        return new BuildProfileId(id);
    }

    public static PropertyKey buildPropertyKey(String key) {
        return new PropertyKey(key);
    }

    public static tech.jhipster.lite.module.domain.buildproperties.PropertyValue buildPropertyValue(String value) {
        return new tech.jhipster.lite.module.domain.buildproperties.PropertyValue(value);
    }

    public static BuildProfileActivation.BuildProfileActivationBuilder buildProfileActivation() {
        return BuildProfileActivation.builder();
    }

    public static MavenPluginExecution.MavenPluginExecutionGoalsBuilder pluginExecution() {
        return MavenPluginExecution.builder();
    }

    public static tech.jhipster.lite.module.domain.javaproperties.PropertyKey propertyKey(String key) {
        return new tech.jhipster.lite.module.domain.javaproperties.PropertyKey(key);
    }

    public static PropertyValue propertyValue(String ... values) {
        return PropertyValue.of(values);
    }

    public static PropertyValue propertyValue(Boolean ... values) {
        return PropertyValue.of(values);
    }

    public static PropertyValue propertyValue(Number ... values) {
        return PropertyValue.of(values);
    }

    public static SpringProfile springProfile(String profile) {
        return new SpringProfile(profile);
    }

    public static Comment comment(String value) {
        return new Comment(value);
    }

    public static DocumentationTitle documentationTitle(String title) {
        return new DocumentationTitle(title);
    }

    public static LocalEnvironment localEnvironment(String localEnvironment) {
        return new LocalEnvironment(localEnvironment);
    }

    public static ScriptKey scriptKey(String key) {
        return new ScriptKey(key);
    }

    public static ScriptCommand scriptCommand(String command) {
        return new ScriptCommand(command);
    }

    public static PackageName packageName(String packageName) {
        return new PackageName(packageName);
    }

    public static GradleCorePlugin.GradleCorePluginIdBuilder gradleCorePlugin() {
        return GradleCorePlugin.builder();
    }

    public static GradleCommunityPlugin.GradleCommunityPluginIdBuilder gradleCommunityPlugin() {
        return GradleCommunityPlugin.builder();
    }

    public JHipsterModule withUpgrade(JHipsterModuleUpgrade upgrade) {
        return new JHipsterModule(this, upgrade);
    }

    public JHipsterProjectFolder projectFolder() {
        return this.properties.projectFolder();
    }

    public JHipsterModuleProperties properties() {
        return this.properties;
    }

    public Indentation indentation() {
        return this.properties.indentation();
    }

    public JHipsterTemplatedFiles templatedFiles() {
        List<JHipsterTemplatedFile> templatedFiles = this.files.filesToAdd().stream().map(file -> JHipsterTemplatedFile.builder().file((JHipsterModuleFile)file).context(this.context).build()).toList();
        return new JHipsterTemplatedFiles(templatedFiles);
    }

    public JHipsterFilesToMove filesToMove() {
        return this.files.filesToMove();
    }

    public JHipsterFilesToDelete filesToDelete() {
        return this.files.filesToDelete();
    }

    public JHipsterModuleMandatoryReplacementsFactory mandatoryReplacements() {
        return this.mandatoryReplacements;
    }

    public JHipsterModuleOptionalReplacementsFactory optionalReplacements() {
        return this.optionalReplacements;
    }

    public JHipsterModuleJavaDependencies javaDependencies() {
        return this.javaDependencies;
    }

    public JHipsterModuleJavaBuildProfiles javaBuildProfiles() {
        return this.javaBuildProfiles;
    }

    public JHipsterModuleMavenPlugins mavenPlugins() {
        return this.mavenPlugins;
    }

    public JHipsterModuleGradlePlugin gradlePlugins() {
        return this.gradlePlugins;
    }

    public JHipsterModuleMavenBuildExtensions mavenBuildExtensions() {
        return this.mavenBuildExtensions;
    }

    public JHipsterModulePackageJson packageJson() {
        return this.packageJson;
    }

    public JHipsterModulePreActions preActions() {
        return this.preActions;
    }

    public JHipsterModulePostActions postActions() {
        return this.postActions;
    }

    public SpringComments springComments() {
        return this.springComments;
    }

    public SpringProperties springProperties() {
        return this.springProperties;
    }

    public SpringFactories springFactories() {
        return this.springFactories;
    }

    public static class JHipsterModuleBuilder {
        private static final String PROFILE = "profile";
        private final JHipsterModuleShortcuts shortcuts;
        private final JHipsterModuleProperties properties;
        private final JHipsterModuleContext.JHipsterModuleContextBuilder context;
        private final JHipsterModuleFiles.JHipsterModuleFilesBuilder files = JHipsterModuleFiles.builder(this);
        private final JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder mandatoryReplacements = JHipsterModuleMandatoryReplacementsFactory.builder(this);
        private final JHipsterModuleOptionalReplacementsFactory.JHipsterModuleOptionalReplacementsFactoryBuilder optionalReplacements = JHipsterModuleOptionalReplacementsFactory.builder(this);
        private final JHipsterModuleJavaDependencies.JHipsterModuleJavaDependenciesBuilder javaDependencies = JHipsterModuleJavaDependencies.builder(this);
        private final JHipsterModuleJavaBuildProfiles.JHipsterModuleJavaBuildProfilesBuilder javaBuildProfiles = JHipsterModuleJavaBuildProfiles.builder(this);
        private final JHipsterModuleMavenPlugins.JHipsterModuleMavenPluginsBuilder<JHipsterModuleBuilder> mavenPlugins = JHipsterModuleMavenPlugins.builder(this);
        private final JHipsterModuleGradlePlugin.JHipsterModuleGradlePluginBuilder gradlePlugins = JHipsterModuleGradlePlugin.builder(this);
        private final JHipsterModuleMavenBuildExtensions.JHipsterModuleMavenBuildExtensionsBuilder mavenBuildExtensions = JHipsterModuleMavenBuildExtensions.builder(this);
        private final JHipsterModulePackageJson.JHipsterModulePackageJsonBuilder packageJson = JHipsterModulePackageJson.builder(this);
        private final JHipsterModulePreActions.JHipsterModulePreActionsBuilder preActions = JHipsterModulePreActions.builder(this);
        private final JHipsterModulePostActions.JHipsterModulePostActionsBuilder postActions = JHipsterModulePostActions.builder(this);
        private final Map<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder> springProperties = new HashMap<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder>();
        private final Map<SpringFactoryType, JHipsterModuleSpringFactories.JHipsterModuleSpringFactoriesBuilder> springFactories = new EnumMap<SpringFactoryType, JHipsterModuleSpringFactories.JHipsterModuleSpringFactoriesBuilder>(SpringFactoryType.class);

        private JHipsterModuleBuilder(JHipsterModuleProperties properties) {
            Assert.notNull("properties", properties);
            this.properties = properties;
            this.context = JHipsterModuleContext.builder(this);
            this.shortcuts = new JHipsterModuleShortcuts(this);
        }

        JHipsterModuleProperties properties() {
            return this.properties;
        }

        public JHipsterModuleBuilder documentation(DocumentationTitle title, JHipsterSource source) {
            this.shortcuts.documentation(title, source);
            return this;
        }

        public JHipsterModuleBuilder localEnvironment(LocalEnvironment localEnvironment) {
            this.shortcuts.localEnvironment(localEnvironment);
            return this;
        }

        public JHipsterModuleBuilder startupCommand(String startupCommand) {
            this.shortcuts.startupCommand(startupCommand);
            return this;
        }

        public JHipsterModuleBuilder prerequisites(String prerequisites) {
            this.shortcuts.prerequisites(prerequisites);
            return this;
        }

        public JHipsterModuleContext.JHipsterModuleContextBuilder context() {
            return this.context;
        }

        public JHipsterModuleFiles.JHipsterModuleFilesBuilder files() {
            return this.files;
        }

        public JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder mandatoryReplacements() {
            return this.mandatoryReplacements;
        }

        public JHipsterModuleBuilder springTestLogger(String name, LogLevel level) {
            this.shortcuts.springTestLogger(name, level);
            return this;
        }

        public JHipsterModuleBuilder springMainLogger(String name, LogLevel level) {
            this.shortcuts.springMainLogger(name, level);
            return this;
        }

        public JHipsterModuleBuilder integrationTestExtension(String extensionClass) {
            this.shortcuts.integrationTestExtension(extensionClass);
            return this;
        }

        public JHipsterModuleOptionalReplacementsFactory.JHipsterModuleOptionalReplacementsFactoryBuilder optionalReplacements() {
            return this.optionalReplacements;
        }

        public JHipsterModuleJavaDependencies.JHipsterModuleJavaDependenciesBuilder javaDependencies() {
            return this.javaDependencies;
        }

        public JHipsterModuleJavaBuildProfiles.JHipsterModuleJavaBuildProfilesBuilder javaBuildProfiles() {
            return this.javaBuildProfiles;
        }

        public JHipsterModuleMavenPlugins.JHipsterModuleMavenPluginsBuilder<JHipsterModuleBuilder> mavenPlugins() {
            return this.mavenPlugins;
        }

        public JHipsterModuleGradlePlugin.JHipsterModuleGradlePluginBuilder gradlePlugins() {
            return this.gradlePlugins;
        }

        public JHipsterModuleMavenBuildExtensions.JHipsterModuleMavenBuildExtensionsBuilder mavenBuildExtensions() {
            return this.mavenBuildExtensions;
        }

        public JHipsterModulePackageJson.JHipsterModulePackageJsonBuilder packageJson() {
            return this.packageJson;
        }

        public JHipsterModulePreActions.JHipsterModulePreActionsBuilder preActions() {
            return this.preActions;
        }

        public JHipsterModulePostActions.JHipsterModulePostActionsBuilder postActions() {
            return this.postActions;
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springMainProperties() {
            return this.springMainProperties(SpringProfile.DEFAULT);
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springLocalProperties() {
            return this.springMainProperties(SpringProfile.LOCAL);
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springMainBootstrapProperties() {
            return this.springMainBootstrapProperties(SpringProfile.DEFAULT);
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springMainBootstrapProperties(SpringProfile profile) {
            Assert.notNull(PROFILE, profile);
            return this.springProperties.computeIfAbsent(new PropertiesKey(profile, SpringPropertyType.MAIN_BOOTSTRAP_PROPERTIES), key -> JHipsterModuleSpringProperties.builder(this));
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springMainProperties(SpringProfile profile) {
            Assert.notNull(PROFILE, profile);
            return this.springProperties.computeIfAbsent(new PropertiesKey(profile, SpringPropertyType.MAIN_PROPERTIES), key -> JHipsterModuleSpringProperties.builder(this));
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springTestProperties() {
            return this.springTestProperties(SpringProfile.TEST);
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springTestBootstrapProperties() {
            return this.springProperties.computeIfAbsent(new PropertiesKey(SpringProfile.DEFAULT, SpringPropertyType.TEST_BOOTSTRAP_PROPERTIES), key -> JHipsterModuleSpringProperties.builder(this));
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springTestProperties(SpringProfile profile) {
            Assert.notNull(PROFILE, profile);
            return this.springProperties.computeIfAbsent(new PropertiesKey(profile, SpringPropertyType.TEST_PROPERTIES), key -> JHipsterModuleSpringProperties.builder(this));
        }

        public JHipsterModuleSpringFactories.JHipsterModuleSpringFactoriesBuilder springTestFactories() {
            return this.springFactories.computeIfAbsent(SpringFactoryType.TEST_FACTORIES, key -> JHipsterModuleSpringFactories.builder(this));
        }

        String packagePath() {
            return this.properties.basePackage().path();
        }

        Indentation indentation() {
            return this.properties.indentation();
        }

        public JHipsterModule build() {
            return new JHipsterModule(this);
        }
    }

    private record PropertiesKey(SpringProfile profile, SpringPropertyType type) {
    }
}

