/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.technicaltools.gitinfo.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCommunityPlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePlugin;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class GitInfoModuleFactory {
    private static final String PACKAGE_INFO = "package-info.java";
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/technicaltools/gitinfo");
    private static final JHipsterSource MAIN_SOURCE = SOURCE.append("main");
    private static final String PRIMARY = "/infrastructure/primary";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        JHipsterDestination mainDestination = JHipsterModule.toSrcMainJava().append(packagePath).append("wire/gitinfo");
        return JHipsterModule.moduleBuilder(properties).files().add(MAIN_SOURCE.template("GitInfoConfiguration.java"), mainDestination.append(PRIMARY).append("GitInfoConfiguration.java")).add(MAIN_SOURCE.template(PACKAGE_INFO), mainDestination.append(PACKAGE_INFO)).and().springMainProperties().comment(JHipsterModule.propertyKey("management.info.git"), JHipsterModule.comment("Git Information")).set(JHipsterModule.propertyKey("management.info.git.mode"), JHipsterModule.propertyValue("full")).set(JHipsterModule.propertyKey("management.info.git.enabled"), JHipsterModule.propertyValue(true)).set(JHipsterModule.propertyKey("management.info.env.enabled"), JHipsterModule.propertyValue(true)).and().mavenPlugins().plugin(this.gitCommitIdPlugin()).pluginManagement(this.gitCommitIdPluginManagement()).and().gradlePlugins().plugin(this.gradleGitPropertiesPlugin()).and().build();
    }

    private GradlePlugin gradleGitPropertiesPlugin() {
        return GradleCommunityPlugin.builder().id("com.gorylenko.gradle-git-properties").pluginSlug("git-properties").versionSlug("git-properties").configuration("gitProperties {\n  failOnNoGitDirectory = false\n  keys = listOf(\"git.branch\", \"git.commit.id.abbrev\", \"git.commit.id.describe\", \"git.build.version\")\n}\n").build();
    }

    private MavenPlugin gitCommitIdPluginManagement() {
        return MavenPlugin.builder().groupId("io.github.git-commit-id").artifactId("git-commit-id-maven-plugin").versionSlug("git-commit-id-plugin").configuration("  <failOnNoGitDirectory>false</failOnNoGitDirectory>\n  <failOnUnableToExtractRepoInfo>false</failOnUnableToExtractRepoInfo>\n  <generateGitPropertiesFile>true</generateGitPropertiesFile>\n  <includeOnlyProperties>\n    <includeOnlyProperty>^git.commit.id.abbrev$</includeOnlyProperty>\n    <includeOnlyProperty>^git.commit.id.describe$</includeOnlyProperty>\n    <includeOnlyProperty>^git.branch$</includeOnlyProperty>\n    <includeOnlyProperty>^git.build.(time|version)$</includeOnlyProperty>\n  </includeOnlyProperties>\n  <verbose>false</verbose>\n").addExecution(JHipsterModule.pluginExecution().goals("revision")).build();
    }

    private MavenPlugin gitCommitIdPlugin() {
        return JHipsterModule.mavenPlugin().groupId("io.github.git-commit-id").artifactId("git-commit-id-maven-plugin").build();
    }
}

