/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.springcloud.eureka.domain;

import tech.jhipster.lite.generator.base64.domain.Base64Utils;
import tech.jhipster.lite.generator.server.springboot.springcloud.common.domain.SpringCloudModuleDependencies;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class EurekaModuleFactory {
    private static final PropertyValue TRUE_VALUE = JHipsterModule.propertyValue(true);
    private static final PropertyValue FALSE_VALUE = JHipsterModule.propertyValue(false);
    private static final JHipsterSource SPRING_CLOUD_SOURCE = JHipsterModule.from("server/springboot/springcloud/configclient");
    private static final JHipsterSource EUREKA_SOURCE = JHipsterModule.from("server/springboot/springcloud/eureka");
    private final DockerImages dockerImages;

    public EurekaModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String baseName = properties.projectBaseName().get();
        String lowerCaseBaseName = baseName.toLowerCase();
        return JHipsterModule.moduleBuilder(properties).context().put("jhipsterRegistryDockerImage", this.dockerImages.get("jhipster/jhipster-registry").fullName()).put("base64JwtSecret", Base64Utils.getBase64Secret()).and().javaDependencies().addDependencyManagement(SpringCloudModuleDependencies.springCloudDependenciesManagement()).addDependency(SpringCloudModuleDependencies.SPRING_CLOUD_GROUP, JHipsterModule.artifactId("spring-cloud-starter-bootstrap")).addDependency(SpringCloudModuleDependencies.SPRING_CLOUD_GROUP, JHipsterModule.artifactId("spring-cloud-starter-netflix-eureka-client"), JHipsterModule.versionSlug("spring-cloud-netflix-eureka-client")).and().files().add(SPRING_CLOUD_SOURCE.template("jhipster-registry.yml"), JHipsterModule.to("src/main/docker/jhipster-registry.yml")).add(EUREKA_SOURCE.template("application.config.properties"), JHipsterModule.to("src/main/docker/central-server-config/localhost-config/application.properties")).and().springMainBootstrapProperties().set(JHipsterModule.propertyKey("spring.application.name"), JHipsterModule.propertyValue(baseName)).set(JHipsterModule.propertyKey("spring.cloud.compatibility-verifier.enabled"), FALSE_VALUE).set(JHipsterModule.propertyKey("eureka.client.service-url.defaultZone"), JHipsterModule.propertyValue("http://admin:admin@localhost:8761/eureka")).set(JHipsterModule.propertyKey("eureka.client.enabled"), TRUE_VALUE).set(JHipsterModule.propertyKey("eureka.client.healthcheck.enabled"), TRUE_VALUE).set(JHipsterModule.propertyKey("eureka.client.fetch-registry"), TRUE_VALUE).set(JHipsterModule.propertyKey("eureka.client.register-with-eureka"), TRUE_VALUE).set(JHipsterModule.propertyKey("eureka.client.instance-info-replication-interval-seconds"), JHipsterModule.propertyValue(10)).set(JHipsterModule.propertyKey("eureka.client.registry-fetch-interval-seconds"), JHipsterModule.propertyValue(10)).set(JHipsterModule.propertyKey("eureka.instance.appname"), JHipsterModule.propertyValue(lowerCaseBaseName)).set(JHipsterModule.propertyKey("eureka.instance.instance-id"), JHipsterModule.propertyValue(this.instanceId(lowerCaseBaseName))).set(JHipsterModule.propertyKey("eureka.instance.lease-renewal-interval-in-seconds"), JHipsterModule.propertyValue(5)).set(JHipsterModule.propertyKey("eureka.instance.lease-expiration-duration-in-seconds"), JHipsterModule.propertyValue(10)).set(JHipsterModule.propertyKey("eureka.instance.status-page-url-path"), JHipsterModule.propertyValue("${management.endpoints.web.base-path}/info")).set(JHipsterModule.propertyKey("eureka.instance.health-check-url-path"), JHipsterModule.propertyValue("${management.endpoints.web.base-path}/health")).and().springTestBootstrapProperties().set(JHipsterModule.propertyKey("spring.application.name"), JHipsterModule.propertyValue(baseName)).set(JHipsterModule.propertyKey("eureka.client.enabled"), FALSE_VALUE).set(JHipsterModule.propertyKey("spring.cloud.compatibility-verifier.enabled"), FALSE_VALUE).and().build();
    }

    private String instanceId(String lowerCaseBaseName) {
        return lowerCaseBaseName + ":${spring.application.instance-id:${random.value}}";
    }
}

