/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.neo4j.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class Neo4jModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/database/neo4j");
    private static final String NEO4J_SECONDARY = "technical/infrastructure/secondary/neo4j";
    private static final String DOCKER_COMPOSE_COMMAND = "docker compose -f src/main/docker/neo4j.yml up -d";
    private final DockerImages dockerImages;

    public Neo4jModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        String packageName = properties.basePackage().get() + ".";
        return JHipsterModule.moduleBuilder(properties).documentation(JHipsterModule.documentationTitle("Neo4j DB"), SOURCE.template("neo4j.md")).startupCommand(DOCKER_COMPOSE_COMMAND).context().put("neo4jDockerImage", this.dockerImages.get("neo4j").fullName()).and().javaDependencies().addDependency(JHipsterModule.groupId("org.springframework.boot"), JHipsterModule.artifactId("spring-boot-starter-data-neo4j")).addDependency(this.testContainerDependency()).and().files().add(SOURCE.template("neo4j.yml"), JHipsterModule.toSrcMainDocker().append("neo4j.yml")).batch(SOURCE, JHipsterModule.toSrcMainJava().append(packagePath).append(NEO4J_SECONDARY)).and().add(SOURCE.template("TestNeo4jManager.java"), JHipsterModule.toSrcTestJava().append(packagePath).append("TestNeo4jManager.java")).and().springMainProperties().set(JHipsterModule.propertyKey("spring.neo4j.uri"), JHipsterModule.propertyValue("bolt://localhost:7687")).set(JHipsterModule.propertyKey("spring.neo4j.pool.metrics-enabled"), JHipsterModule.propertyValue(true)).and().springTestProperties().set(JHipsterModule.propertyKey("spring.neo4j.uri"), JHipsterModule.propertyValue("${TEST_NEO4J_URI}")).and().springTestFactories().append(JHipsterModule.propertyKey("org.springframework.context.ApplicationListener"), JHipsterModule.propertyValue(packageName + "TestNeo4jManager")).and().springMainLogger("org.neo4j.driver", LogLevel.WARN).springTestLogger("org.neo4j.driver", LogLevel.WARN).springTestLogger("com.github.dockerjava", LogLevel.WARN).springTestLogger("org.testcontainers", LogLevel.WARN).build();
    }

    private JavaDependency testContainerDependency() {
        return JHipsterModule.javaDependency().groupId("org.testcontainers").artifactId("neo4j").versionSlug("testcontainers").scope(JavaDependencyScope.TEST).build();
    }
}

