/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.broker.kafka.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class KafkaModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/broker/kafka");
    private static final String TECHNICAL_INFRASTRUCTURE_CONFIG_KAFKA = "/wire/kafka/infrastructure/config";
    private static final String DUMMY_INFRASTRUCTURE_SECONDARY_KAFKA_PRODUCER = "dummy/infrastructure/secondary/kafka/producer";
    private static final String DUMMY_INFRASTRUCTURE_PRIMARY_KAFKA_CONSUMER = "dummy/infrastructure/primary/kafka/consumer";
    private static final String STRING_DESERIALIZER = "org.apache.kafka.common.serialization.StringDeserializer";
    private static final String STRING_SERIALIZER = "org.apache.kafka.common.serialization.StringSerializer";
    private static final String KAFKA_DOCKER_COMPOSE_COMMAND = "docker compose -f src/main/docker/kafka.yml up -d";
    private static final String AKHQ_DOCKER_COMPOSE_COMMAND = "docker compose -f src/main/docker/akhq.yml up -d";
    private final DockerImages dockerImages;

    public KafkaModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModuleInit(JHipsterModuleProperties properties) {
        String packagePath = properties.packagePath();
        return JHipsterModule.moduleBuilder(properties).context().put("zookeeperDockerImage", this.dockerImages.get("confluentinc/cp-zookeeper").fullName()).put("kafkaDockerImage", this.dockerImages.get("confluentinc/cp-kafka").fullName()).and().documentation(JHipsterModule.documentationTitle("Apache Kafka"), SOURCE.template("apache-kafka.md")).startupCommand(KAFKA_DOCKER_COMPOSE_COMMAND).javaDependencies().addDependency(JHipsterModule.groupId("org.apache.kafka"), JHipsterModule.artifactId("kafka-clients"), JHipsterModule.versionSlug("kafka-clients.version")).addDependency(JHipsterModule.groupId("org.testcontainers"), JHipsterModule.artifactId("kafka"), JHipsterModule.versionSlug("testcontainers.version")).and().files().add(SOURCE.template("kafka.yml"), JHipsterModule.toSrcMainDocker().append("kafka.yml")).add(SOURCE.template("KafkaTestContainerExtension.java"), JHipsterModule.toSrcTestJava().append(packagePath + "/KafkaTestContainerExtension.java")).add(SOURCE.template("KafkaPropertiesTest.java"), JHipsterModule.toSrcTestJava().append(packagePath + "//wire/kafka/infrastructure/config/KafkaPropertiesTest.java")).add(SOURCE.template("KafkaProperties.java"), JHipsterModule.toSrcMainJava().append(packagePath + "//wire/kafka/infrastructure/config/KafkaProperties.java")).add(SOURCE.template("KafkaConfiguration.java"), JHipsterModule.toSrcMainJava().append(packagePath + "//wire/kafka/infrastructure/config/KafkaConfiguration.java")).and().integrationTestExtension("KafkaTestContainerExtension").springMainProperties().set(JHipsterModule.propertyKey("kafka.bootstrap-servers"), JHipsterModule.propertyValue("localhost:9092")).set(JHipsterModule.propertyKey("kafka.consumer.'[key.deserializer]'"), JHipsterModule.propertyValue(STRING_DESERIALIZER)).set(JHipsterModule.propertyKey("kafka.consumer.'[value.deserializer]'"), JHipsterModule.propertyValue(STRING_DESERIALIZER)).set(JHipsterModule.propertyKey("kafka.consumer.'[group.id]'"), JHipsterModule.propertyValue("myapp")).set(JHipsterModule.propertyKey("kafka.consumer.'[auto.offset.reset]'"), JHipsterModule.propertyValue("earliest")).set(JHipsterModule.propertyKey("kafka.producer.'[key.serializer]'"), JHipsterModule.propertyValue(STRING_SERIALIZER)).set(JHipsterModule.propertyKey("kafka.producer.'[value.serializer]'"), JHipsterModule.propertyValue(STRING_SERIALIZER)).set(JHipsterModule.propertyKey("kafka.polling.timeout"), JHipsterModule.propertyValue(10000)).and().springTestProperties().set(JHipsterModule.propertyKey("kafka.bootstrap-servers"), JHipsterModule.propertyValue("localhost:9092")).and().build();
    }

    public JHipsterModule buildModuleDummyProducerConsumer(JHipsterModuleProperties properties) {
        String packagePath = properties.packagePath();
        return JHipsterModule.moduleBuilder(properties).springMainProperties().set(JHipsterModule.propertyKey("kafka.topic.dummy"), JHipsterModule.propertyValue("queue." + properties.projectBaseName().name() + ".dummy")).and().files().add(SOURCE.template("DummyProducer.java"), JHipsterModule.toSrcMainJava().append(packagePath + "/dummy/infrastructure/secondary/kafka/producer/DummyProducer.java")).add(SOURCE.template("DummyProducerTest.java"), JHipsterModule.toSrcTestJava().append(packagePath + "/dummy/infrastructure/secondary/kafka/producer/DummyProducerTest.java")).add(SOURCE.template("DummyProducerIT.java"), JHipsterModule.toSrcTestJava().append(packagePath + "/dummy/infrastructure/secondary/kafka/producer/DummyProducerIT.java")).add(SOURCE.template("AbstractConsumer.java"), JHipsterModule.toSrcMainJava().append(packagePath + "/dummy/infrastructure/primary/kafka/consumer/AbstractConsumer.java")).add(SOURCE.template("DummyConsumer.java"), JHipsterModule.toSrcMainJava().append(packagePath + "/dummy/infrastructure/primary/kafka/consumer/DummyConsumer.java")).add(SOURCE.template("DummyConsumerTest.java"), JHipsterModule.toSrcTestJava().append(packagePath + "/dummy/infrastructure/primary/kafka/consumer/DummyConsumerTest.java")).add(SOURCE.template("DummyConsumerIT.java"), JHipsterModule.toSrcTestJava().append(packagePath + "/dummy/infrastructure/primary/kafka/consumer/DummyConsumerIT.java")).and().build();
    }

    public JHipsterModule buildModuleAkhq(JHipsterModuleProperties properties) {
        return JHipsterModule.moduleBuilder(properties).context().put("akhqDockerImage", this.dockerImages.get("tchiotludo/akhq").fullName()).and().files().add(SOURCE.template("akhq.yml"), JHipsterModule.toSrcMainDocker().append("akhq.yml")).and().startupCommand(AKHQ_DOCKER_COMPOSE_COMMAND).build();
    }
}

