/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.init.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.npm.NpmVersions;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class InitModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("init");
    private static final JHipsterDestination DESTINATION = JHipsterModule.to(".");
    private final NpmVersions npmVersions;

    public InitModuleFactory(NpmVersions npmVersions) {
        Assert.notNull("npmVersions", npmVersions);
        this.npmVersions = npmVersions;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        return JHipsterModule.moduleBuilder(properties).context().put("dasherizedBaseName", properties.projectBaseName().kebabCase()).put("nodeVersion", this.npmVersions.getNodeVersion()).put("endOfLine", this.endOfLine(properties)).and().files().batch(SOURCE, DESTINATION).addTemplate("README.md").addTemplate("package.json").addTemplate(".editorconfig").and().add(SOURCE.file("gitignore"), JHipsterModule.to(".gitignore")).add(SOURCE.file("gitattributes"), JHipsterModule.to(".gitattributes")).and().build();
    }

    private String endOfLine(JHipsterModuleProperties properties) {
        return properties.getOrDefaultString("endOfLine", "lf");
    }
}

