/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

final class ApplicationStartupTraces {
    private static final String SEPARATOR = "-".repeat(58);
    private static final String BREAK = "\n";
    private static final Logger log = LoggerFactory.getLogger(ApplicationStartupTraces.class);

    private ApplicationStartupTraces() {
    }

    static String of(Environment environment) {
        Assert.notNull("environment", environment);
        return new ApplicationStartupTracesBuilder().append(BREAK).appendSeparator().append(ApplicationStartupTraces.applicationRunningTrace(environment)).append(ApplicationStartupTraces.localUrl(environment)).append(ApplicationStartupTraces.externalUrl(environment)).append(ApplicationStartupTraces.profilesTrace(environment)).appendSeparator().append(ApplicationStartupTraces.configServer(environment)).build();
    }

    private static String applicationRunningTrace(Environment environment) {
        String applicationName = environment.getProperty("spring.application.name");
        if (StringUtils.isBlank((CharSequence)applicationName)) {
            return "Application is running!";
        }
        return "Application '" + applicationName + "' is running!";
    }

    private static String localUrl(Environment environment) {
        return ApplicationStartupTraces.url("Local", "localhost", environment);
    }

    private static String externalUrl(Environment environment) {
        return ApplicationStartupTraces.url("External", ApplicationStartupTraces.hostAddress(), environment);
    }

    private static String url(String type, String host, Environment environment) {
        if (ApplicationStartupTraces.notWebEnvironment(environment)) {
            return null;
        }
        return type + ": \t" + ApplicationStartupTraces.protocol(environment) + "://" + host + ":" + ApplicationStartupTraces.port(environment) + ApplicationStartupTraces.contextPath(environment);
    }

    private static boolean notWebEnvironment(Environment environment) {
        return StringUtils.isBlank((CharSequence)environment.getProperty("server.port"));
    }

    private static String protocol(Environment environment) {
        if (ApplicationStartupTraces.noKeyStore(environment)) {
            return "http";
        }
        return "https";
    }

    private static boolean noKeyStore(Environment environment) {
        return StringUtils.isBlank((CharSequence)environment.getProperty("server.ssl.key-store"));
    }

    private static String port(Environment environment) {
        return environment.getProperty("server.port");
    }

    private static String profilesTrace(Environment environment) {
        Object[] profiles = environment.getActiveProfiles();
        if (ArrayUtils.isEmpty((Object[])profiles)) {
            return null;
        }
        return "Profile(s): \t" + Stream.of(profiles).collect(Collectors.joining(", "));
    }

    @ExcludeFromGeneratedCodeCoverage(reason="Hard to test implement detail error management")
    private static String hostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("The host name could not be determined, using `localhost` as fallback");
            return "localhost";
        }
    }

    private static String contextPath(Environment environment) {
        String contextPath = environment.getProperty("server.servlet.context-path");
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            return "/";
        }
        return contextPath;
    }

    private static String configServer(Environment environment) {
        String configServer = environment.getProperty("configserver.status");
        if (StringUtils.isBlank((CharSequence)configServer)) {
            return null;
        }
        return "Config Server: " + configServer + BREAK + SEPARATOR + BREAK;
    }

    private static class ApplicationStartupTracesBuilder {
        private static final String SPACER = "  ";
        private final StringBuilder trace = new StringBuilder();

        private ApplicationStartupTracesBuilder() {
        }

        public ApplicationStartupTracesBuilder appendSeparator() {
            this.trace.append(SEPARATOR).append(ApplicationStartupTraces.BREAK);
            return this;
        }

        public ApplicationStartupTracesBuilder append(String line) {
            if (line == null) {
                return this;
            }
            this.trace.append(SPACER).append(line).append(ApplicationStartupTraces.BREAK);
            return this;
        }

        public String build() {
            return this.trace.toString();
        }
    }
}

