/*
 * Decompiled with CFR 0.152.
 */
package tech.inner.hawk.bewit;

import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.inner.hawk.bewit.Base64Kt;
import tech.inner.hawk.bewit.BewitValidationResult;
import tech.inner.hawk.bewit.HawkCredentials;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000eJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ltech/inner/hawk/bewit/HawkBewit;", "", "clock", "Ljava/time/Clock;", "(Ljava/time/Clock;)V", "calculateMac", "", "credentials", "Ltech/inner/hawk/bewit/HawkCredentials;", "timestamp", "Ljava/time/Instant;", "uri", "Ljava/net/URI;", "text", "", "decodeBewit", "Ltech/inner/hawk/bewit/HawkBewit$BewitData;", "bewit", "generate", "ttl", "Ljava/time/Duration;", "hawkUnsignedUri", "url", "uriPort", "", "validate", "Ltech/inner/hawk/bewit/BewitValidationResult;", "BewitData", "Companion", "hawkish-bewit"})
public final class HawkBewit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Clock clock;
    @NotNull
    public static final String HAWK_VERSION = "1a";
    @NotNull
    public static final String AUTH_TYPE_BEWIT = "BEWIT";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final int BEWIT_FIELDS = 4;
    private static final int BEWIT_FIELD_ID = 0;
    private static final int BEWIT_FIELD_EXPIRY = 1;
    private static final int BEWIT_FIELD_MAC = 2;

    public HawkBewit(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
    }

    public /* synthetic */ HawkBewit(Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        this(clock);
    }

    @NotNull
    public final String generate(@NotNull HawkCredentials credentials, @NotNull URI uri, @NotNull Duration ttl) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        if (!(!ttl.isNegative())) {
            boolean $i$a$-require-HawkBewit$generate$22 = false;
            String $i$a$-require-HawkBewit$generate$22 = "TTL must be a positive duration";
            throw new IllegalArgumentException($i$a$-require-HawkBewit$generate$22.toString());
        }
        Instant expiry = this.clock.instant().plus(ttl);
        Intrinsics.checkNotNullExpressionValue((Object)expiry, (String)"expiry");
        String macBase64 = Base64Kt.toBase64Url(this.calculateMac(credentials, expiry, uri));
        StringBuilder $this$generate_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generate_u24lambda_u2d1.append(credentials.getKeyId());
        $this$generate_u24lambda_u2d1.append('\\');
        $this$generate_u24lambda_u2d1.append(expiry.getEpochSecond());
        $this$generate_u24lambda_u2d1.append('\\');
        $this$generate_u24lambda_u2d1.append(macBase64);
        $this$generate_u24lambda_u2d1.append('\\');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String bewit = string;
        return Base64Kt.toBase64Url(StringsKt.encodeToByteArray((String)bewit));
    }

    @NotNull
    public final BewitValidationResult validate(@NotNull HawkCredentials credentials, @NotNull URI uri, @NotNull String bewit) {
        BewitData bewitData;
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)bewit, (String)"bewit");
        try {
            bewitData = this.decodeBewit(bewit);
        }
        catch (IllegalStateException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Illegal bewit format";
            }
            return new BewitValidationResult.Bad(string);
        }
        BewitData bewitData2 = bewitData;
        if (!Intrinsics.areEqual((Object)credentials.getKeyId(), (Object)bewitData2.getKeyId())) {
            return new BewitValidationResult.Bad("Key id mismatch");
        }
        if (this.clock.instant().compareTo(bewitData2.getExpiry()) > 0) {
            return new BewitValidationResult.Bad("The bewit has expired");
        }
        byte[] calculatedMac = this.calculateMac(credentials, bewitData2.getExpiry(), uri);
        if (!MessageDigest.isEqual(calculatedMac, bewitData2.getMac())) {
            return new BewitValidationResult.AuthenticationError("MAC mismatch");
        }
        return new BewitValidationResult.Good(bewitData2.getExpiry());
    }

    @NotNull
    public final URI hawkUnsignedUri(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URL it = new URL(url);
        boolean bl = false;
        return new URI(it.getProtocol(), it.getHost(), URLDecoder.decode(it.getPath(), Charsets.UTF_8), it.getQuery(), it.getRef());
    }

    private final byte[] calculateMac(HawkCredentials credentials, Instant timestamp, URI uri) {
        StringBuilder stringBuilder;
        int n = 1024;
        StringBuilder $this$calculateMac_u24lambda_u2d3 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$calculateMac_u24lambda_u2d3.append("hawk.");
        $this$calculateMac_u24lambda_u2d3.append(HAWK_VERSION);
        $this$calculateMac_u24lambda_u2d3.append('.');
        $this$calculateMac_u24lambda_u2d3.append(AUTH_TYPE_BEWIT);
        $this$calculateMac_u24lambda_u2d3.append('\n');
        $this$calculateMac_u24lambda_u2d3.append(timestamp.getEpochSecond());
        $this$calculateMac_u24lambda_u2d3.append('\n');
        $this$calculateMac_u24lambda_u2d3.append('\n');
        $this$calculateMac_u24lambda_u2d3.append("GET");
        $this$calculateMac_u24lambda_u2d3.append('\n');
        $this$calculateMac_u24lambda_u2d3.append(uri.getRawPath());
        if (uri.getQuery() != null) {
            $this$calculateMac_u24lambda_u2d3.append('?');
            $this$calculateMac_u24lambda_u2d3.append(uri.getRawQuery());
        }
        $this$calculateMac_u24lambda_u2d3.append('\n');
        String string = uri.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.scheme");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        $this$calculateMac_u24lambda_u2d3.append(string2);
        $this$calculateMac_u24lambda_u2d3.append('\n');
        string = uri.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.host");
        string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        $this$calculateMac_u24lambda_u2d3.append(string2);
        $this$calculateMac_u24lambda_u2d3.append('\n');
        $this$calculateMac_u24lambda_u2d3.append(this.uriPort(uri));
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        String hawkString = string3;
        return this.calculateMac(credentials, hawkString);
    }

    private final byte[] calculateMac(HawkCredentials credentials, String text) {
        Mac mac = Mac.getInstance(credentials.getAlgorith().getJceAlgorithName());
        mac.init(new SecretKeySpec(StringsKt.encodeToByteArray((String)credentials.getKey()), credentials.getAlgorith().getJceAlgorithName()));
        byte[] byArray = mac.doFinal(StringsKt.encodeToByteArray((String)text));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mac.doFinal(text.encodeToByteArray())");
        return byArray;
    }

    private final BewitData decodeBewit(String bewit) {
        String decodedBewit = StringsKt.decodeToString((byte[])Base64Kt.base64UrlToBytes(bewit));
        Object object = new char[]{'\\'};
        List bewitFields = StringsKt.split$default((CharSequence)decodedBewit, (char[])object, (boolean)false, (int)0, (int)6, null);
        if (bewitFields.size() != 4) {
            throw new IllegalStateException("Invalid bewit".toString());
        }
        String string = (String)bewitFields.get(0);
        object = Instant.ofEpochSecond(Long.parseLong((String)bewitFields.get(1)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofEpochSecond(bewitField\u2026T_FIELD_EXPIRY].toLong())");
        return new BewitData(string, (Instant)object, Base64Kt.base64UrlToBytes((String)bewitFields.get(2)));
    }

    private final int uriPort(URI uri) {
        return uri.getPort() == -1 ? HawkBewit.uriPort$defaultPort(uri) : uri.getPort();
    }

    private static final int uriPort$defaultPort(URI $uri) {
        int n;
        String string = $uri.getScheme();
        if (Intrinsics.areEqual((Object)string, (Object)"http")) {
            n = 80;
        } else if (Intrinsics.areEqual((Object)string, (Object)"https")) {
            n = 443;
        } else {
            throw new IllegalStateException(("Unknown URI scheme \"" + $uri.getScheme() + '\"').toString());
        }
        return n;
    }

    public HawkBewit() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ltech/inner/hawk/bewit/HawkBewit$Companion;", "", "()V", "AUTH_TYPE_BEWIT", "", "BEWIT_FIELDS", "", "BEWIT_FIELD_EXPIRY", "BEWIT_FIELD_ID", "BEWIT_FIELD_MAC", "DEFAULT_HTTPS_PORT", "DEFAULT_HTTP_PORT", "HAWK_VERSION", "hawkish-bewit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Ltech/inner/hawk/bewit/HawkBewit$BewitData;", "", "keyId", "", "expiry", "Ljava/time/Instant;", "mac", "", "(Ljava/lang/String;Ljava/time/Instant;[B)V", "getExpiry", "()Ljava/time/Instant;", "getKeyId", "()Ljava/lang/String;", "getMac", "()[B", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "hawkish-bewit"})
    private static final class BewitData {
        @NotNull
        private final String keyId;
        @NotNull
        private final Instant expiry;
        @NotNull
        private final byte[] mac;

        public BewitData(@NotNull String keyId, @NotNull Instant expiry, @NotNull byte[] mac) {
            Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
            Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
            Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
            this.keyId = keyId;
            this.expiry = expiry;
            this.mac = mac;
        }

        @NotNull
        public final String getKeyId() {
            return this.keyId;
        }

        @NotNull
        public final Instant getExpiry() {
            return this.expiry;
        }

        @NotNull
        public final byte[] getMac() {
            return this.mac;
        }

        @NotNull
        public final String component1() {
            return this.keyId;
        }

        @NotNull
        public final Instant component2() {
            return this.expiry;
        }

        @NotNull
        public final byte[] component3() {
            return this.mac;
        }

        @NotNull
        public final BewitData copy(@NotNull String keyId, @NotNull Instant expiry, @NotNull byte[] mac) {
            Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
            Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
            Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
            return new BewitData(keyId, expiry, mac);
        }

        public static /* synthetic */ BewitData copy$default(BewitData bewitData, String string, Instant instant, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                string = bewitData.keyId;
            }
            if ((n & 2) != 0) {
                instant = bewitData.expiry;
            }
            if ((n & 4) != 0) {
                byArray = bewitData.mac;
            }
            return bewitData.copy(string, instant, byArray);
        }

        @NotNull
        public String toString() {
            return "BewitData(keyId=" + this.keyId + ", expiry=" + this.expiry + ", mac=" + Arrays.toString(this.mac) + ')';
        }

        public int hashCode() {
            int result = this.keyId.hashCode();
            result = result * 31 + this.expiry.hashCode();
            result = result * 31 + Arrays.hashCode(this.mac);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BewitData)) {
                return false;
            }
            BewitData bewitData = (BewitData)other;
            if (!Intrinsics.areEqual((Object)this.keyId, (Object)bewitData.keyId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expiry, (Object)bewitData.expiry)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mac, (Object)bewitData.mac);
        }
    }
}

