/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.cli;

import jakarta.inject.Named;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J,\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0010J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0010R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltech/harmonysoft/oss/common/cli/CommandLineHelper;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "shell", "", "", "execute", "Ltech/harmonysoft/oss/common/cli/CommandLineHelper$ProcessInfo;", "commandLine", "description", "keepProcessRunning", "", "environmentVariables", "", "commandDescription", "start", "Ljava/lang/Process;", "processDescription", "ProcessInfo", "harmonysoft-common"})
@SourceDebugExtension(value={"SMAP\nCommandLineHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandLineHelper.kt\ntech/harmonysoft/oss/common/cli/CommandLineHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class CommandLineHelper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final List<String> shell;

    public CommandLineHelper() {
        List list;
        CommandLineHelper commandLineHelper = this;
        CommandLineHelper commandLineHelper2 = this;
        boolean bl = false;
        String os = System.getProperty("os.name");
        Intrinsics.checkNotNull((Object)os);
        String string = os.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"windows", (boolean)false, (int)2, null)) {
            Object[] objectArray = new String[]{"cmd", "/C"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            Object[] objectArray = new String[]{"bash", "-c"};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        commandLineHelper2.shell = list;
    }

    @NotNull
    public final String execute(@NotNull String commandLine, @NotNull String commandDescription, @NotNull Map<String, String> environmentVariables) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)commandDescription, (String)"commandDescription");
        Intrinsics.checkNotNullParameter(environmentVariables, (String)"environmentVariables");
        String string = this.execute(commandLine, commandDescription, false, environmentVariables).getOutput();
        if (string == null) {
            throw new IllegalStateException("can not get output from executing '" + commandDescription + "': " + commandLine);
        }
        return string;
    }

    public static /* synthetic */ String execute$default(CommandLineHelper commandLineHelper, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return commandLineHelper.execute(string, string2, map);
    }

    @NotNull
    public final Process start(@NotNull String commandLine, @NotNull String processDescription, @NotNull Map<String, String> environmentVariables) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)processDescription, (String)"processDescription");
        Intrinsics.checkNotNullParameter(environmentVariables, (String)"environmentVariables");
        return this.execute(commandLine, processDescription, true, environmentVariables).getProcess();
    }

    public static /* synthetic */ Process start$default(CommandLineHelper commandLineHelper, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return commandLineHelper.start(string, string2, map);
    }

    private final ProcessInfo execute(String commandLine, String description, boolean keepProcessRunning, Map<String, String> environmentVariables) {
        Object object;
        List cmdLine = CollectionsKt.plus((Collection)this.shell, (Object)commandLine);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(cmdLine);
        Map<String, String> map = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
        map.putAll(environmentVariables);
        try {
            ProcessInfo processInfo;
            object = new Object[]{description, CollectionsKt.joinToString$default((Iterable)cmdLine, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), environmentVariables};
            this.logger.info("start '{}' using command line '{}' and environment {}", object);
            Process process = processBuilder.start();
            if (keepProcessRunning) {
                ThreadsKt.thread$default((boolean)false, (boolean)true, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(process, this, description){
                    final /* synthetic */ Process $process;
                    final /* synthetic */ CommandLineHelper this$0;
                    final /* synthetic */ String $description;
                    {
                        this.$process = $process;
                        this.this$0 = $receiver;
                        this.$description = $description;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$forEach$iv;
                        BufferedReader bufferedReader = this.$process.inputReader();
                        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"inputReader(...)");
                        Sequence sequence = TextStreamsKt.lineSequence((BufferedReader)bufferedReader);
                        CommandLineHelper commandLineHelper = this.this$0;
                        String string = this.$description;
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            CommandLineHelper.access$getLogger$p(commandLineHelper).info("sub-process {} [STDOUT] - {}", (Object)string, (Object)it);
                        }
                    }
                }), (int)29, null);
                ThreadsKt.thread$default((boolean)false, (boolean)true, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(process, this, description){
                    final /* synthetic */ Process $process;
                    final /* synthetic */ CommandLineHelper this$0;
                    final /* synthetic */ String $description;
                    {
                        this.$process = $process;
                        this.this$0 = $receiver;
                        this.$description = $description;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$forEach$iv;
                        BufferedReader bufferedReader = this.$process.errorReader();
                        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"errorReader(...)");
                        Sequence sequence = TextStreamsKt.lineSequence((BufferedReader)bufferedReader);
                        CommandLineHelper commandLineHelper = this.this$0;
                        String string = this.$description;
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            CommandLineHelper.access$getLogger$p(commandLineHelper).info("sub-process {} [STDERR] - {}", (Object)string, (Object)it);
                        }
                    }
                }), (int)29, null);
                Intrinsics.checkNotNull((Object)process);
                processInfo = new ProcessInfo(process, null);
            } else {
                String it;
                String string;
                BufferedReader bufferedReader = process.inputReader();
                Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"inputReader(...)");
                String stdout = TextStreamsKt.readText((Reader)bufferedReader);
                BufferedReader bufferedReader2 = process.errorReader();
                Intrinsics.checkNotNullExpressionValue((Object)bufferedReader2, (String)"errorReader(...)");
                String stderr = TextStreamsKt.readText((Reader)bufferedReader2);
                Object[] objectArray = new Object[4];
                objectArray[0] = description;
                objectArray[1] = commandLine;
                String string2 = string = stdout;
                int n = 2;
                Object[] objectArray2 = objectArray;
                String string3 = "executed '{}' using command line '{}'\nstdout:\n{}\nstderr:\n{}";
                Logger logger = this.logger;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                String string4 = bl2 ? string : null;
                if (string4 == null) {
                    string4 = "<empty>";
                }
                objectArray2[n] = string4;
                it = string = stderr;
                n = 3;
                objectArray2 = objectArray;
                boolean bl3 = false;
                bl2 = !StringsKt.isBlank((CharSequence)it);
                String string5 = bl2 ? string : null;
                if (string5 == null) {
                    string5 = "<empty>";
                }
                objectArray2[n] = string5;
                logger.info(string3, objectArray);
                it = string = stdout;
                boolean bl4 = false;
                String string6 = !StringsKt.isBlank((CharSequence)it) ? string : null;
                if (string6 == null) {
                    string6 = stderr;
                }
                String output = string6;
                Intrinsics.checkNotNull((Object)process);
                processInfo = new ProcessInfo(process, output);
            }
            object = processInfo;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{description, CollectionsKt.joinToString$default((Iterable)cmdLine, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), e};
            this.logger.error("unexpected exception on attempt to {} using command line '{}'", objectArray);
            throw new IllegalStateException("can't " + description, e);
        }
        return object;
    }

    public static final /* synthetic */ Logger access$getLogger$p(CommandLineHelper $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ltech/harmonysoft/oss/common/cli/CommandLineHelper$ProcessInfo;", "", "process", "Ljava/lang/Process;", "output", "", "(Ljava/lang/Process;Ljava/lang/String;)V", "getOutput", "()Ljava/lang/String;", "getProcess", "()Ljava/lang/Process;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "harmonysoft-common"})
    private static final class ProcessInfo {
        @NotNull
        private final Process process;
        @Nullable
        private final String output;

        public ProcessInfo(@NotNull Process process, @Nullable String output) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            this.process = process;
            this.output = output;
        }

        @NotNull
        public final Process getProcess() {
            return this.process;
        }

        @Nullable
        public final String getOutput() {
            return this.output;
        }

        @NotNull
        public final Process component1() {
            return this.process;
        }

        @Nullable
        public final String component2() {
            return this.output;
        }

        @NotNull
        public final ProcessInfo copy(@NotNull Process process, @Nullable String output) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            return new ProcessInfo(process, output);
        }

        public static /* synthetic */ ProcessInfo copy$default(ProcessInfo processInfo, Process process, String string, int n, Object object) {
            if ((n & 1) != 0) {
                process = processInfo.process;
            }
            if ((n & 2) != 0) {
                string = processInfo.output;
            }
            return processInfo.copy(process, string);
        }

        @NotNull
        public String toString() {
            return "ProcessInfo(process=" + this.process + ", output=" + this.output + ")";
        }

        public int hashCode() {
            int result = this.process.hashCode();
            result = result * 31 + (this.output == null ? 0 : this.output.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessInfo)) {
                return false;
            }
            ProcessInfo processInfo = (ProcessInfo)other;
            if (!Intrinsics.areEqual((Object)this.process, (Object)processInfo.process)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.output, (Object)processInfo.output);
        }
    }
}

