/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.time.schedule.impl;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.harmonysoft.oss.common.collection.CollectionInitializer;
import tech.harmonysoft.oss.common.time.clock.ClockProvider;
import tech.harmonysoft.oss.common.time.schedule.Schedule;
import tech.harmonysoft.oss.common.time.schedule.impl.DaysOfWeekTimeWindows;
import tech.harmonysoft.oss.common.time.schedule.impl.LocalDateTimeProcessingStrategy;
import tech.harmonysoft.oss.common.time.schedule.impl.TimeMillisProcessingStrategy;
import tech.harmonysoft.oss.common.time.schedule.impl.TimeProcessingStrategy;
import tech.harmonysoft.oss.common.time.schedule.impl.TimeWindow;
import tech.harmonysoft.oss.common.time.util.TimeUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 02\u00020\u0001:\u00010B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J)\u0010\u001e\u001a\u00020\u001f\"\u0004\b\u0000\u0010 2\u0006\u0010!\u001a\u0002H 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0#H\u0002\u00a2\u0006\u0002\u0010$J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001fH\u0016J)\u0010(\u001a\u00020\u001f\"\u0004\b\u0000\u0010 2\u0006\u0010!\u001a\u0002H 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0#H\u0002\u00a2\u0006\u0002\u0010$J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001fH\u0016J#\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0002\u00a2\u0006\u0002\u0010+J\t\u0010,\u001a\u00020-H\u00d6\u0001J\b\u0010.\u001a\u00020/H\u0002R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ltech/harmonysoft/oss/common/time/schedule/impl/ScheduleImpl;", "Ltech/harmonysoft/oss/common/time/schedule/Schedule;", "clockProvider", "Ltech/harmonysoft/oss/common/time/clock/ClockProvider;", "dayTimeWindows", "", "Ltech/harmonysoft/oss/common/time/schedule/impl/DaysOfWeekTimeWindows;", "(Ltech/harmonysoft/oss/common/time/clock/ClockProvider;Ljava/util/Collection;)V", "byDayOfWeek", "", "Ljava/time/DayOfWeek;", "", "getClockProvider", "()Ltech/harmonysoft/oss/common/time/clock/ClockProvider;", "getDayTimeWindows", "()Ljava/util/Collection;", "timeMillisStrategy", "Ltech/harmonysoft/oss/common/time/schedule/impl/TimeMillisProcessingStrategy;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "overlaps", "d1", "d2", "timeMsUntilTargetTimeIntervalEnd", "", "T", "time", "strategy", "Ltech/harmonysoft/oss/common/time/schedule/impl/TimeProcessingStrategy;", "(Ljava/lang/Object;Ltech/harmonysoft/oss/common/time/schedule/impl/TimeProcessingStrategy;)J", "dateTime", "Ljava/time/LocalDateTime;", "timeMillis", "timeMsUntilTargetTimeIntervalStart", "dayTimeOffsetMillis", "daysTimeWindows", "(J[Ltech/harmonysoft/oss/common/time/schedule/impl/DaysOfWeekTimeWindows;)J", "toString", "", "validateOverlapping", "", "Companion", "harmonysoft-common"})
@SourceDebugExtension(value={"SMAP\nScheduleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScheduleImpl.kt\ntech/harmonysoft/oss/common/time/schedule/impl/ScheduleImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,176:1\n1789#2,2:177\n1791#2:186\n1238#2,2:189\n1241#2:193\n372#3,7:179\n453#3:187\n403#3:188\n37#4,2:191\n12474#5:194\n12474#5,2:195\n12475#5:197\n*S KotlinDebug\n*F\n+ 1 ScheduleImpl.kt\ntech/harmonysoft/oss/common/time/schedule/impl/ScheduleImpl\n*L\n18#1:177,2\n18#1:186\n27#1:189,2\n27#1:193\n23#1:179,7\n27#1:187\n27#1:188\n27#1:191,2\n53#1:194\n54#1:195,2\n53#1:197\n*E\n"})
public final class ScheduleImpl
implements Schedule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClockProvider clockProvider;
    @NotNull
    private final Collection<DaysOfWeekTimeWindows> dayTimeWindows;
    @NotNull
    private final TimeMillisProcessingStrategy timeMillisStrategy;
    @NotNull
    private final Map<DayOfWeek, DaysOfWeekTimeWindows[]> byDayOfWeek;
    private static final long SIX_DAYS_MILLIS = TimeUnit.DAYS.toMillis(6L);

    /*
     * WARNING - void declaration
     */
    public ScheduleImpl(@NotNull ClockProvider clockProvider, @NotNull Collection<DaysOfWeekTimeWindows> dayTimeWindows) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map.Entry entry;
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter((Object)clockProvider, (String)"clockProvider");
        Intrinsics.checkNotNullParameter(dayTimeWindows, (String)"dayTimeWindows");
        this.clockProvider = clockProvider;
        this.dayTimeWindows = dayTimeWindows;
        this.timeMillisStrategy = new TimeMillisProcessingStrategy(this.clockProvider);
        Iterable iterable = this.dayTimeWindows;
        Map map = new LinkedHashMap();
        ScheduleImpl scheduleImpl = this;
        boolean $i$f$fold22 = false;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void daysTimeWindow;
            DaysOfWeekTimeWindows daysOfWeekTimeWindows = (DaysOfWeekTimeWindows)element$iv;
            void byDayOfWeek = accumulator$iv;
            boolean bl = false;
            entry = byDayOfWeek;
            void $this$byDayOfWeek_u24lambda_u241_u24lambda_u240 = entry;
            boolean bl2 = false;
            for (DayOfWeek dayOfWeek : daysTimeWindow.getDaysOfWeek()) {
                Object object;
                void $this$getOrPut$iv;
                void var17_24 = byDayOfWeek;
                Function0 defaultValue$iv = CollectionInitializer.INSTANCE.mutableList();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(dayOfWeek);
                if (value$iv == null) {
                    Object answer$iv = defaultValue$iv.invoke();
                    $this$getOrPut$iv.put(dayOfWeek, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List days = (List)object;
                ((Collection)days).add(daysTimeWindow);
            }
            accumulator$iv = entry;
        }
        $this$fold$iv = accumulator$iv;
        boolean $i$f$mapValues = false;
        void $i$f$fold22 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            Collection $this$toTypedArray$iv = (Collection)it.getValue();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            DaysOfWeekTimeWindows[] daysOfWeekTimeWindowsArray = thisCollection$iv.toArray(new DaysOfWeekTimeWindows[0]);
            map3.put(k, daysOfWeekTimeWindowsArray);
        }
        scheduleImpl.byDayOfWeek = MapsKt.toMap((Map)destination$iv$iv);
        if (this.dayTimeWindows.isEmpty()) {
            throw new IllegalArgumentException("time windows should not be empty");
        }
        this.validateOverlapping();
    }

    @NotNull
    public final ClockProvider getClockProvider() {
        return this.clockProvider;
    }

    @NotNull
    public final Collection<DaysOfWeekTimeWindows> getDayTimeWindows() {
        return this.dayTimeWindows;
    }

    private final void validateOverlapping() {
        for (Map.Entry<DayOfWeek, DaysOfWeekTimeWindows[]> entry : this.byDayOfWeek.entrySet()) {
            DayOfWeek dayOfWeek = entry.getKey();
            DaysOfWeekTimeWindows[] daysTimeWindows = entry.getValue();
            int n = daysTimeWindows.length;
            for (int i = 0; i < n; ++i) {
                int n2 = daysTimeWindows.length;
                for (int j = i + 1; j < n2; ++j) {
                    DaysOfWeekTimeWindows d1 = daysTimeWindows[i];
                    DaysOfWeekTimeWindows d2 = daysTimeWindows[j];
                    if (!this.overlaps(d1, d2)) continue;
                    throw new IllegalArgumentException("detected overlapping schedule setup for " + dayOfWeek + " in '" + d1 + "' and '" + d2 + "'");
                }
            }
        }
    }

    private final boolean overlaps(DaysOfWeekTimeWindows d1, DaysOfWeekTimeWindows d2) {
        boolean bl;
        block3: {
            TimeWindow[] $this$any$iv = d1.getTimeWindows();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                block2: {
                    TimeWindow element$iv;
                    TimeWindow w1 = element$iv = $this$any$iv[i];
                    boolean bl3 = false;
                    TimeWindow[] $this$any$iv2 = d2.getTimeWindows();
                    boolean $i$f$any2 = false;
                    int n2 = $this$any$iv2.length;
                    for (int j = 0; j < n2; ++j) {
                        TimeWindow element$iv2;
                        TimeWindow w2 = element$iv2 = $this$any$iv2[j];
                        boolean bl4 = false;
                        if (!w1.overlaps(w2)) continue;
                        bl2 = true;
                        break block2;
                    }
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public long timeMsUntilTargetTimeIntervalStart(@NotNull LocalDateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        return this.timeMsUntilTargetTimeIntervalStart(dateTime, LocalDateTimeProcessingStrategy.INSTANCE);
    }

    @Override
    public long timeMsUntilTargetTimeIntervalStart(long timeMillis) {
        return this.timeMsUntilTargetTimeIntervalStart(Long.valueOf(timeMillis), this.timeMillisStrategy);
    }

    private final <T> long timeMsUntilTargetTimeIntervalStart(T time, TimeProcessingStrategy<T> strategy) {
        Object[] daysTimeWindows;
        DayOfWeek startDayOfWeek = strategy.toDayOfWeek(time);
        boolean todayProcessed = false;
        long timeShiftMillis = 0L;
        DayOfWeek dayOfWeek = startDayOfWeek;
        while (!todayProcessed || startDayOfWeek != dayOfWeek) {
            if (dayOfWeek == startDayOfWeek) {
                todayProcessed = true;
            }
            timeShiftMillis += startDayOfWeek == dayOfWeek ? 0L : (startDayOfWeek.plus(1L) == dayOfWeek ? strategy.timeMsBeforeEndOfTheDay(time) : TimeUtil.Millis.INSTANCE.getDAY());
            daysTimeWindows = this.byDayOfWeek.get(dayOfWeek);
            if (daysTimeWindows == null) {
                Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek.plus(1L), (String)"plus(...)");
                continue;
            }
            long dayTimeOffsetMillis = dayOfWeek == startDayOfWeek ? strategy.timeMsFromStartOfTheDay(time) : 0L;
            long result = this.timeMsUntilTargetTimeIntervalStart(dayTimeOffsetMillis, (DaysOfWeekTimeWindows[])daysTimeWindows);
            if (result == 0L) {
                return timeShiftMillis <= 0L ? -1L : timeShiftMillis;
            }
            if (result > 0L) {
                return result + timeShiftMillis;
            }
            Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek.plus(1L), (String)"plus(...)");
        }
        daysTimeWindows = this.byDayOfWeek.get(startDayOfWeek);
        if (daysTimeWindows != null) {
            long result = -1L;
            Iterator iterator = ArrayIteratorKt.iterator((Object[])daysTimeWindows);
            while (iterator.hasNext()) {
                DaysOfWeekTimeWindows dayTimeWindows = (DaysOfWeekTimeWindows)iterator.next();
                long timeMs = dayTimeWindows.timeMsUntilTargetTimeIntervalStart(0L);
                if (timeMs < 0L || result >= 0L && result <= timeMs) continue;
                result = timeMs;
            }
            if (result >= 0L) {
                return strategy.timeMsBeforeEndOfTheDay(time) + SIX_DAYS_MILLIS + result;
            }
        }
        throw new IllegalStateException("can't calculate time from '" + time + "' until target interval start in schedule " + this);
    }

    private final long timeMsUntilTargetTimeIntervalStart(long dayTimeOffsetMillis, DaysOfWeekTimeWindows[] daysTimeWindows) {
        long result = -1L;
        for (DaysOfWeekTimeWindows dayTimeWindow : daysTimeWindows) {
            long timeMs = dayTimeWindow.timeMsUntilTargetTimeIntervalStart(dayTimeOffsetMillis);
            if (timeMs < 0L) continue;
            if (timeMs == 0L) {
                return 0L;
            }
            if (result >= 0L && result <= timeMs) continue;
            result = timeMs;
        }
        return result;
    }

    @Override
    public long timeMsUntilTargetTimeIntervalEnd(@NotNull LocalDateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        return this.timeMsUntilTargetTimeIntervalEnd(dateTime, LocalDateTimeProcessingStrategy.INSTANCE);
    }

    @Override
    public long timeMsUntilTargetTimeIntervalEnd(long timeMillis) {
        return this.timeMsUntilTargetTimeIntervalEnd(timeMillis, this.timeMillisStrategy);
    }

    private final <T> long timeMsUntilTargetTimeIntervalEnd(T time, TimeProcessingStrategy<T> strategy) {
        DaysOfWeekTimeWindows[] daysOfWeekTimeWindowsArray = this.byDayOfWeek.get(strategy.toDayOfWeek(time));
        if (daysOfWeekTimeWindowsArray == null) {
            return -1L;
        }
        DaysOfWeekTimeWindows[] timeWindows = daysOfWeekTimeWindowsArray;
        long dayTimeOffsetMillis = strategy.timeMsFromStartOfTheDay(time);
        for (DaysOfWeekTimeWindows timeWindow : timeWindows) {
            long result = timeWindow.timeMsUntilTargetTimeIntervalEnd(dayTimeOffsetMillis);
            if (result < 0L) continue;
            return result;
        }
        return -1L;
    }

    @Override
    public boolean contains(@NotNull LocalDateTime dateTime) {
        return Schedule.DefaultImpls.contains((Schedule)this, dateTime);
    }

    @Override
    public boolean contains(long timeMillis) {
        return Schedule.DefaultImpls.contains((Schedule)this, timeMillis);
    }

    @NotNull
    public final ClockProvider component1() {
        return this.clockProvider;
    }

    @NotNull
    public final Collection<DaysOfWeekTimeWindows> component2() {
        return this.dayTimeWindows;
    }

    @NotNull
    public final ScheduleImpl copy(@NotNull ClockProvider clockProvider, @NotNull Collection<DaysOfWeekTimeWindows> dayTimeWindows) {
        Intrinsics.checkNotNullParameter((Object)clockProvider, (String)"clockProvider");
        Intrinsics.checkNotNullParameter(dayTimeWindows, (String)"dayTimeWindows");
        return new ScheduleImpl(clockProvider, dayTimeWindows);
    }

    public static /* synthetic */ ScheduleImpl copy$default(ScheduleImpl scheduleImpl, ClockProvider clockProvider, Collection collection, int n, Object object) {
        if ((n & 1) != 0) {
            clockProvider = scheduleImpl.clockProvider;
        }
        if ((n & 2) != 0) {
            collection = scheduleImpl.dayTimeWindows;
        }
        return scheduleImpl.copy(clockProvider, collection);
    }

    @NotNull
    public String toString() {
        return "ScheduleImpl(clockProvider=" + this.clockProvider + ", dayTimeWindows=" + this.dayTimeWindows + ")";
    }

    public int hashCode() {
        int result = this.clockProvider.hashCode();
        result = result * 31 + ((Object)this.dayTimeWindows).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScheduleImpl)) {
            return false;
        }
        ScheduleImpl scheduleImpl = (ScheduleImpl)other;
        if (!Intrinsics.areEqual((Object)this.clockProvider, (Object)scheduleImpl.clockProvider)) {
            return false;
        }
        return Intrinsics.areEqual(this.dayTimeWindows, scheduleImpl.dayTimeWindows);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltech/harmonysoft/oss/common/time/schedule/impl/ScheduleImpl$Companion;", "", "()V", "SIX_DAYS_MILLIS", "", "harmonysoft-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

