/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.file;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/harmonysoft/oss/common/file/FileUtil;", "", "()V", "ensureDirectoryExists", "", "dir", "Ljava/io/File;", "harmonysoft-common"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();

    private FileUtil() {
    }

    public final void ensureDirectoryExists(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (dir.isDirectory()) {
            return;
        }
        if (dir.exists()) {
            throw new IllegalStateException("Can't prepare a directory at path '" + dir.getAbsolutePath() + "' - a file at that path already exists");
        }
        if (!dir.mkdirs()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Can't create directory at path ", (Object)dir.getAbsolutePath()));
        }
    }
}

