/*
 * Decompiled with CFR 0.152.
 */
package tech.gujin.toast;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import tech.gujin.toast.ToastConfig;
import tech.gujin.toast.ToastShow;

public class ToastUtil {
    private static final String TAG = "ToastUtil";
    private static boolean initialized;

    public static synchronized void initialize(@NonNull Context context) {
        ToastUtil.initialize(context, Mode.NORMAL);
    }

    public static synchronized void initialize(@NonNull Context context, @NonNull Mode defaultMode) {
        if (initialized) {
            Log.w((String)TAG, (String)"Invalid initialize, ToastUtil is already initialized");
            return;
        }
        if (context == null) {
            throw new NullPointerException("context can not be null");
        }
        if (defaultMode == null) {
            defaultMode = Mode.NORMAL;
        }
        ToastConfig.setContext(context.getApplicationContext());
        ToastConfig.setDefaultMode(defaultMode);
        initialized = true;
    }

    public static void show(int resId) {
        ToastUtil.show(resId, false);
    }

    public static void show(int resId, boolean durationLong) {
        ToastUtil.show(resId, durationLong, null);
    }

    public static void show(int resId, @Nullable Mode mode) {
        ToastUtil.show(resId, false, mode);
    }

    public static void show(int resId, boolean durationLong, @Nullable Mode mode) {
        ToastUtil.show(ToastUtil.getText(resId), durationLong, mode);
    }

    public static void show(CharSequence text) {
        ToastUtil.show(text, false);
    }

    public static void show(CharSequence text, boolean durationLong) {
        ToastUtil.show(text, durationLong, null);
    }

    public static void show(CharSequence text, @Nullable Mode mode) {
        ToastUtil.show(text, false, mode);
    }

    public static void show(CharSequence text, boolean durationLong, @Nullable Mode mode) {
        ToastShow.show(text, durationLong, mode);
    }

    public static void postShow(@StringRes int resId) {
        ToastUtil.postShow(resId, false);
    }

    public static void postShow(int resId, boolean durationLong) {
        ToastUtil.postShow(ToastUtil.getText(resId), durationLong);
    }

    public static void postShow(int resId, @Nullable Mode mode) {
        ToastUtil.postShow(resId, false, mode);
    }

    public static void postShow(int resId, boolean durationLong, @Nullable Mode mode) {
        ToastUtil.postShow(ToastUtil.getText(resId), durationLong, mode);
    }

    public static void postShow(CharSequence text) {
        ToastUtil.postShow(text, false);
    }

    public static void postShow(CharSequence text, boolean durationLong) {
        ToastUtil.postShow(text, durationLong, null);
    }

    public static void postShow(CharSequence text, @Nullable Mode mode) {
        ToastUtil.postShow(text, false, mode);
    }

    public static void postShow(CharSequence text, boolean durationLong, @Nullable Mode mode) {
        ToastShow.postShow(text, durationLong, mode);
    }

    private static CharSequence getText(@StringRes int resId) {
        return ToastConfig.getContext().getText(resId);
    }

    private ToastUtil() {
    }

    public static enum Mode {
        NORMAL,
        REPLACEABLE;

    }
}

