/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.upgrade;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.util.HashMap;
import tech.guazi.component.upgrade.DownloadController;
import tech.guazi.component.upgrade.DownloadStateListener;
import tech.guazi.component.upgrade.HostEnvironment;
import tech.guazi.component.upgrade.HostManager;
import tech.guazi.component.upgrade.UpgradeController;
import tech.guazi.component.upgrade.UpgradeInfo;
import tech.guazi.component.upgrade.UpgradeListener;
import tech.guazi.component.upgrade.UpgradeProtocol;
import tech.guazi.component.upgrade.utils.PackageUtils;
import tech.guazi.component.upgrade.utils.SharePreferenceManager;

public final class UpgradeManager {
    public static final String TAG = "upgrade_debug";
    public static final int UPGRADE_NOTIFICATION_ID = 1001;
    public static final String UPGRADE_APK_PATH = "/GuaZi/upgrade/";
    public static final String UPGRADE_APK_FILE_SUFFIX = ".apk";
    private SharedPreferences mPreferences;
    private static UpgradeManager mInstance;
    private Context mContext;
    private DownloadController mDownloadController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpgradeManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<UpgradeManager> clazz = UpgradeManager.class;
        synchronized (UpgradeManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new UpgradeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void init(Context context, int appId) {
        this.mContext = context;
        UpgradeController.getInstance(context).setAppId(appId);
        String curVersionName = PackageUtils.getAppVersionName(context);
        this.mPreferences = SharePreferenceManager.getInstance(context, curVersionName).getSharedPreferences();
        this.mDownloadController = new DownloadController();
    }

    public void checkVersion(boolean isAuto, UpgradeListener listener) {
        if (UpgradeController.getInstance(this.mContext).getAppId() <= 0) {
            Log.e((String)TAG, (String)"[ERROR] {checkVersion} <appId is invalid.>");
            return;
        }
        boolean flag = this.checkLocalVersionInfo();
        if (flag) {
            if (listener != null) {
                listener.onUpgrade(this.mContext, true, this.getLocalVersionInfo());
            }
        } else {
            this.checkOnlineVersionInfo(isAuto, listener);
        }
    }

    public void storeVersionNotifyData(boolean notifyDisabled, UpgradeInfo upgradeInfo) {
        try {
            SharedPreferences.Editor preferencesEditor = this.mPreferences.edit();
            preferencesEditor.putLong("new_version_last_notify_time", System.currentTimeMillis());
            int notifyTimes = this.mPreferences.getInt("new_version_notify_times", 0);
            preferencesEditor.putInt("new_version_notify_times", ++notifyTimes);
            boolean isFirstNotify = this.mPreferences.getBoolean("new_version_is_first_notify", true);
            if (isFirstNotify) {
                preferencesEditor.putBoolean("new_version_is_first_notify", false);
                preferencesEditor.putLong("new_version_first_notify_time", System.currentTimeMillis());
            }
            preferencesEditor.putBoolean("new_version_notify_disabled", notifyDisabled);
            preferencesEditor.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void storeVersionNotifyDisableData(boolean notifyDisabled) {
        try {
            SharedPreferences.Editor preferencesEditor = this.mPreferences.edit();
            preferencesEditor.putBoolean("new_version_notify_disabled", notifyDisabled);
            preferencesEditor.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void resetVersionNotifyData() {
        try {
            SharedPreferences.Editor preferencesEditor = this.mPreferences.edit();
            preferencesEditor.putLong("new_version_last_notify_time", -1L);
            preferencesEditor.putBoolean("new_version_is_first_notify", false);
            preferencesEditor.putLong("new_version_first_notify_time", -1L);
            preferencesEditor.putInt("new_version_notify_times", 0);
            preferencesEditor.putBoolean("new_version_notify_disabled", false);
            preferencesEditor.putInt("new_version_check_type", -1);
            preferencesEditor.putString("new_version_info", "");
            preferencesEditor.putString("new_version_local_url", "");
            preferencesEditor.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isVersionNotifyDisabled() {
        return this.mPreferences.getBoolean("new_version_notify_disabled", false);
    }

    public void storeVersionLocalUrl(String url) {
        try {
            SharedPreferences.Editor preferencesEditor = this.mPreferences.edit();
            preferencesEditor.putString("new_version_local_url", url);
            preferencesEditor.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setEnvironment(HostEnvironment environment) {
        HostManager.getInstance(this.mContext).setEnvironment(environment);
    }

    public void download(String url, String outUri, DownloadStateListener listener) {
        this.mDownloadController.download(this.mContext, url, outUri, listener);
    }

    public void cancelDownload(DownloadStateListener listener) {
        this.mDownloadController.cancelDownload(listener);
    }

    public void installVersion(String apkPath) {
        if (PackageUtils.installSilent(this.mContext, apkPath) != 1) {
            PackageUtils.installNormal(this.mContext, apkPath);
        }
    }

    public boolean checkLocalVersionAndInstall() {
        UpgradeInfo info;
        File file;
        if (this.checkLocalVersionApk() && (file = new File((info = this.getLocalVersionInfo()).getLocalUrl())).isFile() && file.exists() && file.canRead()) {
            this.installVersion(info.getLocalUrl());
            return true;
        }
        return false;
    }

    private void checkOnlineVersionInfo(final boolean isAuto, final UpgradeListener listener) {
        UpgradeController.getInstance(this.mContext).requestVersionInfo(isAuto, new UpgradeListener(){

            @Override
            public void onUpgrade(Context contxt, final boolean newVersion, final UpgradeInfo upgradeInfo) {
                if (upgradeInfo != null) {
                    Log.d((String)UpgradeManager.TAG, (String)("[checkOnlineVersion()] <newVersion=" + newVersion + ", " + upgradeInfo + ">"));
                    if (newVersion) {
                        UpgradeManager.this.storeVersionInfo(isAuto, upgradeInfo);
                    }
                }
                if (listener != null) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onUpgrade(UpgradeManager.this.mContext, newVersion, upgradeInfo);
                        }
                    });
                }
            }
        });
    }

    private boolean checkLocalVersionInfo() {
        UpgradeInfo info = this.getLocalVersionInfo();
        Log.d((String)TAG, (String)("[checkLocalUpgradeVersionInfo()] <" + info + ">"));
        if (!info.isNewVersion()) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)info.getVersionUrl())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)info.getVersionName())) {
            return false;
        }
        String versionName = info.getVersionName();
        String curVersionName = PackageUtils.getAppVersionName(this.mContext);
        if (TextUtils.isEmpty((CharSequence)versionName) || TextUtils.isEmpty((CharSequence)curVersionName)) {
            return false;
        }
        String[] versionNameArr = versionName.split("\\.");
        String[] curVersionNameArr = curVersionName.split("\\.");
        if (versionNameArr.length < 2 || curVersionNameArr.length < 2) {
            return false;
        }
        int minLen = Math.min(versionNameArr.length, curVersionNameArr.length);
        try {
            for (int i = 0; i < minLen; ++i) {
                if (Integer.parseInt(versionNameArr[i]) >= Integer.parseInt(curVersionNameArr[i])) continue;
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)("[checkLocalUpgradeVersionInfo()] <versionName=" + versionName + ", curVersionName=" + curVersionName + ">"));
            return false;
        }
        return true;
    }

    private boolean checkLocalVersionApk() {
        UpgradeInfo info = this.getLocalVersionInfo();
        if (!info.isNewVersion()) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)info.getLocalUrl())) {
            return false;
        }
        int versionCode = PackageUtils.getAppVersionCode(this.mContext);
        int apkVersionCode = PackageUtils.getAppVersionCode(this.mContext, info.getLocalUrl());
        Log.d((String)TAG, (String)("[checkLocalUpgradeVersionApk()] <upgradeInfo=" + info.toString() + ", versionCode=" + versionCode + ", apkVersionCode=" + apkVersionCode + ">"));
        return apkVersionCode > versionCode;
    }

    private UpgradeInfo getLocalVersionInfo() {
        String localVersionInfo = this.mPreferences.getString("new_version_info", "");
        UpgradeInfo info = null;
        UpgradeProtocol protocol = new UpgradeProtocol();
        if (!TextUtils.isEmpty((CharSequence)localVersionInfo)) {
            protocol.parseFromJSONProtocol(localVersionInfo);
            info = protocol.getUpgradeInfo();
        } else {
            info = new UpgradeInfo(new HashMap<String, String>(), "");
        }
        info.setJSONStr(this.mPreferences.getString("new_version_info", ""));
        info.setLocalUrl(this.mPreferences.getString("new_version_local_url", ""));
        info.setCheckType(this.mPreferences.getInt("new_version_check_type", -1));
        info.setFirstNotify(this.mPreferences.getLong("new_version_first_notify_time", -1L));
        info.setLastNotify(this.mPreferences.getLong("new_version_last_notify_time", -1L));
        info.setNotifyTimes(this.mPreferences.getInt("new_version_notify_times", 0));
        info.setIsFirstNofify(this.mPreferences.getBoolean("new_version_is_first_notify", true));
        info.setIsNotifyDisabled(this.mPreferences.getBoolean("new_version_notify_disabled", false));
        return info;
    }

    private void storeVersionInfo(boolean isAuto, UpgradeInfo upgradeInfo) {
        try {
            SharedPreferences.Editor mShareEditor = this.mPreferences.edit();
            mShareEditor.putInt("new_version_check_type", isAuto ? 0 : 1);
            mShareEditor.putString("new_version_info", upgradeInfo.getJSONStr());
            mShareEditor.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private UpgradeManager() {
    }
}

