/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.upgrade;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import tech.guazi.component.upgrade.DownloadStateListener;
import tech.guazi.component.upgrade.DownloadTask;

final class DownloadController {
    private Thread mThread = null;

    DownloadController() {
    }

    public void download(Context context, String url, String outUri, DownloadStateListener listener) {
        Runnable runnable = DownloadTask.getDownloadTask(context, url, outUri, this.getUIDownloadStateListener(listener));
        this.mThread = new Thread(runnable, "download_version_thread");
        this.mThread.start();
    }

    public void cancelDownload(DownloadStateListener listener) {
        try {
            if (this.mThread.isAlive()) {
                this.mThread.interrupt();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (listener != null) {
            listener.onCancel();
        }
    }

    private DownloadStateListener getUIDownloadStateListener(final DownloadStateListener listener) {
        if (listener == null) {
            return null;
        }
        final Handler mHandler = new Handler(Looper.getMainLooper());
        DownloadStateListener runOnUIListener = new DownloadStateListener(){

            @Override
            public void onStart() {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onStart();
                    }
                });
            }

            @Override
            public void onProgress(final int percent) {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onProgress(percent);
                    }
                });
            }

            @Override
            public void onFinish(final String localUri) {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onFinish(localUri);
                    }
                });
            }

            @Override
            public void onCancel() {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onCancel();
                    }
                });
            }

            @Override
            public void onFailure(final int reson, final Object obj) {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onFailure(reson, obj);
                    }
                });
            }

            @Override
            public void setTotalSize(long totalSize) {
                listener.setTotalSize(totalSize);
            }

            @Override
            public long getTotalSize() {
                return listener.getTotalSize();
            }
        };
        return runOnUIListener;
    }
}

