/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.upgrade;

import android.text.TextUtils;
import com.mobile.base.http.BaseProtocol;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import tech.guazi.component.upgrade.UpgradeInfo;

final class UpgradeProtocol
extends BaseProtocol {
    protected static final String KEY_NEED_UPDATE = "is_needs_update";
    protected static final String KEY_UPDATE_VERSION = "update_version";
    protected static final String KEY_UPDATE_TEXT = "update_text";
    protected static final String KEY_FORCE_UPDATE = "force_update";
    protected static final String KEY_DOWNLOAD_URL = "download_url";
    protected static final String KEY_FILE_SIZE = "file_size";
    private Map<String, String> mUpdateValues = new HashMap<String, String>();
    private UpgradeInfo mUpgradeInfo;

    UpgradeProtocol() {
    }

    public boolean parseFromJSONProtocol(String s) {
        try {
            if (TextUtils.isEmpty((CharSequence)s)) {
                this.mUpgradeInfo = new UpgradeInfo(this.mUpdateValues, "");
            } else {
                JSONObject data = new JSONObject(s);
                this.mUpdateValues.put(KEY_NEED_UPDATE, data.getBoolean(KEY_NEED_UPDATE) + "");
                this.mUpdateValues.put(KEY_UPDATE_VERSION, data.getString(KEY_UPDATE_VERSION));
                this.mUpdateValues.put(KEY_UPDATE_TEXT, data.getString(KEY_UPDATE_TEXT));
                this.mUpdateValues.put(KEY_FORCE_UPDATE, data.getBoolean(KEY_FORCE_UPDATE) + "");
                this.mUpdateValues.put(KEY_DOWNLOAD_URL, data.getString(KEY_DOWNLOAD_URL));
                this.mUpdateValues.put(KEY_FILE_SIZE, data.getString(KEY_FILE_SIZE));
                this.mUpgradeInfo = new UpgradeInfo(this.mUpdateValues, s);
            }
            return true;
        }
        catch (JSONException je) {
            je.printStackTrace();
            System.out.println("[ERROR_JSON] <" + s + ">");
            this.mUpgradeInfo = new UpgradeInfo(this.mUpdateValues, "");
            return false;
        }
    }

    public UpgradeInfo getUpgradeInfo() {
        return this.mUpgradeInfo;
    }
}

