/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.upgrade;

import android.content.Context;
import android.text.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import tech.guazi.component.upgrade.DownloadRunnable;
import tech.guazi.component.upgrade.DownloadStateListener;
import tech.guazi.component.upgrade.utils.NetworkUtils;

final class DownloadTask {
    private static final int CONNECT_TIMEOUT = 30000;

    DownloadTask() {
    }

    public static DownloadRunnable getDownloadTask(Context context, String url, String outUri, DownloadStateListener listener) {
        return new HttpDownloadTask(context, url, outUri, listener);
    }

    private static class HttpDownloadTask
    extends BaseDownloadTask {
        public HttpDownloadTask(Context context, String url, String outUri, DownloadStateListener listener) {
            super(context, url, outUri, listener);
        }

        @Override
        public void run() {
            if (this.mListener != null) {
                this.mListener.onStart();
            }
            HttpURLConnection httpConnection = null;
            try {
                httpConnection = HttpDownloadTask.createHttpConnection(this.mContext, this.mUri);
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == 200) {
                    byte[] result = this.readByteFromStream(httpConnection.getInputStream());
                    if (result != null && result.length > 0) {
                        this.saveFile(result, this.mOutUri);
                    } else if (this.mListener != null) {
                        this.mListener.onFailure(responseCode, "readByteFromStream");
                    }
                } else if (this.mListener != null) {
                    this.mListener.onFailure(responseCode, null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.mListener != null) {
                    try {
                        int responseCode = httpConnection == null ? -1 : httpConnection.getResponseCode();
                        this.mListener.onFailure(responseCode, ex);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.mListener.onFailure(-1, ex);
                    }
                }
                return;
            }
            if (this.mListener != null) {
                this.mListener.onFinish(this.mOutUri);
            }
        }

        private static HttpURLConnection createHttpConnection(Context context, String urlStr) throws IOException {
            HttpURLConnection httpConnection = NetworkUtils.setupNetwork(context, urlStr);
            httpConnection.setConnectTimeout(30000);
            httpConnection.setRequestMethod("GET");
            return httpConnection;
        }
    }

    private static abstract class BaseDownloadTask
    extends DownloadRunnable {
        protected Context mContext;
        protected String mUri;
        protected String mOutUri;
        protected DownloadStateListener mListener;

        public BaseDownloadTask(Context context, String url, String outUri, DownloadStateListener listener) {
            this.mContext = context;
            this.mUri = url;
            this.mOutUri = outUri;
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveFile(byte[] result, String outUri) {
            if (TextUtils.isEmpty((CharSequence)outUri)) {
                if (this.mListener != null) {
                    this.mListener.onFailure(601, outUri);
                }
                return;
            }
            File localFile = new File(outUri);
            boolean exist = true;
            if (localFile.getParentFile() != null && !localFile.getParentFile().exists()) {
                exist = localFile.getParentFile().mkdirs();
            }
            if (!exist) {
                if (this.mListener != null) {
                    this.mListener.onFailure(602, outUri);
                }
                return;
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(localFile);
                fos.write(result);
                fos.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        protected byte[] readByteFromStream(InputStream in) throws IOException {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int len = -1;
            long totalLen = 0L;
            while ((len = in.read(buf)) != -1) {
                byteOut.write(buf, 0, len);
                totalLen += (long)len;
                try {
                    int percent;
                    if (this.mListener == null) continue;
                    int n = percent = this.mListener.getTotalSize() < 0L ? 100 : (int)((float)totalLen / ((float)this.mListener.getTotalSize() * 1.0f) * 100.0f);
                    percent = percent < 0 ? 0 : (percent > 100 ? 100 : percent);
                    this.mListener.onProgress(percent);
                    if (!this.isCanceled()) continue;
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            byteOut.close();
            in.close();
            return byteOut.toByteArray();
        }
    }
}

