/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.upgrade.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;

public final class NetworkUtil {
    private NetworkUtil() {
    }

    public static HttpURLConnection setupNetwork(Context context, String urlStr) throws IOException {
        return NetworkUtil.setupNetwork(context, new URL(urlStr));
    }

    public static HttpURLConnection setupNetwork(Context context, URL url) throws IOException {
        HttpURLConnection httpURLConnection = null;
        if (NetworkUtil.isUsingWap(context)) {
            String host = android.net.Proxy.getDefaultHost();
            int port = android.net.Proxy.getDefaultPort();
            httpURLConnection = !TextUtils.isEmpty((CharSequence)host) && port != -1 ? (HttpURLConnection)url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port))) : (HttpURLConnection)url.openConnection();
        } else {
            httpURLConnection = (HttpURLConnection)url.openConnection();
        }
        return httpURLConnection;
    }

    public static boolean isUsingWap(Context context) {
        String netExtraInfo;
        ConnectivityManager connectivityManager;
        NetworkInfo networkInfo;
        boolean result = false;
        if (NetworkUtil.isNetworkAvailable(context) && NetworkUtil.getNetworkConnectType(context) == NetworkConnectType.MOBILE && (networkInfo = (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && !TextUtils.isEmpty((CharSequence)(netExtraInfo = networkInfo.getExtraInfo())) && netExtraInfo.toLowerCase().contains("wap")) {
            result = true;
        }
        return result;
    }

    public static boolean isUsing3g(Context context) {
        String netExtraInfo;
        ConnectivityManager connectivityManager;
        NetworkInfo networkInfo;
        boolean result = false;
        if (NetworkUtil.isNetworkAvailable(context) && NetworkUtil.getNetworkConnectType(context) == NetworkConnectType.MOBILE && (networkInfo = (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && !TextUtils.isEmpty((CharSequence)(netExtraInfo = networkInfo.getExtraInfo())) && netExtraInfo.toLowerCase().contains("3g")) {
            result = true;
        }
        return result;
    }

    public static boolean isNetworkAvailable(Context context) {
        boolean result = false;
        try {
            NetworkInfo[] networkInfos;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null && (networkInfos = connectivityManager.getAllNetworkInfo()) != null) {
                int length = networkInfos.length;
                for (int i = 0; i < length; ++i) {
                    if (networkInfos[i].getState() != NetworkInfo.State.CONNECTED) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static NetworkConnectType getNetworkConnectType(Context context) {
        NetworkConnectType networkConnectType = null;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null) {
            NetworkInfo mobile = connectivityManager.getNetworkInfo(0);
            NetworkInfo wifi = connectivityManager.getNetworkInfo(1);
            if (mobile != null && (mobile.getState() == NetworkInfo.State.CONNECTED || mobile.getState() == NetworkInfo.State.CONNECTING)) {
                networkConnectType = NetworkConnectType.MOBILE;
            } else if (wifi != null && (wifi.getState() == NetworkInfo.State.CONNECTED || wifi.getState() == NetworkInfo.State.CONNECTING)) {
                networkConnectType = NetworkConnectType.WIFI;
            }
        }
        return networkConnectType;
    }

    public static boolean isUsingMobileNetwork(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm != null) {
            NetworkInfo mobile = cm.getNetworkInfo(0);
            return mobile != null && (mobile.getState() == NetworkInfo.State.CONNECTED || mobile.getState() == NetworkInfo.State.CONNECTING);
        }
        return false;
    }

    public static boolean isWIFIAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getType() == 1 && networkInfo.isConnected();
    }

    public static boolean isWIFIor3GNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        int networkType = networkInfo.getType();
        int networkSubType = networkInfo.getSubtype();
        if (networkType == 1) {
            return networkInfo.isConnected();
        }
        if (networkType == 0 && networkSubType == 3) {
            return networkInfo.isConnected();
        }
        return false;
    }

    public static boolean isNetworkRoaming(Context context) {
        TelephonyManager tm;
        NetworkInfo networkInfo;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivity != null && (networkInfo = connectivity.getActiveNetworkInfo()) != null && networkInfo.getType() == 0 && (tm = (TelephonyManager)context.getSystemService("phone")) != null && tm.isNetworkRoaming();
    }

    public static String getNetworkCarrier(Context context) {
        NetworkInfo networkInfo;
        String typeName = "";
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null && (networkInfo = connectivity.getActiveNetworkInfo()) != null && TextUtils.isEmpty((CharSequence)(typeName = networkInfo.getExtraInfo()))) {
            typeName = networkInfo.getTypeName();
        }
        return typeName;
    }

    public static boolean isConnectionFastToSetting(Context context, NetworkConnectType type, int subType) {
        if (type == NetworkConnectType.WIFI) {
            return true;
        }
        if (type == NetworkConnectType.MOBILE) {
            switch (subType) {
                case 13: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isConnectionFastToSetting(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        int networkType = tm.getNetworkType();
        NetworkConnectType type = NetworkUtil.getNetworkConnectType(context);
        return NetworkUtil.isConnectionFastToSetting(context, type, networkType);
    }

    public static boolean isConnectionFast(Context context, NetworkConnectType type, int subType) {
        if (type == NetworkConnectType.WIFI) {
            return true;
        }
        if (type == NetworkConnectType.MOBILE) {
            switch (subType) {
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 1: {
                    return false;
                }
                case 3: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 0: {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isConnectionFast(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        int networkType = tm.getNetworkType();
        NetworkConnectType type = NetworkUtil.getNetworkConnectType(context);
        return NetworkUtil.isConnectionFast(context, type, networkType);
    }

    public static String getNetworkType(Context context) {
        String networkType = "";
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        NetworkConnectType connectType = NetworkUtil.getNetworkConnectType(context);
        int subType = manager.getNetworkType();
        networkType = connectType == NetworkConnectType.MOBILE ? (subType == 4 || subType == 2 || subType == 1 || subType == 0 ? "2g" : (subType == 3 || subType == 8 || subType == 5 || subType == 6 ? "3g" : "2g")) : (connectType == NetworkConnectType.WIFI ? "wifi" : "2g");
        return networkType;
    }

    public static String getNetworkType2(Context context) {
        NetworkInfo ni;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm != null && (ni = cm.getActiveNetworkInfo()) != null) {
            if (ni.getType() == 1) {
                return "wifi";
            }
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null) {
                switch (tm.getNetworkType()) {
                    case 4: {
                        return "2g/cdma";
                    }
                    case 2: {
                        return "2g/edge";
                    }
                    case 1: {
                        return "2g/gprs";
                    }
                    case 3: {
                        return "3g/umts";
                    }
                    case 8: {
                        return "3g/hsdpa";
                    }
                    case 5: {
                        return "3g/evdo_0";
                    }
                    case 6: {
                        return "3g/evdo_a";
                    }
                    case 0: {
                        return "2g";
                    }
                }
            }
        }
        return "";
    }

    public static enum NetworkConnectType {
        MOBILE,
        WIFI;

    }
}

