/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.upgrade;

import android.text.TextUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class UpgradeInfo
implements Serializable {
    private Map<String, String> mUpdateValues;
    private String mJSONStr;
    private String mLocalUrl;
    private int mCheckType;
    private int notifyTimes;
    private long firstNotify;
    private long lastNotify;
    private boolean isFirstNofify;
    private boolean isNotifyDisabled;

    public UpgradeInfo(Map<String, String> values, String jsonStr) {
        if (values == null || values.isEmpty()) {
            this.mUpdateValues = new HashMap<String, String>();
            this.mJSONStr = "";
            return;
        }
        this.mUpdateValues = values;
        this.mJSONStr = jsonStr;
    }

    public boolean isNewVersion() {
        String needUpdateStr = this.mUpdateValues.get("is_needs_update");
        return !TextUtils.isEmpty((CharSequence)needUpdateStr) ? Boolean.valueOf(needUpdateStr) : false;
    }

    public boolean isForceVersion() {
        String forceUpdateStr = this.mUpdateValues.get("force_update");
        return !TextUtils.isEmpty((CharSequence)forceUpdateStr) ? Boolean.valueOf(forceUpdateStr) : false;
    }

    public String getVersionName() {
        return this.mUpdateValues.get("update_version");
    }

    public String getVersionText() {
        return this.mUpdateValues.get("update_text");
    }

    public String getVersionUrl() {
        return this.mUpdateValues.get("download_url");
    }

    public long getVersionSize() {
        String fileSizeStr = this.mUpdateValues.get("file_size");
        return !TextUtils.isEmpty((CharSequence)fileSizeStr) ? Long.parseLong(fileSizeStr) : 0L;
    }

    public String getJSONStr() {
        return this.mJSONStr;
    }

    public boolean isFirstNofify() {
        return this.isFirstNofify;
    }

    public void setIsFirstNofify(boolean isFirstNofify) {
        this.isFirstNofify = isFirstNofify;
    }

    public boolean isNotifyDisabled() {
        return this.isNotifyDisabled;
    }

    public void setIsNotifyDisabled(boolean isNotifyDisabled) {
        this.isNotifyDisabled = isNotifyDisabled;
    }

    public int getCheckType() {
        return this.mCheckType;
    }

    public void setCheckType(int mCheckType) {
        this.mCheckType = mCheckType;
    }

    public int getNotifyTimes() {
        return this.notifyTimes;
    }

    public void setNotifyTimes(int notifyTimes) {
        this.notifyTimes = notifyTimes;
    }

    public long getFirstNotify() {
        return this.firstNotify;
    }

    public void setFirstNotify(long firstNotify) {
        this.firstNotify = firstNotify;
    }

    public long getLastNotify() {
        return this.lastNotify;
    }

    public void setLastNotify(long lastNotify) {
        this.lastNotify = lastNotify;
    }

    public String getLocalUrl() {
        return this.mLocalUrl;
    }

    public void setLocalUrl(String mLocalPath) {
        this.mLocalUrl = mLocalPath;
    }
}

