/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.upgrade;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import tech.guazi.component.upgrade.HostEnvironment;

final class HostManager {
    public final String ONLINE_GUAZI_HOST = "http://wuxian.guazi.com";
    public final String WEB6_GUAZI_HOST = "http://web6.wuxian.corp.guazi.com";
    public final String TEST_GUAZI_HOST = "http://test1.wuxian.corp.guazi.com";
    private static HostManager mInstance = null;
    private HostEnvironment environment = HostEnvironment.ONLINE;
    private Context mContext;

    private HostManager(Context context) {
        this.mContext = context;
        this.environment = this.isDebug(this.mContext) ? HostEnvironment.TEST : HostEnvironment.ONLINE;
    }

    public static synchronized HostManager getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new HostManager(context);
        }
        return mInstance;
    }

    public boolean isDebug(Context ctx) {
        PackageManager packageManager = ctx.getPackageManager();
        PackageInfo packInfo = null;
        String versionName = "";
        try {
            packInfo = packageManager.getPackageInfo(ctx.getPackageName(), 0);
            versionName = packInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return !TextUtils.isEmpty((CharSequence)versionName) && versionName.contains("DEBUG");
    }

    public void setEnvironment(HostEnvironment evn) {
        this.environment = evn;
    }

    public String getHost() {
        if (this.environment == HostEnvironment.TEST) {
            return "http://test1.wuxian.corp.guazi.com";
        }
        if (this.environment == HostEnvironment.WEB6) {
            return "http://web6.wuxian.corp.guazi.com";
        }
        return "http://wuxian.guazi.com";
    }
}

