/*
 * Decompiled with CFR 0.152.
 */
package com.mobile.base.http;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.loopj.android.http.PersistentCookieStore;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import com.mobile.base.http.BaseCache;
import com.mobile.base.http.BaseController;
import com.mobile.base.http.BaseHttpClient;
import com.mobile.base.http.BaseRequest;
import com.mobile.base.http.util.NetworkUtil;
import com.mobile.base.http.util.SignHelper;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;

public class BaseClient {
    private BaseHttpClient client;
    private String tag = "BaseClient";
    private String baseUrl = "";
    private Context context;
    Map<String, String> header = new HashMap<String, String>();

    void setHost(String host) {
        this.baseUrl = host;
    }

    public BaseClient(Context context) {
        this.context = context;
    }

    void setHeader(Map<String, String> map) {
        this.header = map;
    }

    private BaseHttpClient getDefaultHttpClient(String requestName) {
        this.client = new BaseHttpClient();
        PersistentCookieStore myCookieStore = new PersistentCookieStore(this.context);
        this.client.setCookieStore((CookieStore)myCookieStore);
        System.out.println(this.header.size());
        if (this.header != null) {
            for (String key : this.header.keySet()) {
                String value = this.header.get(key);
                this.client.addHeader(key, value);
            }
        }
        return this.client;
    }

    public void get(BaseRequest request, BaseController.AsyncHttpResponseHandlerWrapper asyncHttpResponseHandlerWrapper) {
        String url = this.baseUrl + request.getRequestName();
        Log.d((String)this.tag, (String)("get : " + url));
        this.get(url, request, asyncHttpResponseHandlerWrapper);
    }

    public void post(BaseRequest request, BaseController.AsyncHttpResponseHandlerWrapper asyncHttpResponseHandlerWrapper) {
        String url = this.baseUrl + request.getRequestName();
        Log.d((String)this.tag, (String)("post: " + url));
        this.post(url, request, asyncHttpResponseHandlerWrapper);
    }

    private boolean requestFromCache(BaseController.AsyncHttpResponseHandlerWrapper asyncHttpResponseHandlerWrapper, String cacheKey) {
        boolean fromCache = false;
        String result = BaseCache.getInstance(this.context).getString(cacheKey);
        if (!TextUtils.isEmpty((CharSequence)result)) {
            fromCache = asyncHttpResponseHandlerWrapper.successFromCache(result);
        }
        return fromCache;
    }

    void recordCacheKey(BaseRequest request, BaseController.AsyncHttpResponseHandlerWrapper asyncHttpResponseHandlerWrapper, String cacheKey) {
        asyncHttpResponseHandlerWrapper.setCacheKey(cacheKey);
        asyncHttpResponseHandlerWrapper.setCacheSecond(request.getCacheSecond());
    }

    public void cancel() {
        this.client.cancelAllRequests(true);
    }

    public void get(String url, BaseRequest request, BaseController.AsyncHttpResponseHandlerWrapper asyncHttpResponseHandlerWrapper) {
        String value;
        BaseHttpClient baseHttpClient = this.getDefaultHttpClient(request.getRequestName());
        RequestParams params = new RequestParams();
        String token = SignHelper.getTokens(url, request.getParams(), request.postParams());
        if (request.getParams().size() > 0) {
            for (String key : request.getParams().keySet()) {
                value = request.getParams().get(key);
                try {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                params.put(key, value);
                Log.d((String)this.tag, (String)("get : params" + key + "," + value));
            }
        }
        if (request.postParams().size() > 0) {
            for (String key : request.postParams().keySet()) {
                value = request.postParams().get(key);
                params.put(key, value);
                Log.d((String)this.tag, (String)("post : params" + key + "," + value));
            }
        }
        String spacer = url.contains("?") ? "&" : "?";
        url = url + spacer + "sign=" + token;
        Log.d((String)this.tag, (String)url);
        String cacheKey = token + request.getRequestName();
        switch (request.getCacheType()) {
            case TIME_CACHE: {
                if (this.requestFromCache(asyncHttpResponseHandlerWrapper, cacheKey)) break;
                this.recordCacheKey(request, asyncHttpResponseHandlerWrapper, cacheKey);
                baseHttpClient.get(url, params, (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
                break;
            }
            case NO_CACHE: {
                baseHttpClient.get(url, params, (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
                break;
            }
            case CACHE_WHEN_NO_NET: {
                if (!NetworkUtil.isNetworkAvailable(this.context)) {
                    this.requestFromCache(asyncHttpResponseHandlerWrapper, cacheKey);
                    break;
                }
                this.recordCacheKey(request, asyncHttpResponseHandlerWrapper, cacheKey);
                baseHttpClient.get(url, params, (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
            }
        }
    }

    public void delete(BaseRequest request, BaseController.AsyncHttpResponseHandlerWrapper asyncHttpResponseHandlerWrapper) {
        BaseHttpClient baseHttpClient = this.getDefaultHttpClient(request.getRequestName());
        String url = this.baseUrl + request.getRequestName();
        String token = SignHelper.getTokens(url, request.getParams(), request.postParams());
        RequestParams params = new RequestParams();
        if (request.postParams().size() > 0) {
            for (String key : request.postParams().keySet()) {
                String value = request.postParams().get(key);
                params.put(key, value);
                Log.d((String)this.tag, (String)("delete : params" + key + "," + value));
            }
        }
        String spacer = url.contains("?") ? "&" : "?";
        url = url + spacer + "sign=" + token;
        StringBuffer urlStringBuffer = new StringBuffer(url);
        if (request.getParams() != null) {
            for (String key : request.getParams().keySet()) {
                String value = request.getParams().get(key);
                try {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                urlStringBuffer.append("&").append(key).append("=").append(value);
            }
        }
        url = urlStringBuffer.toString();
        Log.d((String)this.tag, (String)url);
        baseHttpClient.delete(this.context, url, null, params, (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
    }

    public void put(BaseRequest request, BaseController.AsyncHttpResponseHandlerWrapper asyncHttpResponseHandlerWrapper) {
        String url = this.baseUrl + request.getRequestName();
        BaseHttpClient baseHttpClient = this.getDefaultHttpClient(request.getRequestName());
        String token = SignHelper.getTokens(url, request.getParams(), request.postParams());
        RequestParams params = new RequestParams();
        if (request.postParams().size() > 0) {
            for (String key : request.postParams().keySet()) {
                String value = request.postParams().get(key);
                params.put(key, value);
                Log.d((String)this.tag, (String)("put : params" + key + "," + value));
            }
        }
        String spacer = url.contains("?") ? "&" : "?";
        url = url + spacer + "sign=" + token;
        StringBuffer urlStringBuffer = new StringBuffer(url);
        if (request.getParams() != null) {
            for (String key : request.getParams().keySet()) {
                String value = request.getParams().get(key);
                try {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                urlStringBuffer.append("&").append(key).append("=").append(value);
            }
        }
        url = urlStringBuffer.toString();
        Log.d((String)this.tag, (String)url);
        if (request.jsonObject != null) {
            StringEntity entity = null;
            try {
                entity = new StringEntity(request.jsonObject.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            baseHttpClient.put(this.context, url, (HttpEntity)entity, "application/json", (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
        } else {
            baseHttpClient.put(url, params, (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
        }
    }

    public void post(String url, BaseRequest request, BaseController.AsyncHttpResponseHandlerWrapper asyncHttpResponseHandlerWrapper) {
        BaseHttpClient baseHttpClient = this.getDefaultHttpClient(request.getRequestName());
        String token = SignHelper.getTokens(url, request.getParams(), request.postParams());
        RequestParams params = new RequestParams();
        if (request.postParams().size() > 0) {
            for (String key : request.postParams().keySet()) {
                String value = request.postParams().get(key);
                params.put(key, value);
                Log.d((String)this.tag, (String)("post : params" + key + "," + value));
            }
        }
        if (request.getFileParams().size() > 0) {
            for (String key : request.getFileParams().keySet()) {
                try {
                    params.put(key, request.getFileParams().get(key));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        String spacer = url.contains("?") ? "&" : "?";
        url = url + spacer + "sign=" + token;
        StringBuffer urlStringBuffer = new StringBuffer(url);
        if (request.getParams() != null) {
            for (String key : request.getParams().keySet()) {
                String value = request.getParams().get(key);
                try {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                urlStringBuffer.append("&").append(key).append("=").append(value);
            }
        }
        url = urlStringBuffer.toString();
        Log.d((String)this.tag, (String)url);
        String cacheKey = token + request.getRequestName();
        switch (request.getCacheType()) {
            case TIME_CACHE: {
                StringEntity entity;
                if (this.requestFromCache(asyncHttpResponseHandlerWrapper, cacheKey)) break;
                this.recordCacheKey(request, asyncHttpResponseHandlerWrapper, cacheKey);
                if (request.jsonObject != null) {
                    entity = null;
                    try {
                        entity = new StringEntity(request.jsonObject.toString(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    baseHttpClient.post(this.context, url, (HttpEntity)entity, "application/json", (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
                    break;
                }
                baseHttpClient.post(url, params, (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
                break;
            }
            case NO_CACHE: {
                StringEntity entity;
                if (request.jsonObject != null) {
                    entity = null;
                    try {
                        entity = new StringEntity(request.jsonObject.toString(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    baseHttpClient.post(this.context, url, (HttpEntity)entity, "application/json", (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
                    break;
                }
                baseHttpClient.post(url, params, (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
                break;
            }
            case CACHE_WHEN_NO_NET: {
                StringEntity entity;
                if (!NetworkUtil.isNetworkAvailable(this.context)) {
                    this.requestFromCache(asyncHttpResponseHandlerWrapper, cacheKey);
                    break;
                }
                this.recordCacheKey(request, asyncHttpResponseHandlerWrapper, cacheKey);
                if (request.jsonObject != null) {
                    entity = null;
                    try {
                        entity = new StringEntity(request.jsonObject.toString(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    baseHttpClient.post(this.context, url, (HttpEntity)entity, "application/json", (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
                    break;
                }
                baseHttpClient.post(url, params, (ResponseHandlerInterface)asyncHttpResponseHandlerWrapper);
            }
        }
    }

    HttpContext getHttpContext() {
        return this.client.getHttpContext();
    }

    void setCookieStore(CookieStore cookieStore) {
        this.client.setCookieStore(cookieStore);
    }
}

