/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.shaded.messages.types;

import io.cucumber.shaded.messages.types.Duration;
import java.util.HashMap;
import java.util.Map;

public class TestStepResult {
    private Duration duration;
    private String message;
    private Status status;

    public TestStepResult() {
    }

    public TestStepResult(Duration duration, String message, Status status) {
        this.duration = duration;
        this.message = message;
        this.status = status;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestStepResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("duration");
        sb.append('=');
        sb.append(this.duration == null ? "<null>" : this.duration);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.duration == null ? 0 : this.duration.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestStepResult)) {
            return false;
        }
        TestStepResult rhs = (TestStepResult)other;
        return (this.duration == rhs.duration || this.duration != null && this.duration.equals(rhs.duration)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }

    public static enum Status {
        UNKNOWN("UNKNOWN"),
        PASSED("PASSED"),
        SKIPPED("SKIPPED"),
        PENDING("PENDING"),
        UNDEFINED("UNDEFINED"),
        AMBIGUOUS("AMBIGUOUS"),
        FAILED("FAILED");

        private final String value;
        private static final Map<String, Status> CONSTANTS;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static Status fromValue(String value) {
            Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Status>();
            for (Status c : Status.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

