/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.cucumber.adapter;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.internal.gherkin.AstBuilder;
import io.cucumber.core.internal.gherkin.Parser;
import io.cucumber.core.internal.gherkin.ParserException;
import io.cucumber.core.internal.gherkin.TokenMatcher;
import io.cucumber.core.internal.gherkin.ast.Background;
import io.cucumber.core.internal.gherkin.ast.Examples;
import io.cucumber.core.internal.gherkin.ast.Feature;
import io.cucumber.core.internal.gherkin.ast.GherkinDocument;
import io.cucumber.core.internal.gherkin.ast.Node;
import io.cucumber.core.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.internal.gherkin.ast.ScenarioOutline;
import io.cucumber.core.internal.gherkin.ast.Step;
import io.cucumber.core.internal.gherkin.ast.TableRow;
import io.cucumber.plugin.event.TestSourceRead;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

final class TestSourcesModel {
    private final Map<URI, TestSourceRead> pathToReadEventMap = new HashMap<URI, TestSourceRead>();
    private final Map<URI, GherkinDocument> pathToAstMap = new HashMap<URI, GherkinDocument>();
    private final Map<URI, Map<Integer, AstNode>> pathToNodeMap = new HashMap<URI, Map<Integer, AstNode>>();

    TestSourcesModel() {
    }

    private static Feature getFeatureForTestCase(AstNode astNode) {
        while (astNode.parent != null) {
            astNode = astNode.parent;
        }
        return (Feature)astNode.node;
    }

    static Background getBackgroundForTestCase(AstNode astNode) {
        Feature feature = TestSourcesModel.getFeatureForTestCase(astNode);
        ScenarioDefinition backgound = (ScenarioDefinition)feature.getChildren().get(0);
        if (backgound instanceof Background) {
            return (Background)backgound;
        }
        return null;
    }

    static ScenarioDefinition getScenarioDefinition(AstNode astNode) {
        return astNode.node instanceof ScenarioDefinition ? (ScenarioDefinition)astNode.node : (ScenarioDefinition)astNode.parent.parent.node;
    }

    static boolean isScenarioOutlineScenario(AstNode astNode) {
        return !(astNode.node instanceof ScenarioDefinition);
    }

    static boolean isBackgroundStep(AstNode astNode) {
        return astNode.parent.node instanceof Background;
    }

    static String calculateId(AstNode astNode) {
        Node node = astNode.node;
        if (node instanceof ScenarioDefinition) {
            return TestSourcesModel.calculateId(astNode.parent) + ";" + TestSourcesModel.convertToId(((ScenarioDefinition)node).getName());
        }
        if (node instanceof ExamplesRowWrapperNode) {
            return TestSourcesModel.calculateId(astNode.parent) + ";" + (((ExamplesRowWrapperNode)node).bodyRowIndex + 2);
        }
        if (node instanceof TableRow) {
            return TestSourcesModel.calculateId(astNode.parent) + ";" + 1;
        }
        if (node instanceof Examples) {
            return TestSourcesModel.calculateId(astNode.parent) + ";" + TestSourcesModel.convertToId(((Examples)node).getName());
        }
        if (node instanceof Feature) {
            return TestSourcesModel.convertToId(((Feature)node).getName());
        }
        return "";
    }

    static String convertToId(String name) {
        return name.replaceAll("[\\s'_,!]", "-").toLowerCase();
    }

    static URI relativize(URI uri) {
        if (!"file".equals(uri.getScheme())) {
            return uri;
        }
        if (!uri.isAbsolute()) {
            return uri;
        }
        try {
            URI root = new File("").toURI();
            URI relative = root.relativize(uri);
            return new URI("file", relative.getSchemeSpecificPart(), relative.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    void addTestSourceReadEvent(URI path, TestSourceRead event) {
        this.pathToReadEventMap.put(path, event);
    }

    Feature getFeature(URI path) {
        if (!this.pathToAstMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToAstMap.containsKey(path)) {
            return this.pathToAstMap.get(path).getFeature();
        }
        return null;
    }

    AstNode getAstNode(URI path, int line) {
        if (!this.pathToNodeMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToNodeMap.containsKey(path)) {
            return this.pathToNodeMap.get(path).get(line);
        }
        return null;
    }

    boolean hasBackground(URI path, int line) {
        if (!this.pathToNodeMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToNodeMap.containsKey(path)) {
            AstNode astNode = this.pathToNodeMap.get(path).get(line);
            return TestSourcesModel.getBackgroundForTestCase(astNode) != null;
        }
        return false;
    }

    private void parseGherkinSource(URI path) {
        if (!this.pathToReadEventMap.containsKey(path)) {
            return;
        }
        Parser parser = new Parser((Parser.Builder)new AstBuilder());
        TokenMatcher matcher = new TokenMatcher();
        try {
            GherkinDocument gherkinDocument = (GherkinDocument)parser.parse(this.pathToReadEventMap.get(path).getSource(), (Parser.ITokenMatcher)matcher);
            this.pathToAstMap.put(path, gherkinDocument);
            HashMap<Integer, AstNode> nodeMap = new HashMap<Integer, AstNode>();
            AstNode currentParent = new AstNode((Node)gherkinDocument.getFeature(), null);
            for (ScenarioDefinition child : gherkinDocument.getFeature().getChildren()) {
                this.processScenarioDefinition(nodeMap, child, currentParent);
            }
            this.pathToNodeMap.put(path, nodeMap);
        }
        catch (ParserException e) {
            throw new CucumberException("You are using a plugin that does not support Gherkin 8+.\nTry to remove the html and/or json formatters. See the\nCucumber-JVM 5.0.0 release announcement for more information.", (Throwable)e);
        }
    }

    private void processScenarioDefinition(Map<Integer, AstNode> nodeMap, ScenarioDefinition child, AstNode currentParent) {
        AstNode childNode = new AstNode((Node)child, currentParent);
        nodeMap.put(child.getLocation().getLine(), childNode);
        for (Step step : child.getSteps()) {
            nodeMap.put(step.getLocation().getLine(), new AstNode((Node)step, childNode));
        }
        if (child instanceof ScenarioOutline) {
            this.processScenarioOutlineExamples(nodeMap, (ScenarioOutline)child, childNode);
        }
    }

    private void processScenarioOutlineExamples(Map<Integer, AstNode> nodeMap, ScenarioOutline scenarioOutline, AstNode childNode) {
        for (Examples examples : scenarioOutline.getExamples()) {
            AstNode examplesNode = new AstNode((Node)examples, childNode);
            TableRow headerRow = examples.getTableHeader();
            AstNode headerNode = new AstNode((Node)headerRow, examplesNode);
            nodeMap.put(headerRow.getLocation().getLine(), headerNode);
            for (int i = 0; i < examples.getTableBody().size(); ++i) {
                TableRow examplesRow = (TableRow)examples.getTableBody().get(i);
                ExamplesRowWrapperNode rowNode = new ExamplesRowWrapperNode((Node)examplesRow, i);
                AstNode expandedScenarioNode = new AstNode(rowNode, examplesNode);
                nodeMap.put(examplesRow.getLocation().getLine(), expandedScenarioNode);
            }
        }
    }

    static class AstNode {
        final Node node;
        final AstNode parent;

        AstNode(Node node, AstNode parent) {
            this.node = node;
            this.parent = parent;
        }
    }

    static class ExamplesRowWrapperNode
    extends Node {
        final int bodyRowIndex;

        ExamplesRowWrapperNode(Node examplesRow, int bodyRowIndex) {
            super(examplesRow.getLocation());
            this.bodyRowIndex = bodyRowIndex;
        }
    }
}

