/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.cucumber.adapter;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.MediaEntityBuilder;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.cucumber.adapter.TestSourcesModel;
import com.aventstack.extentreports.cucumber.adapter.URLOutputStream;
import com.aventstack.extentreports.gherkin.model.Asterisk;
import com.aventstack.extentreports.gherkin.model.Feature;
import com.aventstack.extentreports.gherkin.model.Scenario;
import com.aventstack.extentreports.markuputils.MarkupHelper;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.service.ExtentService;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.internal.gherkin.ast.Examples;
import io.cucumber.core.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.internal.gherkin.ast.ScenarioOutline;
import io.cucumber.core.internal.gherkin.ast.Step;
import io.cucumber.core.internal.gherkin.ast.TableCell;
import io.cucumber.core.internal.gherkin.ast.TableRow;
import io.cucumber.core.internal.gherkin.ast.Tag;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.StrictAware;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.DocStringArgument;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ExtentCucumberAdapter
implements ConcurrentEventListener,
StrictAware {
    private static Map<String, ExtentTest> featureMap = new ConcurrentHashMap<String, ExtentTest>();
    private static ThreadLocal<ExtentTest> featureTestThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private static Map<String, ExtentTest> scenarioOutlineMap = new ConcurrentHashMap<String, ExtentTest>();
    private static ThreadLocal<ExtentTest> scenarioOutlineThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private static ThreadLocal<ExtentTest> scenarioThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private static ThreadLocal<Boolean> isHookThreadLocal = new InheritableThreadLocal<Boolean>();
    private static ThreadLocal<ExtentTest> stepTestThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private static ThreadLocal<Set<String>> featureTagsThreadLocal = new InheritableThreadLocal<Set<String>>();
    private static ThreadLocal<Set<String>> scenarioOutlineTagsThreadLocal = new InheritableThreadLocal<Set<String>>();
    private boolean strict = false;
    private static final Map<String, String> MIME_TYPES_EXTENSIONS = new HashMap<String, String>(){
        {
            this.put("image/bmp", "bmp");
            this.put("image/gif", "gif");
            this.put("image/jpeg", "jpeg");
            this.put("image/jpg", "jpg");
            this.put("image/png", "png");
            this.put("image/svg+xml", "svg");
        }
    };
    private static final AtomicInteger EMBEDDED_INT = new AtomicInteger(0);
    private final TestSourcesModel testSources = new TestSourcesModel();
    private ThreadLocal<URI> currentFeatureFile = new ThreadLocal();
    private ThreadLocal<ScenarioOutline> currentScenarioOutline = new InheritableThreadLocal<ScenarioOutline>();
    private ThreadLocal<Examples> currentExamples = new InheritableThreadLocal<Examples>();
    private EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        public void receive(TestSourceRead event) {
            ExtentCucumberAdapter.this.handleTestSourceRead(event);
        }
    };
    private EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            ExtentCucumberAdapter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestStepStarted> stepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            ExtentCucumberAdapter.this.handleTestStepStarted(event);
        }
    };
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            ExtentCucumberAdapter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<EmbedEvent> embedEventhandler = new EventHandler<EmbedEvent>(){

        public void receive(EmbedEvent event) {
            ExtentCucumberAdapter.this.handleEmbed(event);
        }
    };
    private EventHandler<WriteEvent> writeEventhandler = new EventHandler<WriteEvent>(){

        public void receive(WriteEvent event) {
            ExtentCucumberAdapter.this.handleWrite(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            ExtentCucumberAdapter.this.finishReport();
        }
    };

    public ExtentCucumberAdapter(String arg) {
        ExtentService.getInstance();
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventhandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventhandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.getUri(), event);
    }

    private synchronized void handleTestCaseStarted(TestCaseStarted event) {
        this.handleStartOfFeature(event.getTestCase());
        this.handleScenarioOutline(event.getTestCase());
        this.createTestCase(event.getTestCase());
    }

    private synchronized void handleTestStepStarted(TestStepStarted event) {
        isHookThreadLocal.set(false);
        if (event.getTestStep() instanceof HookTestStep) {
            ExtentTest t = scenarioThreadLocal.get().createNode(Asterisk.class, event.getTestStep().getCodeLocation(), ((HookTestStep)event.getTestStep()).getHookType().toString().toUpperCase());
            stepTestThreadLocal.set(t);
            isHookThreadLocal.set(true);
        }
        if (event.getTestStep() instanceof PickleStepTestStep) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.getTestStep();
            this.createTestStep(testStep);
        }
    }

    private synchronized void handleTestStepFinished(TestStepFinished event) {
        this.updateResult(event.getResult());
    }

    private synchronized void updateResult(Result result) {
        Test test = stepTestThreadLocal.get().getModel();
        switch (result.getStatus().name().toLowerCase()) {
            case "failed": {
                stepTestThreadLocal.get().fail(result.getError());
                break;
            }
            case "undefined": {
                if (this.strict) {
                    stepTestThreadLocal.get().fail("Step undefined");
                    break;
                }
                stepTestThreadLocal.get().skip("Step undefined");
                break;
            }
            case "pending": {
                if (this.strict) {
                    stepTestThreadLocal.get().fail(result.getError());
                    break;
                }
                stepTestThreadLocal.get().skip(result.getError());
                break;
            }
            case "skipped": {
                boolean currentEndingEventSkipped;
                if (isHookThreadLocal.get().booleanValue()) {
                    ExtentService.getInstance().removeTest(stepTestThreadLocal.get());
                    break;
                }
                boolean bl = test.hasLog() ? ((Log)test.getLogs().get(test.getLogs().size() - 1)).getStatus() == Status.SKIP : (currentEndingEventSkipped = false);
                if (result.getError() != null) {
                    stepTestThreadLocal.get().skip(result.getError());
                    break;
                }
                if (currentEndingEventSkipped) break;
                String details = result.getError() == null ? "Step skipped" : result.getError().getMessage();
                stepTestThreadLocal.get().skip(details);
                break;
            }
            case "passed": {
                if (stepTestThreadLocal.get() == null) break;
                if (isHookThreadLocal.get().booleanValue()) {
                    boolean mediaLogs;
                    boolean bl = mediaLogs = !test.getLogs().stream().filter(l -> l.getMedia() != null).collect(Collectors.toList()).isEmpty();
                    if (!test.hasLog() && !mediaLogs) {
                        ExtentService.getInstance().removeTest(stepTestThreadLocal.get());
                    }
                }
                stepTestThreadLocal.get().pass("");
                break;
            }
        }
    }

    private synchronized void handleEmbed(EmbedEvent event) {
        String mimeType = event.getMediaType();
        String extension = MIME_TYPES_EXTENSIONS.get(mimeType);
        if (extension != null) {
            String title;
            if (stepTestThreadLocal.get() == null) {
                ExtentTest t = scenarioThreadLocal.get().createNode(Asterisk.class, "Embed");
                stepTestThreadLocal.set(t);
            }
            String string = title = event.getName() == null ? "" : event.getName();
            if (ExtentService.isBase64ImageSrcEnabled() && mimeType.startsWith("image/")) {
                stepTestThreadLocal.get().info(title, MediaEntityBuilder.createScreenCaptureFromBase64String((String)Base64.getEncoder().encodeToString(event.getData())).build());
            } else {
                StringBuilder fileName = new StringBuilder("embedded").append(EMBEDDED_INT.incrementAndGet()).append(".").append(extension);
                try {
                    URL url = this.toUrl(fileName.toString());
                    ExtentCucumberAdapter.writeBytesToURL(event.getData(), url);
                    try {
                        File file = new File(url.toURI());
                        stepTestThreadLocal.get().info(title, MediaEntityBuilder.createScreenCaptureFromPath((String)(ExtentService.getScreenshotReportRelatvePath() + file.getName())).build());
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void writeBytesToURL(byte[] buf, URL url) throws IOException {
        OutputStream out = ExtentCucumberAdapter.createReportFileOutputStream(url);
        try {
            out.write(buf);
        }
        catch (IOException e) {
            throw new IOException("Unable to write to report file item: ", e);
        }
    }

    private static OutputStream createReportFileOutputStream(URL url) {
        try {
            return new URLOutputStream(url);
        }
        catch (IOException | URISyntaxException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private URL toUrl(String fileName) {
        try {
            URL url = Paths.get(ExtentService.getScreenshotFolderName(), fileName).toUri().toURL();
            return url;
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private synchronized void handleWrite(WriteEvent event) {
        String text = event.getText();
        if (text != null && !text.isEmpty()) {
            stepTestThreadLocal.get().info(text);
        }
    }

    private void finishReport() {
        ExtentService.getInstance().flush();
    }

    private synchronized void handleStartOfFeature(TestCase testCase) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(testCase.getUri())) {
            this.currentFeatureFile.set(testCase.getUri());
            this.createFeature(testCase);
        }
    }

    private synchronized void createFeature(TestCase testCase) {
        io.cucumber.core.internal.gherkin.ast.Feature feature = this.testSources.getFeature(testCase.getUri());
        try {
            ExtentService.getInstance().setGherkinDialect(feature.getLanguage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (feature != null) {
            if (featureMap.containsKey(feature.getName())) {
                featureTestThreadLocal.set(featureMap.get(feature.getName()));
                return;
            }
            if (featureTestThreadLocal.get() != null && featureTestThreadLocal.get().getModel().getName().equals(feature.getName())) {
                return;
            }
            ExtentTest t = ExtentService.getInstance().createTest(Feature.class, feature.getName(), feature.getDescription());
            featureTestThreadLocal.set(t);
            featureMap.put(feature.getName(), t);
            Set tagList = feature.getTags().stream().map(tag -> tag.getName()).collect(Collectors.toSet());
            featureTagsThreadLocal.set(tagList);
        }
    }

    private List<String> createTagsList(List<Tag> tags) {
        ArrayList<String> tagList = new ArrayList<String>();
        for (Tag tag : tags) {
            tagList.add(tag.getName());
        }
        return tagList;
    }

    private synchronized void handleScenarioOutline(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile.get(), testCase.getLine());
        if (TestSourcesModel.isScenarioOutlineScenario(astNode)) {
            ScenarioOutline scenarioOutline = (ScenarioOutline)TestSourcesModel.getScenarioDefinition(astNode);
            if (this.currentScenarioOutline.get() == null || !this.currentScenarioOutline.get().getName().equals(scenarioOutline.getName())) {
                scenarioOutlineThreadLocal.set(null);
                this.createScenarioOutline(scenarioOutline);
                this.currentScenarioOutline.set(scenarioOutline);
            }
            Examples examples = (Examples)astNode.parent.node;
            if (this.currentExamples.get() == null || !this.currentExamples.get().equals(examples)) {
                this.currentExamples.set(examples);
                this.createExamples(examples);
            }
        } else {
            scenarioOutlineThreadLocal.set(null);
            this.currentScenarioOutline.set(null);
            this.currentExamples.set(null);
        }
    }

    private synchronized void createScenarioOutline(ScenarioOutline scenarioOutline) {
        if (scenarioOutlineMap.containsKey(scenarioOutline.getName())) {
            scenarioOutlineThreadLocal.set(scenarioOutlineMap.get(scenarioOutline.getName()));
            return;
        }
        if (scenarioOutlineThreadLocal.get() == null) {
            ExtentTest t = featureTestThreadLocal.get().createNode(com.aventstack.extentreports.gherkin.model.ScenarioOutline.class, scenarioOutline.getName(), scenarioOutline.getDescription());
            scenarioOutlineThreadLocal.set(t);
            scenarioOutlineMap.put(scenarioOutline.getName(), t);
            Set tagList = scenarioOutline.getTags().stream().map(tag -> tag.getName()).collect(Collectors.toSet());
            scenarioOutlineTagsThreadLocal.set(tagList);
        }
    }

    private void createExamples(Examples examples) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        rows.add(examples.getTableHeader());
        rows.addAll(examples.getTableBody());
        String[][] data = this.getTable(rows);
        String markup = MarkupHelper.createTable((String[][])data).getMarkup();
        if (examples.getName() != null && !examples.getName().isEmpty()) {
            markup = examples.getName() + markup;
        }
        markup = (scenarioOutlineThreadLocal.get().getModel().getDescription() == null ? "" : scenarioOutlineThreadLocal.get().getModel().getDescription() + "<br><br>") + markup;
        scenarioOutlineThreadLocal.get().getModel().setDescription(markup);
    }

    private String[][] getTable(List<TableRow> rows) {
        String[][] data = null;
        int rowSize = rows.size();
        for (int i = 0; i < rowSize; ++i) {
            TableRow row = rows.get(i);
            List cells = row.getCells();
            int cellSize = cells.size();
            if (data == null) {
                data = new String[rowSize][cellSize];
            }
            for (int j = 0; j < cellSize; ++j) {
                data[i][j] = ((TableCell)cells.get(j)).getValue();
            }
        }
        return data;
    }

    private synchronized void createTestCase(TestCase testCase) {
        Test parent;
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile.get(), testCase.getLine());
        if (astNode != null) {
            ScenarioDefinition scenarioDefinition = TestSourcesModel.getScenarioDefinition(astNode);
            ExtentTest parent2 = scenarioOutlineThreadLocal.get() != null ? scenarioOutlineThreadLocal.get() : featureTestThreadLocal.get();
            ExtentTest t = parent2.createNode(Scenario.class, testCase.getName(), scenarioDefinition.getDescription());
            scenarioThreadLocal.set(t);
        }
        if (!testCase.getTags().isEmpty()) {
            this.updateCategoryAndDeviceAndAuthor(testCase.getTags());
        }
        if (featureTagsThreadLocal.get() != null) {
            this.updateCategoryAndDeviceAndAuthor((Collection<String>)featureTagsThreadLocal.get());
        }
        if ((parent = scenarioThreadLocal.get().getModel().getParent()).getBddType() == com.aventstack.extentreports.gherkin.model.ScenarioOutline.class && scenarioOutlineTagsThreadLocal.get() != null) {
            scenarioOutlineTagsThreadLocal.get().forEach(x -> scenarioThreadLocal.get().assignCategory(new String[]{x}));
            this.updateCategoryAndDeviceAndAuthor((Collection<String>)scenarioOutlineTagsThreadLocal.get());
        }
    }

    private void updateCategoryAndDeviceAndAuthor(Collection<String> tags) {
        tags.forEach(t -> {
            if (ExtentService.isDeviceEnabled() && this.isValidDeviceTag((String)t)) {
                scenarioThreadLocal.get().assignDevice(new String[]{t.substring(ExtentService.getDevicePrefix().length())});
            } else if (ExtentService.isAuthorEnabled() && this.isValidAuthoTag((String)t)) {
                scenarioThreadLocal.get().assignAuthor(new String[]{t.substring(ExtentService.getAuthorPrefix().length())});
            } else {
                scenarioThreadLocal.get().assignCategory(new String[]{t});
            }
        });
    }

    private boolean isValidDeviceTag(String tag) {
        return tag.startsWith(ExtentService.getDevicePrefix()) && tag.length() > ExtentService.getDevicePrefix().length();
    }

    private boolean isValidAuthoTag(String tag) {
        return tag.startsWith(ExtentService.getAuthorPrefix()) && tag.length() > ExtentService.getAuthorPrefix().length();
    }

    private synchronized void createTestStep(PickleStepTestStep testStep) {
        StepArgument argument;
        String stepName = testStep.getStep().getText();
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile.get(), testStep.getStep().getLine());
        if (astNode != null) {
            Step step = (Step)astNode.node;
            try {
                String name = stepName == null || stepName.isEmpty() ? step.getText().replace("<", "&lt;").replace(">", "&gt;") : stepName;
                ExtentTest t = scenarioThreadLocal.get().createNode(new GherkinKeyword(step.getKeyword().trim()), step.getKeyword() + name, testStep.getCodeLocation());
                stepTestThreadLocal.set(t);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if ((argument = testStep.getStep().getArgument()) != null) {
            if (argument instanceof DocStringArgument) {
                stepTestThreadLocal.get().pass(MarkupHelper.createCodeBlock((String)((DocStringArgument)argument).getContent()));
            } else if (argument instanceof DataTableArgument) {
                stepTestThreadLocal.get().pass(MarkupHelper.createTable((String[][])this.createDataTableList((DataTableArgument)argument)).getMarkup());
            }
        }
    }

    private String[][] createDataTableList(DataTableArgument dataTable) {
        List cells = dataTable.cells();
        int rowSize = cells.size();
        int cellSize = ((List)cells.get(0)).size();
        String[][] data = new String[rowSize][cellSize];
        for (int i = 0; i < rowSize; ++i) {
            for (int j = 0; j < cellSize; ++j) {
                data[i][j] = (String)((List)cells.get(i)).get(j);
            }
        }
        return data;
    }

    public static synchronized void addTestStepLog(String message) {
        stepTestThreadLocal.get().info(message);
    }

    public static synchronized void addTestStepScreenCaptureFromPath(String imagePath) throws IOException {
        stepTestThreadLocal.get().addScreenCaptureFromPath(imagePath);
    }

    public static synchronized void addTestStepScreenCaptureFromPath(String imagePath, String title) throws IOException {
        stepTestThreadLocal.get().addScreenCaptureFromPath(imagePath, title);
    }

    public static ExtentTest getCurrentStep() {
        return stepTestThreadLocal.get();
    }
}

