/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.cucumber.adapter;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.MediaEntityBuilder;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.cucumber.adapter.TestSourcesModel;
import com.aventstack.extentreports.cucumber.adapter.URLOutputStream;
import com.aventstack.extentreports.gherkin.model.Asterisk;
import com.aventstack.extentreports.gherkin.model.Feature;
import com.aventstack.extentreports.gherkin.model.Scenario;
import com.aventstack.extentreports.markuputils.MarkupHelper;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.service.LogService;
import com.aventstack.extentreports.model.service.TestService;
import com.aventstack.extentreports.service.ExtentService;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.internal.gherkin.ast.DataTable;
import io.cucumber.core.internal.gherkin.ast.DocString;
import io.cucumber.core.internal.gherkin.ast.Examples;
import io.cucumber.core.internal.gherkin.ast.Node;
import io.cucumber.core.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.internal.gherkin.ast.ScenarioOutline;
import io.cucumber.core.internal.gherkin.ast.Step;
import io.cucumber.core.internal.gherkin.ast.TableCell;
import io.cucumber.core.internal.gherkin.ast.TableRow;
import io.cucumber.core.internal.gherkin.ast.Tag;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.StrictAware;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.DocStringArgument;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ExtentCucumberAdapter
implements ConcurrentEventListener,
StrictAware {
    private static final String SCREENSHOT_DIR_PROPERTY = "screenshot.dir";
    private static final String SCREENSHOT_REL_PATH_PROPERTY = "screenshot.rel.path";
    private static Map<String, ExtentTest> featureMap = new ConcurrentHashMap<String, ExtentTest>();
    private static ThreadLocal<ExtentTest> featureTestThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private static Map<String, ExtentTest> scenarioOutlineMap = new ConcurrentHashMap<String, ExtentTest>();
    private static ThreadLocal<ExtentTest> scenarioOutlineThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private static ThreadLocal<ExtentTest> scenarioThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private static ThreadLocal<Boolean> isHookThreadLocal = new InheritableThreadLocal<Boolean>();
    private static ThreadLocal<ExtentTest> stepTestThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private String screenshotDir;
    private String screenshotRelPath;
    private boolean strict = false;
    private static final Map<String, String> MIME_TYPES_EXTENSIONS = new HashMap<String, String>(){
        {
            this.put("image/bmp", "bmp");
            this.put("image/gif", "gif");
            this.put("image/jpeg", "jpg");
            this.put("image/png", "png");
            this.put("image/svg+xml", "svg");
            this.put("video/ogg", "ogg");
        }
    };
    private static final AtomicInteger EMBEDDED_INT = new AtomicInteger(0);
    private final TestSourcesModel testSources = new TestSourcesModel();
    private ThreadLocal<URI> currentFeatureFile = new ThreadLocal();
    private ThreadLocal<ScenarioOutline> currentScenarioOutline = new InheritableThreadLocal<ScenarioOutline>();
    private ThreadLocal<Examples> currentExamples = new InheritableThreadLocal<Examples>();
    private EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        public void receive(TestSourceRead event) {
            ExtentCucumberAdapter.this.handleTestSourceRead(event);
        }
    };
    private EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            ExtentCucumberAdapter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestStepStarted> stepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            ExtentCucumberAdapter.this.handleTestStepStarted(event);
        }
    };
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            ExtentCucumberAdapter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<EmbedEvent> embedEventhandler = new EventHandler<EmbedEvent>(){

        public void receive(EmbedEvent event) {
            ExtentCucumberAdapter.this.handleEmbed(event);
        }
    };
    private EventHandler<WriteEvent> writeEventhandler = new EventHandler<WriteEvent>(){

        public void receive(WriteEvent event) {
            ExtentCucumberAdapter.this.handleWrite(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            ExtentCucumberAdapter.this.finishReport();
        }
    };

    public ExtentCucumberAdapter(String arg) {
        ExtentService.getInstance();
        Object prop = ExtentService.getProperty(SCREENSHOT_DIR_PROPERTY);
        this.screenshotDir = prop == null ? "test-output/" : String.valueOf(prop);
        prop = ExtentService.getProperty(SCREENSHOT_REL_PATH_PROPERTY);
        this.screenshotRelPath = prop == null || String.valueOf(prop).isEmpty() ? this.screenshotDir : String.valueOf(prop);
        this.screenshotRelPath = this.screenshotRelPath == null ? "" : this.screenshotRelPath;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventhandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventhandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.getUri(), event);
    }

    private synchronized void handleTestCaseStarted(TestCaseStarted event) {
        this.handleStartOfFeature(event.getTestCase());
        this.handleScenarioOutline(event.getTestCase());
        this.createTestCase(event.getTestCase());
    }

    private synchronized void handleTestStepStarted(TestStepStarted event) {
        isHookThreadLocal.set(false);
        if (event.getTestStep() instanceof HookTestStep) {
            ExtentTest t = scenarioThreadLocal.get().createNode(Asterisk.class, event.getTestStep().getCodeLocation());
            stepTestThreadLocal.set(t);
            isHookThreadLocal.set(true);
        }
        if (event.getTestStep() instanceof PickleStepTestStep) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.getTestStep();
            this.createTestStep(testStep);
        }
    }

    private synchronized void handleTestStepFinished(TestStepFinished event) {
        this.updateResult(event.getResult());
    }

    private synchronized void updateResult(Result result) {
        switch (result.getStatus().name().toLowerCase()) {
            case "failed": {
                stepTestThreadLocal.get().fail(result.getError());
                break;
            }
            case "undefined": {
                if (this.strict) {
                    stepTestThreadLocal.get().fail("Step undefined");
                    break;
                }
                stepTestThreadLocal.get().skip("Step undefined");
                break;
            }
            case "pending": 
            case "skipped": {
                if (isHookThreadLocal.get().booleanValue()) {
                    ExtentService.getInstance().removeTest(stepTestThreadLocal.get());
                    break;
                }
                Boolean currentEndingEventSkipped = stepTestThreadLocal.get().getModel().getLogContext() != null && !stepTestThreadLocal.get().getModel().getLogContext().isEmpty() ? ((Log)stepTestThreadLocal.get().getModel().getLogContext().getLast()).getStatus() == Status.SKIP : false;
                if (result.getError() != null) {
                    stepTestThreadLocal.get().skip(result.getError());
                    break;
                }
                if (currentEndingEventSkipped.booleanValue()) break;
                String details = result.getError() == null ? "Step skipped" : result.getError().getMessage();
                stepTestThreadLocal.get().skip(details);
                break;
            }
            case "passed": {
                if (stepTestThreadLocal.get() != null && stepTestThreadLocal.get().getModel().getLogContext().isEmpty() && !isHookThreadLocal.get().booleanValue()) {
                    stepTestThreadLocal.get().pass("");
                }
                if (stepTestThreadLocal.get() == null) break;
                Boolean hasLog = TestService.testHasLog((Test)stepTestThreadLocal.get().getModel());
                Boolean hasScreenCapture = hasLog != false && LogService.logHasScreenCapture((Log)((Log)stepTestThreadLocal.get().getModel().getLogContext().getFirst())) != false;
                if (!isHookThreadLocal.get().booleanValue() || hasLog.booleanValue() || hasScreenCapture.booleanValue()) break;
                ExtentService.getInstance().removeTest(stepTestThreadLocal.get());
                break;
            }
        }
    }

    private synchronized void handleEmbed(EmbedEvent event) {
        String mimeType = event.getMediaType();
        String extension = MIME_TYPES_EXTENSIONS.get(mimeType);
        if (extension != null) {
            StringBuilder fileName = new StringBuilder("embedded").append(EMBEDDED_INT.incrementAndGet()).append(".").append(extension);
            try {
                URL url = this.toUrl(fileName.toString());
                ExtentCucumberAdapter.writeBytesToURL(event.getData(), url);
                try {
                    File f = new File(url.toURI());
                    if (stepTestThreadLocal.get() == null) {
                        ExtentTest t = scenarioThreadLocal.get().createNode(Asterisk.class, "Embed");
                        stepTestThreadLocal.set(t);
                    }
                    stepTestThreadLocal.get().info("", MediaEntityBuilder.createScreenCaptureFromPath((String)(this.screenshotRelPath + f.getName())).build());
                    stepTestThreadLocal.get().addScreenCaptureFromPath(this.screenshotRelPath + f.getName());
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void writeBytesToURL(byte[] buf, URL url) throws IOException {
        OutputStream out = ExtentCucumberAdapter.createReportFileOutputStream(url);
        try {
            out.write(buf);
        }
        catch (IOException e) {
            throw new IOException("Unable to write to report file item: ", e);
        }
    }

    private static OutputStream createReportFileOutputStream(URL url) {
        try {
            return new URLOutputStream(url);
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private URL toUrl(String fileName) {
        try {
            URL url = Paths.get(this.screenshotDir, fileName).toUri().toURL();
            return url;
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private void handleWrite(WriteEvent event) {
        String text = event.getText();
        if (text != null && !text.isEmpty()) {
            stepTestThreadLocal.get().info(text);
        }
    }

    private void finishReport() {
        ExtentService.getInstance().flush();
    }

    private synchronized void handleStartOfFeature(TestCase testCase) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(testCase.getUri())) {
            this.currentFeatureFile.set(testCase.getUri());
            this.createFeature(testCase);
        }
    }

    private synchronized void createFeature(TestCase testCase) {
        io.cucumber.core.internal.gherkin.ast.Feature feature = this.testSources.getFeature(testCase.getUri());
        if (feature != null) {
            if (featureMap.containsKey(feature.getName())) {
                featureTestThreadLocal.set(featureMap.get(feature.getName()));
                return;
            }
            if (featureTestThreadLocal.get() != null && featureTestThreadLocal.get().getModel().getName().equals(feature.getName())) {
                return;
            }
            ExtentTest t = ExtentService.getInstance().createTest(Feature.class, feature.getName(), feature.getDescription());
            featureTestThreadLocal.set(t);
            featureMap.put(feature.getName(), t);
            List<String> tagList = this.createTagsList(feature.getTags());
            tagList.forEach(arg_0 -> ExtentCucumberAdapter.lambda$createFeature$0(featureTestThreadLocal.get(), arg_0));
        }
    }

    private List<String> createTagsList(List<Tag> tags) {
        ArrayList<String> tagList = new ArrayList<String>();
        for (Tag tag : tags) {
            tagList.add(tag.getName());
        }
        return tagList;
    }

    private synchronized void handleScenarioOutline(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile.get(), testCase.getLine());
        if (TestSourcesModel.isScenarioOutlineScenario(astNode)) {
            ScenarioOutline scenarioOutline = (ScenarioOutline)TestSourcesModel.getScenarioDefinition(astNode);
            if (this.currentScenarioOutline.get() == null || !this.currentScenarioOutline.get().getName().equals(scenarioOutline.getName())) {
                scenarioOutlineThreadLocal.set(null);
                this.createScenarioOutline(scenarioOutline);
                this.currentScenarioOutline.set(scenarioOutline);
            }
            Examples examples = (Examples)astNode.parent.node;
            if (this.currentExamples.get() == null || !this.currentExamples.get().equals(examples)) {
                this.currentExamples.set(examples);
                this.createExamples(examples);
            }
        } else {
            scenarioOutlineThreadLocal.set(null);
            this.currentScenarioOutline.set(null);
            this.currentExamples.set(null);
        }
    }

    private synchronized void createScenarioOutline(ScenarioOutline scenarioOutline) {
        if (scenarioOutlineMap.containsKey(scenarioOutline.getName())) {
            scenarioOutlineThreadLocal.set(scenarioOutlineMap.get(scenarioOutline.getName()));
            return;
        }
        if (scenarioOutlineThreadLocal.get() == null) {
            ExtentTest t = featureTestThreadLocal.get().createNode(com.aventstack.extentreports.gherkin.model.ScenarioOutline.class, scenarioOutline.getName(), scenarioOutline.getDescription());
            scenarioOutlineThreadLocal.set(t);
            scenarioOutlineMap.put(scenarioOutline.getName(), t);
            List featureTags = scenarioOutlineThreadLocal.get().getModel().getParent().getCategoryContext().getAll().stream().map(x -> x.getName()).collect(Collectors.toList());
            scenarioOutline.getTags().stream().map(x -> x.getName()).filter(x -> !featureTags.contains(x)).forEach(arg_0 -> ExtentCucumberAdapter.lambda$createScenarioOutline$4(scenarioOutlineThreadLocal.get(), arg_0));
        }
    }

    private synchronized void addOutlineStepsToReport(ScenarioOutline scenarioOutline) {
        for (Step step : scenarioOutline.getSteps()) {
            if (step.getArgument() == null) continue;
            Node argument = step.getArgument();
            if (argument instanceof DocString) {
                this.createDocStringMap((DocString)argument);
                continue;
            }
            if (!(argument instanceof DataTable)) continue;
        }
    }

    private Map<String, Object> createDocStringMap(DocString docString) {
        HashMap<String, Object> docStringMap = new HashMap<String, Object>();
        docStringMap.put("value", docString.getContent());
        return docStringMap;
    }

    private void createExamples(Examples examples) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        rows.add(examples.getTableHeader());
        rows.addAll(examples.getTableBody());
        String[][] data = this.getTable(rows);
        String markup = MarkupHelper.createTable((String[][])data).getMarkup();
        if (examples.getName() != null && !examples.getName().isEmpty()) {
            markup = examples.getName() + markup;
        }
        markup = scenarioOutlineThreadLocal.get().getModel().getDescription() + markup;
        scenarioOutlineThreadLocal.get().getModel().setDescription(markup);
    }

    private String[][] getTable(List<TableRow> rows) {
        String[][] data = null;
        int rowSize = rows.size();
        for (int i = 0; i < rowSize; ++i) {
            TableRow row = rows.get(i);
            List cells = row.getCells();
            int cellSize = cells.size();
            if (data == null) {
                data = new String[rowSize][cellSize];
            }
            for (int j = 0; j < cellSize; ++j) {
                data[i][j] = ((TableCell)cells.get(j)).getValue();
            }
        }
        return data;
    }

    private synchronized void createTestCase(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile.get(), testCase.getLine());
        if (astNode != null) {
            ScenarioDefinition scenarioDefinition = TestSourcesModel.getScenarioDefinition(astNode);
            ExtentTest parent = scenarioOutlineThreadLocal.get() != null ? scenarioOutlineThreadLocal.get() : featureTestThreadLocal.get();
            ExtentTest t = parent.createNode(Scenario.class, scenarioDefinition.getName(), scenarioDefinition.getDescription());
            scenarioThreadLocal.set(t);
        }
        if (!testCase.getTags().isEmpty()) {
            testCase.getTags().forEach(x -> scenarioThreadLocal.get().assignCategory(new String[]{x}));
        }
    }

    private synchronized void createTestStep(PickleStepTestStep testStep) {
        StepArgument argument;
        String stepName = testStep.getStep().getText();
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile.get(), testStep.getStep().getLine());
        if (astNode != null) {
            Step step = (Step)astNode.node;
            try {
                String name = stepName == null || stepName.isEmpty() ? step.getText().replace("<", "&lt;").replace(">", "&gt;") : stepName;
                ExtentTest t = scenarioThreadLocal.get().createNode(new GherkinKeyword(step.getKeyword().trim()), step.getKeyword() + name, testStep.getCodeLocation());
                stepTestThreadLocal.set(t);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if ((argument = testStep.getStep().getArgument()) != null) {
            if (argument instanceof DocStringArgument) {
                stepTestThreadLocal.get().pass(this.createDocString((DocStringArgument)argument));
            } else if (argument instanceof DataTableArgument) {
                stepTestThreadLocal.get().pass(MarkupHelper.createTable((String[][])this.createDataTableList((DataTableArgument)argument)).getMarkup());
            }
        }
    }

    private String[][] createDataTableList(DataTableArgument dataTable) {
        List cells = dataTable.cells();
        int rowSize = cells.size();
        int cellSize = ((List)cells.get(0)).size();
        String[][] data = new String[rowSize][cellSize];
        for (int i = 0; i < rowSize; ++i) {
            for (int j = 0; j < cellSize; ++j) {
                data[i][j] = (String)((List)cells.get(i)).get(j);
            }
        }
        return data;
    }

    private String createDocString(DocStringArgument docString) {
        return docString.getContent().replaceAll("(\r\n|\n)", "<br />");
    }

    public static synchronized void addTestStepLog(String message) {
        stepTestThreadLocal.get().info(message);
    }

    public static synchronized void addTestStepScreenCaptureFromPath(String imagePath) throws IOException {
        stepTestThreadLocal.get().addScreenCaptureFromPath(imagePath);
    }

    public static synchronized void addTestStepScreenCaptureFromPath(String imagePath, String title) throws IOException {
        stepTestThreadLocal.get().addScreenCaptureFromPath(imagePath, title);
    }

    public static ExtentTest getCurrentStep() {
        return stepTestThreadLocal.get();
    }

    private static /* synthetic */ void lambda$createScenarioOutline$4(ExtentTest rec$, String xva$0) {
        rec$.assignCategory(new String[]{xva$0});
    }

    private static /* synthetic */ void lambda$createFeature$0(ExtentTest rec$, String xva$0) {
        rec$.assignCategory(new String[]{xva$0});
    }
}

