/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure.paginate;

import tech.grasshopper.pdf.data.TagData;
import tech.grasshopper.pdf.section.tag.TagDisplay;
import tech.grasshopper.pdf.structure.paginate.PaginatedSection;
import tech.grasshopper.pdf.util.TextUtil;

public class TagPaginator {
    private TagData data;
    private PaginatedSection section;
    private int maxDataCountPerPage;

    public void paginate() {
        float currentHeight = TagDisplay.headerRowHeight();
        int fromIndex = 0;
        int toIndex = 0;
        TextUtil textUtil = TagDisplay.tagNameTextUtil();
        for (int i = 0; i < this.data.getTags().size(); ++i) {
            textUtil.setText(TagDisplay.tagNameTextOptimizer.optimizeTextLines(this.data.getTags().get(i).getName()));
            if ((currentHeight += textUtil.tableRowHeight()) > 470.0f || toIndex - fromIndex + 1 > this.maxDataCountPerPage) {
                this.section.generateDisplay(fromIndex, toIndex);
                fromIndex = toIndex;
                currentHeight = TagDisplay.headerRowHeight();
                --i;
                continue;
            }
            ++toIndex;
        }
        this.section.generateDisplay(fromIndex, toIndex);
    }

    TagPaginator(TagData data, PaginatedSection section, int maxDataCountPerPage) {
        this.data = data;
        this.section = section;
        this.maxDataCountPerPage = maxDataCountPerPage;
    }

    public static TagPaginatorBuilder builder() {
        return new TagPaginatorBuilder();
    }

    public static class TagPaginatorBuilder {
        private TagData data;
        private PaginatedSection section;
        private int maxDataCountPerPage;

        TagPaginatorBuilder() {
        }

        public TagPaginatorBuilder data(TagData data) {
            this.data = data;
            return this;
        }

        public TagPaginatorBuilder section(PaginatedSection section) {
            this.section = section;
            return this;
        }

        public TagPaginatorBuilder maxDataCountPerPage(int maxDataCountPerPage) {
            this.maxDataCountPerPage = maxDataCountPerPage;
            return this;
        }

        public TagPaginator build() {
            return new TagPaginator(this.data, this.section, this.maxDataCountPerPage);
        }

        public String toString() {
            return "TagPaginator.TagPaginatorBuilder(data=" + this.data + ", section=" + this.section + ", maxDataCountPerPage=" + this.maxDataCountPerPage + ")";
        }
    }
}

