/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure.paginate;

import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.section.scenario.ScenarioStepDetails;
import tech.grasshopper.pdf.structure.paginate.PaginatedSection;
import tech.grasshopper.pdf.util.TextUtil;

public class ScenarioPaginator {
    private ScenarioData data;
    private PaginatedSection section;
    private int maxScenariosPerPage;

    public void paginate() {
        float currentHeight = ScenarioStepDetails.headerRowHeight();
        int fromIndex = 0;
        int toIndex = 0;
        TextUtil textUtilFeature = ScenarioStepDetails.featureNameTextUtil();
        TextUtil textUtilScenario = ScenarioStepDetails.featureNameTextUtil();
        for (int i = 0; i < this.data.getScenarios().size(); ++i) {
            Scenario scenario = this.data.getScenarios().get(i);
            textUtilFeature.setText(ScenarioStepDetails.featureNameTextOptimizer.optimizeTextLines(scenario.getFeature().getName()));
            float featureHeight = textUtilFeature.tableRowHeight();
            textUtilScenario.setText(ScenarioStepDetails.scenarioNameTextOptimizer.optimizeTextLines(scenario.getName()));
            float scenarioHeight = textUtilScenario.tableRowHeight();
            float f = scenarioHeight > featureHeight ? scenarioHeight : featureHeight;
            if ((currentHeight += f) > 290.0f || toIndex - fromIndex + 1 > this.maxScenariosPerPage) {
                this.section.generateDisplay(fromIndex, toIndex);
                fromIndex = toIndex;
                currentHeight = ScenarioStepDetails.headerRowHeight();
                --i;
                continue;
            }
            ++toIndex;
        }
        this.section.generateDisplay(fromIndex, toIndex);
    }

    ScenarioPaginator(ScenarioData data, PaginatedSection section, int maxScenariosPerPage) {
        this.data = data;
        this.section = section;
        this.maxScenariosPerPage = maxScenariosPerPage;
    }

    public static ScenarioPaginatorBuilder builder() {
        return new ScenarioPaginatorBuilder();
    }

    public static class ScenarioPaginatorBuilder {
        private ScenarioData data;
        private PaginatedSection section;
        private int maxScenariosPerPage;

        ScenarioPaginatorBuilder() {
        }

        public ScenarioPaginatorBuilder data(ScenarioData data) {
            this.data = data;
            return this;
        }

        public ScenarioPaginatorBuilder section(PaginatedSection section) {
            this.section = section;
            return this;
        }

        public ScenarioPaginatorBuilder maxScenariosPerPage(int maxScenariosPerPage) {
            this.maxScenariosPerPage = maxScenariosPerPage;
            return this;
        }

        public ScenarioPaginator build() {
            return new ScenarioPaginator(this.data, this.section, this.maxScenariosPerPage);
        }

        public String toString() {
            return "ScenarioPaginator.ScenarioPaginatorBuilder(data=" + this.data + ", section=" + this.section + ", maxScenariosPerPage=" + this.maxScenariosPerPage + ")";
        }
    }
}

