/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details.executable.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.util.PdfUtil;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.pojo.cucumber.Row;

public class TableColumnOptimizer {
    private int fontsize;
    private boolean columnsCropped;
    private boolean cellTextCropped;
    private List<Float> maximumColumnTextWidths;
    private List<Row> rows;
    private static final float MAX_COLUMN_WIDTH = 100.0f;
    private static final float PADDING = 3.0f;
    private static final float INDICATOR_COLUMN_WIDTH = 4.0f;
    private static final float AVAILABLE_COLUMN_WIDTH = 572.0f;

    public List<Float> organizeColumnStructure() {
        this.maximumColumnTextWidths = this.maximumColumnWidths();
        ArrayList<Float> resizedColumnTextWidth = new ArrayList<Float>(this.maximumColumnTextWidths);
        this.resizeColumnWidth(resizedColumnTextWidth, false);
        return this.removeExtraColumns(resizedColumnTextWidth);
    }

    private List<Float> maximumColumnWidths() {
        Float[][] textWidths = new Float[this.rows.get(0).getCells().size()][this.rows.size()];
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = this.rows.get(i);
            for (int j = 0; j < row.getCells().size(); ++j) {
                textWidths[j][i] = Float.valueOf(PdfUtil.getStringWidth((String)row.getCells().get(j), (PDFont)ReportFont.REGULAR_FONT, (int)this.fontsize));
            }
        }
        ArrayList<Float> maxColWidths = new ArrayList<Float>();
        for (Float[] width : textWidths) {
            maxColWidths.add(Collections.max(Arrays.asList(width)));
        }
        return maxColWidths;
    }

    private void resizeColumnWidth(List<Float> columnMaxWidths, boolean removedColumn) {
        float availableWidth = 572.0f - (float)columnMaxWidths.size() * 6.0f;
        if (removedColumn) {
            availableWidth -= 10.0f;
        }
        if (((Float)columnMaxWidths.stream().reduce(Float::sum).get()).floatValue() > availableWidth && columnMaxWidths.stream().filter(w -> w.floatValue() > 100.0f).count() > 0L) {
            float widthToFitIn = availableWidth - columnMaxWidths.stream().filter(w -> w.floatValue() <= 100.0f).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
            float widthToAdjust = columnMaxWidths.stream().filter(w -> w.floatValue() > 100.0f).reduce(Float::sum).get().floatValue();
            float reductionFactor = widthToFitIn / widthToAdjust;
            for (int i = 0; i < columnMaxWidths.size(); ++i) {
                if (!(columnMaxWidths.get(i).floatValue() > 100.0f)) continue;
                float resizedWidth = columnMaxWidths.get(i).floatValue() * reductionFactor;
                resizedWidth = resizedWidth > 100.0f ? resizedWidth : 100.0f;
                columnMaxWidths.set(i, Float.valueOf(resizedWidth));
            }
        }
        if (((Float)columnMaxWidths.stream().reduce(Float::sum).get()).floatValue() > availableWidth && columnMaxWidths.stream().filter(w -> w.floatValue() > 100.0f).count() > 0L) {
            this.resizeColumnWidth(columnMaxWidths, false);
        }
    }

    private List<Float> removeExtraColumns(List<Float> resizedColumnWidths) {
        float colSize = ((Float)resizedColumnWidths.stream().reduce(Float::sum).get()).floatValue();
        ArrayList<Float> columnWidths = new ArrayList<Float>(resizedColumnWidths);
        float width = 0.0f;
        if (colSize > 572.0f - (float)resizedColumnWidths.size() * 6.0f) {
            for (int i = 0; i < resizedColumnWidths.size(); ++i) {
                if (!((width += resizedColumnWidths.get(i).floatValue()) > 572.0f - (float)(i + 1) * 6.0f)) continue;
                columnWidths = new ArrayList<Float>(this.maximumColumnTextWidths.subList(0, i));
                this.resizeColumnWidth(columnWidths, true);
                this.columnsCropped = true;
                break;
            }
        }
        return columnWidths;
    }

    TableColumnOptimizer(int fontsize, boolean columnsCropped, boolean cellTextCropped, List<Float> maximumColumnTextWidths, List<Row> rows) {
        this.fontsize = fontsize;
        this.columnsCropped = columnsCropped;
        this.cellTextCropped = cellTextCropped;
        this.maximumColumnTextWidths = maximumColumnTextWidths;
        this.rows = rows;
    }

    public static TableColumnOptimizerBuilder builder() {
        return new TableColumnOptimizerBuilder();
    }

    public void setFontsize(int fontsize) {
        this.fontsize = fontsize;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public static class TableColumnOptimizerBuilder {
        private int fontsize;
        private boolean columnsCropped;
        private boolean cellTextCropped;
        private List<Float> maximumColumnTextWidths;
        private List<Row> rows;

        TableColumnOptimizerBuilder() {
        }

        public TableColumnOptimizerBuilder fontsize(int fontsize) {
            this.fontsize = fontsize;
            return this;
        }

        public TableColumnOptimizerBuilder columnsCropped(boolean columnsCropped) {
            this.columnsCropped = columnsCropped;
            return this;
        }

        public TableColumnOptimizerBuilder cellTextCropped(boolean cellTextCropped) {
            this.cellTextCropped = cellTextCropped;
            return this;
        }

        public TableColumnOptimizerBuilder maximumColumnTextWidths(List<Float> maximumColumnTextWidths) {
            this.maximumColumnTextWidths = maximumColumnTextWidths;
            return this;
        }

        public TableColumnOptimizerBuilder rows(List<Row> rows) {
            this.rows = rows;
            return this;
        }

        public TableColumnOptimizer build() {
            return new TableColumnOptimizer(this.fontsize, this.columnsCropped, this.cellTextCropped, this.maximumColumnTextWidths, this.rows);
        }

        public String toString() {
            return "TableColumnOptimizer.TableColumnOptimizerBuilder(fontsize=" + this.fontsize + ", columnsCropped=" + this.columnsCropped + ", cellTextCropped=" + this.cellTextCropped + ", maximumColumnTextWidths=" + this.maximumColumnTextWidths + ", rows=" + this.rows + ")";
        }
    }
}

