/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.config;

import java.awt.Color;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.util.NumberUtil;

public class DashboardConfig {
    private String title = "Cucumber Report";
    private String titleColor;
    private String dateColor;
    private String timeColor;
    private DialConfig dial = new DialConfig();
    private String dataBackgroundColor;

    public Color dataBackgroundColor() {
        return ReportConfig.createColor(this.dataBackgroundColor, Color.DARK_GRAY);
    }

    public Color titleColor() {
        return ReportConfig.createColor(this.titleColor, Color.BLACK);
    }

    public Color dateColor() {
        return ReportConfig.createColor(this.dateColor, Color.BLUE);
    }

    public Color timeColor() {
        return ReportConfig.createColor(this.timeColor, Color.RED);
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleColor() {
        return this.titleColor;
    }

    public String getDateColor() {
        return this.dateColor;
    }

    public String getTimeColor() {
        return this.timeColor;
    }

    public DialConfig getDial() {
        return this.dial;
    }

    public String getDataBackgroundColor() {
        return this.dataBackgroundColor;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleColor(String titleColor) {
        this.titleColor = titleColor;
    }

    public void setDateColor(String dateColor) {
        this.dateColor = dateColor;
    }

    public void setTimeColor(String timeColor) {
        this.timeColor = timeColor;
    }

    public void setDial(DialConfig dial) {
        this.dial = dial;
    }

    public void setDataBackgroundColor(String dataBackgroundColor) {
        this.dataBackgroundColor = dataBackgroundColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardConfig)) {
            return false;
        }
        DashboardConfig other = (DashboardConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$titleColor = this.getTitleColor();
        String other$titleColor = other.getTitleColor();
        if (this$titleColor == null ? other$titleColor != null : !this$titleColor.equals(other$titleColor)) {
            return false;
        }
        String this$dateColor = this.getDateColor();
        String other$dateColor = other.getDateColor();
        if (this$dateColor == null ? other$dateColor != null : !this$dateColor.equals(other$dateColor)) {
            return false;
        }
        String this$timeColor = this.getTimeColor();
        String other$timeColor = other.getTimeColor();
        if (this$timeColor == null ? other$timeColor != null : !this$timeColor.equals(other$timeColor)) {
            return false;
        }
        DialConfig this$dial = this.getDial();
        DialConfig other$dial = other.getDial();
        if (this$dial == null ? other$dial != null : !((Object)this$dial).equals(other$dial)) {
            return false;
        }
        String this$dataBackgroundColor = this.getDataBackgroundColor();
        String other$dataBackgroundColor = other.getDataBackgroundColor();
        return !(this$dataBackgroundColor == null ? other$dataBackgroundColor != null : !this$dataBackgroundColor.equals(other$dataBackgroundColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DashboardConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $titleColor = this.getTitleColor();
        result = result * 59 + ($titleColor == null ? 43 : $titleColor.hashCode());
        String $dateColor = this.getDateColor();
        result = result * 59 + ($dateColor == null ? 43 : $dateColor.hashCode());
        String $timeColor = this.getTimeColor();
        result = result * 59 + ($timeColor == null ? 43 : $timeColor.hashCode());
        DialConfig $dial = this.getDial();
        result = result * 59 + ($dial == null ? 43 : ((Object)$dial).hashCode());
        String $dataBackgroundColor = this.getDataBackgroundColor();
        result = result * 59 + ($dataBackgroundColor == null ? 43 : $dataBackgroundColor.hashCode());
        return result;
    }

    public String toString() {
        return "DashboardConfig(title=" + this.getTitle() + ", titleColor=" + this.getTitleColor() + ", dateColor=" + this.getDateColor() + ", timeColor=" + this.getTimeColor() + ", dial=" + this.getDial() + ", dataBackgroundColor=" + this.getDataBackgroundColor() + ")";
    }

    public static class DialConfig {
        private String featureRanges = "0.60 0.85";
        private String scenarioRanges = "0.60 0.85";
        private String stepRanges = "0.60 0.85";
        private String badColor;
        private String averageColor;
        private String goodColor;

        public double[] featureRange() {
            return this.ranges(this.featureRanges);
        }

        public double[] scenarioRange() {
            return this.ranges(this.scenarioRanges);
        }

        public double[] stepRange() {
            return this.ranges(this.stepRanges);
        }

        private double[] ranges(String rangeStr) {
            try {
                String[] range = rangeStr.split(" ");
                return new double[]{NumberUtil.divideAndRound(Integer.parseInt(range[0]), 100), NumberUtil.divideAndRound(Integer.parseInt(range[1]), 100)};
            }
            catch (Exception e) {
                return new double[]{0.6, 0.85};
            }
        }

        public Color badColor() {
            return ReportConfig.createColor(this.badColor, Color.RED);
        }

        public Color averageColor() {
            return ReportConfig.createColor(this.averageColor, Color.ORANGE);
        }

        public Color goodColor() {
            return ReportConfig.createColor(this.goodColor, Color.GREEN);
        }

        public String getFeatureRanges() {
            return this.featureRanges;
        }

        public String getScenarioRanges() {
            return this.scenarioRanges;
        }

        public String getStepRanges() {
            return this.stepRanges;
        }

        public String getBadColor() {
            return this.badColor;
        }

        public String getAverageColor() {
            return this.averageColor;
        }

        public String getGoodColor() {
            return this.goodColor;
        }

        public void setFeatureRanges(String featureRanges) {
            this.featureRanges = featureRanges;
        }

        public void setScenarioRanges(String scenarioRanges) {
            this.scenarioRanges = scenarioRanges;
        }

        public void setStepRanges(String stepRanges) {
            this.stepRanges = stepRanges;
        }

        public void setBadColor(String badColor) {
            this.badColor = badColor;
        }

        public void setAverageColor(String averageColor) {
            this.averageColor = averageColor;
        }

        public void setGoodColor(String goodColor) {
            this.goodColor = goodColor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DialConfig)) {
                return false;
            }
            DialConfig other = (DialConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$featureRanges = this.getFeatureRanges();
            String other$featureRanges = other.getFeatureRanges();
            if (this$featureRanges == null ? other$featureRanges != null : !this$featureRanges.equals(other$featureRanges)) {
                return false;
            }
            String this$scenarioRanges = this.getScenarioRanges();
            String other$scenarioRanges = other.getScenarioRanges();
            if (this$scenarioRanges == null ? other$scenarioRanges != null : !this$scenarioRanges.equals(other$scenarioRanges)) {
                return false;
            }
            String this$stepRanges = this.getStepRanges();
            String other$stepRanges = other.getStepRanges();
            if (this$stepRanges == null ? other$stepRanges != null : !this$stepRanges.equals(other$stepRanges)) {
                return false;
            }
            String this$badColor = this.getBadColor();
            String other$badColor = other.getBadColor();
            if (this$badColor == null ? other$badColor != null : !this$badColor.equals(other$badColor)) {
                return false;
            }
            String this$averageColor = this.getAverageColor();
            String other$averageColor = other.getAverageColor();
            if (this$averageColor == null ? other$averageColor != null : !this$averageColor.equals(other$averageColor)) {
                return false;
            }
            String this$goodColor = this.getGoodColor();
            String other$goodColor = other.getGoodColor();
            return !(this$goodColor == null ? other$goodColor != null : !this$goodColor.equals(other$goodColor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DialConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $featureRanges = this.getFeatureRanges();
            result = result * 59 + ($featureRanges == null ? 43 : $featureRanges.hashCode());
            String $scenarioRanges = this.getScenarioRanges();
            result = result * 59 + ($scenarioRanges == null ? 43 : $scenarioRanges.hashCode());
            String $stepRanges = this.getStepRanges();
            result = result * 59 + ($stepRanges == null ? 43 : $stepRanges.hashCode());
            String $badColor = this.getBadColor();
            result = result * 59 + ($badColor == null ? 43 : $badColor.hashCode());
            String $averageColor = this.getAverageColor();
            result = result * 59 + ($averageColor == null ? 43 : $averageColor.hashCode());
            String $goodColor = this.getGoodColor();
            result = result * 59 + ($goodColor == null ? 43 : $goodColor.hashCode());
            return result;
        }

        public String toString() {
            return "DashboardConfig.DialConfig(featureRanges=" + this.getFeatureRanges() + ", scenarioRanges=" + this.getScenarioRanges() + ", stepRanges=" + this.getStepRanges() + ", badColor=" + this.getBadColor() + ", averageColor=" + this.getAverageColor() + ", goodColor=" + this.getGoodColor() + ")";
        }
    }
}

