/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details.executable;

import java.awt.Color;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Step;
import tech.grasshopper.pdf.section.details.DetailedStepHookDisplay;

public class DocStringDisplay {
    private Step step;
    private Color textColor;
    private Color backgroundColor;
    private final int fontsize = 9;

    public AbstractCell display() {
        ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder = ParagraphCell.Paragraph.builder();
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        String sanitizedText = sanitizer.sanitizeText(this.step.getDocString());
        String message = sanitizer.getStripMessage();
        paragraphBuilder.append(StyledText.builder().text(sanitizedText).font(DetailedStepHookDisplay.STEP_HOOK_TEXT_FONT).fontSize(Float.valueOf(9.0f)).color(this.textColor).build());
        if (!message.isEmpty()) {
            paragraphBuilder.appendNewLine().append(StyledText.builder().text(message).font(DetailedStepHookDisplay.STEP_HOOK_TEXT_FONT).fontSize(Float.valueOf(9.0f)).color(this.textColor).build());
        }
        return ((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)ParagraphCell.builder().paragraph(paragraphBuilder.build()).lineSpacing(1.2f).borderColor(Color.GRAY)).borderWidth(1.0f)).backgroundColor(this.backgroundColor)).build();
    }

    DocStringDisplay(Step step, Color textColor, Color backgroundColor) {
        this.step = step;
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
    }

    public static DocStringDisplayBuilder builder() {
        return new DocStringDisplayBuilder();
    }

    public void setStep(Step step) {
        this.step = step;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public static class DocStringDisplayBuilder {
        private Step step;
        private Color textColor;
        private Color backgroundColor;

        DocStringDisplayBuilder() {
        }

        public DocStringDisplayBuilder step(Step step) {
            this.step = step;
            return this;
        }

        public DocStringDisplayBuilder textColor(Color textColor) {
            this.textColor = textColor;
            return this;
        }

        public DocStringDisplayBuilder backgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public DocStringDisplay build() {
            return new DocStringDisplay(this.step, this.textColor, this.backgroundColor);
        }

        public String toString() {
            return "DocStringDisplay.DocStringDisplayBuilder(step=" + this.step + ", textColor=" + this.textColor + ", backgroundColor=" + this.backgroundColor + ")";
        }
    }
}

