/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.artifact.ByteFile;
import tech.deplant.java4ever.framework.artifact.ByteResource;
import tech.deplant.java4ever.framework.datatype.TvmCell;

public record Tvc(byte[] bytes) {
    public static Tvc ofFile(String filePath) {
        return new Tvc(new ByteFile(filePath).get());
    }

    public static Tvc ofResource(String resourceName) {
        return new Tvc(new ByteResource(resourceName).get());
    }

    public static Tvc ofBase64String(String base64) {
        return new Tvc(Base64.getDecoder().decode(base64));
    }

    public String base64String() {
        return Base64.getEncoder().encodeToString(this.bytes());
    }

    public JsonNode decodeInitialData(int sdk, ContractAbi abi) throws EverSdkException {
        return ((Abi.ResultOfDecodeInitialData)EverSdk.await((CompletableFuture)Abi.decodeInitialData((int)sdk, (Abi.ABI)abi.ABI(), (String)this.decode(sdk).data(), (Boolean)false))).initialData();
    }

    public String encodeInitialData(int sdk, ContractAbi abi, Map<String, Object> initData, String pubkey) throws EverSdkException {
        return ((Abi.ResultOfEncodeInitialData)EverSdk.await((CompletableFuture)Abi.encodeInitialData((int)sdk, (Abi.ABI)abi.ABI(), (JsonNode)JsonContext.ABI_JSON_MAPPER().valueToTree(initData), (String)pubkey, null))).data();
    }

    public String decodeInitialPubkey(int sdk, ContractAbi abi) throws EverSdkException {
        return ((Abi.ResultOfDecodeInitialData)EverSdk.await((CompletableFuture)Abi.decodeInitialData((int)sdk, (Abi.ABI)abi.ABI(), (String)this.decode(sdk).data(), (Boolean)false))).initialPubkey();
    }

    public String code(int sdk) throws EverSdkException {
        return this.decode(sdk).code();
    }

    public TvmCell codeCell(int sdk) throws EverSdkException {
        return new TvmCell(this.decode(sdk).code());
    }

    public Boc.ResultOfDecodeStateInit decode(int sdk) throws EverSdkException {
        return (Boc.ResultOfDecodeStateInit)EverSdk.await((CompletableFuture)Boc.decodeStateInit((int)sdk, (String)this.base64String(), null));
    }

    public String data(int sdk) throws EverSdkException {
        return this.decode(sdk).data();
    }

    public String saltedCode(int sdk, String salt) throws EverSdkException {
        return ((Boc.ResultOfSetCodeSalt)EverSdk.await((CompletableFuture)Boc.setCodeSalt((int)sdk, (String)this.code(sdk), (String)salt, null))).code();
    }

    public String codeHash(int sdk) throws EverSdkException {
        return ((Boc.ResultOfGetBocHash)EverSdk.await((CompletableFuture)Boc.getBocHash((int)sdk, (String)this.code(sdk)))).hash();
    }

    public Number codeDepth(int sdk) throws EverSdkException {
        return ((Boc.ResultOfGetBocDepth)EverSdk.await((CompletableFuture)Boc.getBocDepth((int)sdk, (String)this.code(sdk)))).depth();
    }

    public String saltedCodeHash(int sdk, String salt) throws EverSdkException {
        return ((Boc.ResultOfGetBocHash)EverSdk.await((CompletableFuture)Boc.getBocHash((int)sdk, (String)this.saltedCode(sdk, salt)))).hash();
    }

    public Tvc withUpdatedInitialData(int sdk, ContractAbi abi, Map<String, Object> initialData, String publicKey) throws EverSdkException {
        String updatedDataString = ((Abi.ResultOfUpdateInitialData)EverSdk.await((CompletableFuture)Abi.updateInitialData((int)sdk, (Abi.ABI)abi.ABI(), (String)this.data(sdk), (JsonNode)JsonContext.ABI_JSON_MAPPER().valueToTree(abi.convertInitDataInputs(initialData)), (String)publicKey, null))).data();
        Boc.ResultOfDecodeStateInit decoded = this.decode(sdk);
        String newTvcString = ((Boc.ResultOfEncodeStateInit)EverSdk.await((CompletableFuture)Boc.encodeStateInit((int)sdk, (String)decoded.code(), (String)updatedDataString, (String)decoded.library(), (Boolean)decoded.tick(), (Boolean)decoded.tock(), (Long)decoded.splitDepth(), null))).stateInit();
        return Tvc.ofBase64String(newTvcString);
    }

    public Builder toBuilder(int sdk) throws EverSdkException {
        Boc.ResultOfDecodeStateInit decoded = this.decode(sdk);
        return new Builder(decoded.code(), decoded.data(), decoded.library(), decoded.tick(), decoded.tock(), decoded.splitDepth(), decoded.compilerVersion());
    }

    public static class Builder {
        private String code;
        private String data;
        private String library;
        private Boolean tick;
        private Boolean tock;
        private Long splitDepth;
        private String compilerVersion;

        public Builder() {
        }

        private Builder(String code, String data, String library, Boolean tick, Boolean tock, Long splitDepth, String compilerVersion) {
            this.code = code;
            this.data = data;
            this.library = library;
            this.tick = tick;
            this.tock = tock;
            this.splitDepth = splitDepth;
            this.compilerVersion = compilerVersion;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        private Builder data(String data) {
            this.data = data;
            return this;
        }

        private Builder library(String library) {
            this.library = library;
            return this;
        }

        private Builder tick(boolean tick) {
            this.tick = tick;
            return this;
        }

        private Builder tock(boolean tock) {
            this.tock = tock;
            return this;
        }

        private Builder splitDepth(Long splitDepth) {
            this.splitDepth = splitDepth;
            return this;
        }

        private Builder compilerVersion(String compilerVersion) {
            this.compilerVersion = compilerVersion;
            return this;
        }

        public Tvc build(int sdk) throws EverSdkException {
            return Tvc.ofBase64String(((Boc.ResultOfEncodeStateInit)EverSdk.await((CompletableFuture)Boc.encodeStateInit((int)sdk, (String)this.code, (String)this.data, (String)this.library, (Boolean)this.tick, (Boolean)this.tock, (Long)this.splitDepth, null))).stateInit());
        }
    }
}

