/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.datatype;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import tech.deplant.commons.regex.AnyOf;
import tech.deplant.commons.regex.GroupOf;
import tech.deplant.commons.regex.Occurences;
import tech.deplant.commons.regex.RegExpBuilder;
import tech.deplant.commons.regex.Special;
import tech.deplant.commons.regex.Symbol;
import tech.deplant.commons.regex.Then;
import tech.deplant.commons.regex.Word;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.datatype.AbiType;
import tech.deplant.java4ever.framework.datatype.AbiTypePrefix;
import tech.deplant.java4ever.framework.datatype.AbiValue;

public record SolStruct(Abi.AbiParam[] abiParams, Map<String, Object> values) implements AbiValue<Map<String, Object>>
{
    private static final System.Logger logger = System.getLogger(SolStruct.class.getName());

    public static boolean hasParam(Abi.AbiParam[] params, String paramName) {
        return Arrays.stream(params).anyMatch(param -> paramName.equals(param.name()));
    }

    public static Abi.AbiParam getParam(Abi.AbiParam[] params, String paramName) {
        return Arrays.stream(params).filter(param -> paramName.equals(param.name())).findFirst().orElseThrow();
    }

    public static SolStruct fromJava(Abi.AbiParam[] params, Map<String, Object> inputs) {
        if (inputs != null) {
            HashMap<String, Object> converted = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : inputs.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (SolStruct.hasParam(params, key)) {
                    Abi.AbiParam abiParam = SolStruct.getParam(params, key);
                    try {
                        converted.put(key, SolStruct.serializeInputTree(abiParam, value));
                    }
                    catch (EverSdkException e) {
                        converted.put(key, value);
                    }
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, () -> "ABI params spec doesn't contain key '" + key + "'");
            }
            return new SolStruct(params, converted);
        }
        return null;
    }

    public static SolStruct fromABI(Abi.AbiParam[] params, Map<String, Object> outputs) {
        if (outputs != null) {
            HashMap<String, Object> converted = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : outputs.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (SolStruct.hasParam(params, key)) {
                    Abi.AbiParam abiParam = SolStruct.getParam(params, key);
                    try {
                        converted.put(key, SolStruct.serializeOutputTree(abiParam, value));
                    }
                    catch (EverSdkException e) {
                        converted.put(key, value);
                    }
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, () -> "ABI params spec doesn't contain key '" + key + "'");
            }
            return new SolStruct(params, converted);
        }
        return null;
    }

    public static boolean arrayMatcher(String typeString) {
        Pattern arrayPattern = new Then(new RegExpBuilder[]{new GroupOf((RegExpBuilder)new Then(new RegExpBuilder[]{new Occurences((RegExpBuilder)new AnyOf(new Word((CharSequence)"a-zA-Z")), Integer.valueOf(1)), new Occurences((RegExpBuilder)Special.DIGIT, Integer.valueOf(0), Integer.valueOf(3))})), new GroupOf((RegExpBuilder)new Then(new RegExpBuilder[]{new Symbol('['), new Symbol(']')}))}).toPattern();
        Matcher matcher = arrayPattern.matcher(typeString);
        return matcher.find();
    }

    public static Object serializeInputTree(Abi.AbiParam param, Object inputValue) throws EverSdkException {
        String typeStringPattern = "([a-zA-Z]+\\d{0,3}\\[?\\]?)";
        Pattern mapPattern = Pattern.compile("(map\\()" + typeStringPattern + "(,)" + typeStringPattern + "(\\))");
        boolean rootIsMap = false;
        String rootTypeString = param.type();
        String keyTypeString = null;
        String valueTypeString = null;
        Matcher matcher = mapPattern.matcher(rootTypeString);
        while (matcher.find()) {
            rootIsMap = true;
            keyTypeString = matcher.group(2);
            valueTypeString = matcher.group(4);
        }
        if (rootIsMap) {
            AbiType keyDetails = AbiType.of(keyTypeString);
            Map inputMap = (Map)inputValue;
            HashMap<Object, Object> convertedMap = new HashMap<Object, Object>();
            for (Map.Entry entry : inputMap.entrySet()) {
                convertedMap.put(AbiValue.of(keyDetails, entry.getKey()).toABI(), SolStruct.serializeInputTree(new Abi.AbiParam(valueTypeString, valueTypeString, param.components(), null), entry.getValue()));
            }
            return convertedMap;
        }
        AbiType rootDetails = AbiType.of(rootTypeString);
        if (rootDetails.prefix().equals((Object)AbiTypePrefix.TUPLE)) {
            Map mapValue = (Map)inputValue;
            return Arrays.stream(param.components()).collect(Collectors.toMap(component -> component.name(), component -> {
                try {
                    return SolStruct.serializeInputTree(component, mapValue.get(component.name()));
                }
                catch (EverSdkException e) {
                    return mapValue.get(component.name());
                }
            }));
        }
        if (rootDetails.isArray()) {
            Object[] objectArray;
            Object object = inputValue;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Object[].class, List.class}, (Object)object2, n)) {
                case 0: {
                    String s = (String)object2;
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = AbiValue.of(rootDetails, s).toABI();
                    break;
                }
                case 1: {
                    Object[] arr = (Object[])object2;
                    objectArray = Arrays.stream(arr).map(element -> {
                        try {
                            return AbiValue.of(rootDetails, element).toABI();
                        }
                        catch (EverSdkException e) {
                            return element;
                        }
                    }).toArray();
                    break;
                }
                case 2: {
                    List list = (List)object2;
                    objectArray = list.stream().map(element -> {
                        try {
                            return AbiValue.of(rootDetails, element).toABI();
                        }
                        catch (EverSdkException e) {
                            return element;
                        }
                    }).toArray();
                    break;
                }
                default: {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = AbiValue.of(rootDetails, inputValue).toABI();
                }
            }
            return objectArray;
        }
        return AbiValue.of(rootDetails, inputValue).toABI();
    }

    public static Object serializeOutputTree(Abi.AbiParam param, Object outputValue) throws EverSdkException {
        String typeStringPattern = "([a-zA-Z]+\\d{0,3}\\[?\\]?)";
        Pattern mapPattern = Pattern.compile("(map\\()" + typeStringPattern + "(,)" + typeStringPattern + "(\\))");
        boolean rootIsMap = false;
        String rootTypeString = param.type();
        String keyTypeString = null;
        String valueTypeString = null;
        logger.log(System.Logger.Level.TRACE, () -> "param: " + param.name() + " ( " + param.type() + " -> " + rootTypeString + " ): " + String.valueOf(outputValue));
        Matcher matcher = mapPattern.matcher(rootTypeString);
        while (matcher.find()) {
            rootIsMap = true;
            keyTypeString = matcher.group(2);
            valueTypeString = matcher.group(4);
        }
        if (rootIsMap) {
            AbiType keyDetails = AbiType.of(keyTypeString);
            Map outputMap = (Map)outputValue;
            HashMap convertedMap = new HashMap();
            for (Map.Entry entry : outputMap.entrySet()) {
                convertedMap.put(AbiValue.of(keyDetails, entry.getKey()).toJava(), SolStruct.serializeOutputTree(new Abi.AbiParam(valueTypeString, valueTypeString, param.components(), null), entry.getValue()));
            }
            return convertedMap;
        }
        AbiType rootDetails = AbiType.of(rootTypeString);
        if (rootDetails.prefix().equals((Object)AbiTypePrefix.TUPLE)) {
            Map mapValue = (Map)outputValue;
            return Arrays.stream(param.components()).collect(Collectors.toMap(component -> component.name(), component -> {
                try {
                    return SolStruct.serializeOutputTree(component, mapValue.get(component.name()));
                }
                catch (EverSdkException e) {
                    return mapValue.get(component.name());
                }
            }));
        }
        if (rootDetails.isArray()) {
            Object[] objectArray;
            Object object = outputValue;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Object[].class, List.class}, (Object)object2, n)) {
                case 0: {
                    String s = (String)object2;
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = AbiValue.of(rootDetails, s);
                    break;
                }
                case 1: {
                    Object[] arr = (Object[])object2;
                    objectArray = Arrays.stream(arr).map(element -> {
                        try {
                            return AbiValue.of(rootDetails, element).toJava();
                        }
                        catch (EverSdkException e) {
                            return element;
                        }
                    }).toArray();
                    break;
                }
                case 2: {
                    List list = (List)object2;
                    objectArray = list.stream().map(element -> {
                        try {
                            return AbiValue.of(rootDetails, element).toJava();
                        }
                        catch (EverSdkException e) {
                            return element;
                        }
                    }).toArray();
                    break;
                }
                default: {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = AbiValue.of(rootDetails, outputValue).toJava();
                }
            }
            return objectArray;
        }
        return AbiValue.of(rootDetails, outputValue).toJava();
    }

    @Override
    public Map<String, Object> toJava() {
        return this.values();
    }

    @Override
    public Map<String, Object> toABI() {
        return this.values();
    }

    @Override
    public AbiType type() {
        return null;
    }
}

