/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.datatype;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.datatype.AbiType;
import tech.deplant.java4ever.framework.template.Template;
import tech.deplant.java4ever.utils.Strings;

public record Address(int wid, BigInteger value) implements AbiType<String, String>
{
    public static final Address ZERO = new Address(0, BigInteger.ZERO);

    @JsonCreator
    public Address(String address) {
        this(Integer.parseInt(address.split(":")[0]), new BigInteger(address.split(":")[1], 16));
    }

    public Address(BigInteger value) {
        this(0, value);
    }

    public static Address fromJava(Object input) {
        Object object = input;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Address.class, String.class, BigInteger.class}, (Object)object2, n)) {
            case 0 -> {
                Address a;
                yield a = (Address)object2;
            }
            case 1 -> {
                String s = (String)object2;
                yield new Address(s);
            }
            case 2 -> {
                BigInteger bi = (BigInteger)object2;
                yield new Address(0, bi);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(input) + " class: " + input.getClass().getName());
        };
    }

    public static Address fromABI(Object output) {
        return new Address(output.toString());
    }

    public static Address ofNullable(Object nullableObject) {
        return null == nullableObject ? ZERO : new Address(nullableObject.toString());
    }

    public static String ofFutureDeploy(Sdk sdk, Template template, int workchainId, Map<String, Object> initialData, Credentials credentials) throws EverSdkException {
        return Abi.encodeMessage((EverSdkContext)sdk.context(), (Abi.ABI)template.abi().ABI(), null, (Abi.DeploySet)new Abi.DeploySet(template.tvc().base64String(), null, null, Integer.valueOf(workchainId), initialData, Objects.requireNonNullElse(credentials, Credentials.NONE).publicKey()), null, (Abi.Signer)Objects.requireNonNullElse(credentials, Credentials.NONE).signer(), null, null).address();
    }

    public boolean isNull() {
        return this.value.equals(BigInteger.ZERO);
    }

    public int getType() {
        return 0;
    }

    public String makeAddrStd() {
        return this.wid() + ":" + Strings.padLeftZeros((String)this.value().toString(16), (int)64);
    }

    @Override
    public Abi.AbiParam toAbiParam(String name) {
        return new Abi.AbiParam(name, this.abiTypeName(), null);
    }

    @Override
    public String abiTypeName() {
        return "address";
    }

    @Override
    public String toJava() {
        return this.makeAddrStd();
    }

    @Override
    public String toABI() {
        return this.makeAddrStd();
    }
}

