/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract.multisig;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.contract.Giver;
import tech.deplant.java4ever.framework.contract.multisig.MultisigWallet;
import tech.deplant.java4ever.framework.template.SafeMultisigWalletTemplate;
import tech.deplant.java4ever.framework.template.SetcodeMultisigWalletTemplate;
import tech.deplant.java4ever.framework.template.SurfMultisigWalletTemplate;

public class MultisigBuilder {
    private MultisigWallet.Type type = MultisigWallet.Type.SURF;
    private int confirmations = 1;
    private final Set<BigInteger> publicKeys = new HashSet<BigInteger>();
    private Credentials deployKeys;

    public MultisigWallet build(Sdk sdk, Credentials deployKeys, Giver giver, BigInteger value) throws JsonProcessingException, EverSdkException {
        BigInteger[] owners = null;
        owners = this.publicKeys.size() == 0 ? new BigInteger[]{deployKeys.publicBigInt()} : (BigInteger[])this.publicKeys.toArray(BigInteger[]::new);
        return switch (this.type) {
            default -> throw new MatchException(null, null);
            case MultisigWallet.Type.SURF -> new SurfMultisigWalletTemplate().prepareDeploy(sdk, deployKeys, owners, this.confirmations).deployWithGiver(giver, value);
            case MultisigWallet.Type.SAFE -> new SafeMultisigWalletTemplate().prepareDeploy(sdk, deployKeys, owners, this.confirmations).deployWithGiver(giver, value);
            case MultisigWallet.Type.SETCODE -> new SetcodeMultisigWalletTemplate().prepareDeploy(sdk, deployKeys, owners, this.confirmations).deployWithGiver(giver, value);
        };
    }

    public Credentials deployKeys() {
        return this.deployKeys;
    }

    public MultisigBuilder setDeployKeys(Credentials deployKeys) {
        this.deployKeys = deployKeys;
        return this;
    }

    public MultisigBuilder addOwner(BigInteger pubkey) {
        this.publicKeys.add(pubkey);
        return this;
    }

    public MultisigBuilder removeOwner(BigInteger pubkey) {
        this.publicKeys.remove(pubkey);
        return this;
    }

    public MultisigWallet.Type type() {
        return this.type;
    }

    public MultisigBuilder setType(MultisigWallet.Type type) {
        this.type = type;
        return this;
    }

    public int confirmations() {
        return this.confirmations;
    }

    public MultisigBuilder setConfirmations(int confirmations) {
        this.confirmations = confirmations;
        return this;
    }
}

