/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Account;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.FunctionHandle;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.datatype.Uint;

public interface Contract {
    public static <IMPL> IMPL instantiate(Class<IMPL> clazz, Sdk sdk, String address, ContractAbi abi, Credentials credentials) {
        List<Class> componentTypes = Stream.of(clazz.getRecordComponents()).map(RecordComponent::getType).toList();
        for (Constructor<?> c : clazz.getDeclaredConstructors()) {
            if (!Arrays.asList(c.getParameterTypes()).equals(componentTypes)) continue;
            try {
                return (IMPL)c.newInstance(sdk, address, abi, credentials);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    default public BigInteger accountBalance() throws EverSdkException {
        return Uint.fromJava(128, this.account().balance()).toJava();
    }

    default public Account account() throws EverSdkException {
        return Account.ofAddress(this.sdk(), this.address());
    }

    public Sdk sdk();

    public String address();

    public ContractAbi abi();

    public Credentials credentials();

    default public String tvmPubkey() throws EverSdkException {
        return this.account().tvmPubkey(this.sdk(), this.abi());
    }

    default public FunctionHandle<Map<String, Object>> prepareCall(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) {
        return new FunctionHandle<Map<String, Object>>(this.sdk(), this.address(), this.abi(), this.credentials(), functionName, functionInputs, functionHeader);
    }

    default public Abi.DecodedMessageBody decodeMessageBoc(TvmCell messageBoc) throws EverSdkException {
        return Abi.decodeMessage((Context)this.sdk().context(), (Abi.ABI)this.abi().ABI(), (String)messageBoc.cellBoc(), (Boolean)false, null, null);
    }
}

