/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.generator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.ContextBuilder;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.generator.ParserUtils;
import tech.deplant.java4ever.binding.generator.javapoet.ArrayTypeName;
import tech.deplant.java4ever.binding.generator.javapoet.ClassName;
import tech.deplant.java4ever.binding.generator.javapoet.CodeBlock;
import tech.deplant.java4ever.binding.generator.javapoet.JavaFile;
import tech.deplant.java4ever.binding.generator.javapoet.MethodSpec;
import tech.deplant.java4ever.binding.generator.javapoet.ParameterSpec;
import tech.deplant.java4ever.binding.generator.javapoet.ParameterizedTypeName;
import tech.deplant.java4ever.binding.generator.javapoet.TypeName;
import tech.deplant.java4ever.binding.generator.javapoet.TypeSpec;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.DeployHandle;
import tech.deplant.java4ever.framework.FunctionHandle;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.Tvc;
import tech.deplant.java4ever.framework.contract.Contract;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.TvmBuilder;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.template.Template;
import tech.deplant.java4ever.utils.Objs;
import tech.deplant.java4ever.utils.Strings;

public class ContractWrapper {
    private static System.Logger logger = System.getLogger(ContractWrapper.class.getName());

    private static TypeName typeSwitch(String abiTypeString) throws EverSdkException {
        ClassName resultTypeName;
        ContractAbi.AbiTypeDetails details = ContractAbi.typeParser(abiTypeString);
        switch (details.type()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INT: 
            case UINT: {
                ClassName className;
                if (details.size() <= 32) {
                    className = ClassName.get(Integer.class);
                    break;
                }
                if (details.size() <= 64) {
                    className = ClassName.get(Long.class);
                    break;
                }
                className = ClassName.get(BigInteger.class);
                break;
            }
            case STRING: 
            case BYTE: 
            case BYTES: {
                ClassName className = TypeName.STRING;
                break;
            }
            case ADDRESS: {
                ClassName className = ClassName.get(Address.class);
                break;
            }
            case BOOL: {
                ClassName className = ClassName.get(Boolean.class);
                break;
            }
            case CELL: {
                ClassName className = ClassName.get(TvmCell.class);
                break;
            }
            case SLICE: {
                ClassName className = TypeName.STRING;
                break;
            }
            case BUILDER: {
                ClassName className = ClassName.get(TvmBuilder.class);
                break;
            }
            case TUPLE: {
                ClassName className = resultTypeName = ParameterizedTypeName.get((ClassName)TypeName.MAP, (TypeName[])new TypeName[]{TypeName.STRING, TypeName.OBJECT});
            }
        }
        if (details.isArray()) {
            resultTypeName = ArrayTypeName.of((TypeName)resultTypeName);
        }
        return resultTypeName;
    }

    private static TypeName toTypeName(String abiTypeString) throws EverSdkException {
        String typeStringPattern = "([a-zA-Z]+\\d{0,3}\\[?\\]?)";
        Pattern mapPattern = Pattern.compile("(map\\()" + typeStringPattern + "(,)" + typeStringPattern + "(\\))");
        boolean rootIsMap = false;
        String rootTypeString = abiTypeString;
        String keyTypeString = null;
        String valueTypeString = null;
        Matcher matcher = mapPattern.matcher(rootTypeString);
        while (matcher.find()) {
            rootIsMap = true;
            keyTypeString = matcher.group(2);
            valueTypeString = matcher.group(4);
        }
        if (rootIsMap) {
            TypeName keyName = ContractWrapper.typeSwitch(keyTypeString);
            TypeName valueName = ContractWrapper.typeSwitch(valueTypeString);
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyName, valueName});
        }
        TypeName typeName = ContractWrapper.typeSwitch(abiTypeString);
        return typeName;
    }

    public static void generate(Abi.AbiContract abi, Tvc tvc, Path targetDirectory, String contractName, String wrapperPackage, String templatePackage, String[] superInterfaces) throws IOException, EverSdkException {
        boolean hasTvc = Objs.isNotNull((Object)tvc);
        String wrapperName = ParserUtils.capitalize((String)contractName);
        CodeBlock.Builder wrapperDocs = CodeBlock.builder().add(String.format("Java wrapper class for usage of <strong>%s</strong> contract for Everscale blockchain.\n", wrapperName), new Object[0]);
        CodeBlock.Builder templateDocs = CodeBlock.builder().add(String.format("Java template class for deploy of <strong>%s</strong> contract for Everscale blockchain.\n", wrapperName), new Object[0]);
        TypeSpec.Builder wrapperBuilder = TypeSpec.recordBuilder((String)wrapperName).addJavadoc(wrapperDocs.build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (Objs.isNull((Object)superInterfaces) || superInterfaces.length == 0) {
            wrapperBuilder.addSuperinterface(Contract.class);
        } else {
            for (String s : superInterfaces) {
                wrapperBuilder.addSuperinterface((TypeName)ClassName.bestGuess((String)s));
            }
        }
        wrapperBuilder.addRecordComponent(Sdk.class, "sdk");
        wrapperBuilder.addRecordComponent(String.class, "address");
        wrapperBuilder.addRecordComponent(ContractAbi.class, "abi");
        wrapperBuilder.addRecordComponent(Credentials.class, "credentials");
        wrapperBuilder.addMethod(MethodSpec.constructorBuilder().addStatement("this(sdk,address,DEFAULT_ABI(),Credentials.NONE)", new Object[0]).addParameter(Sdk.class, "sdk", new Modifier[0]).addParameter(String.class, "address", new Modifier[0]).addException(JsonProcessingException.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        wrapperBuilder.addMethod(MethodSpec.constructorBuilder().addStatement("this(sdk,address,abi,Credentials.NONE)", new Object[0]).addParameter(Sdk.class, "sdk", new Modifier[0]).addParameter(String.class, "address", new Modifier[0]).addParameter(ContractAbi.class, "abi", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        wrapperBuilder.addMethod(MethodSpec.constructorBuilder().addStatement("this(sdk,address,DEFAULT_ABI(),credentials)", new Object[0]).addParameter(Sdk.class, "sdk", new Modifier[0]).addParameter(String.class, "address", new Modifier[0]).addParameter(Credentials.class, "credentials", new Modifier[0]).addException(JsonProcessingException.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        TypeSpec.Builder templateBuilder = TypeSpec.recordBuilder((String)(wrapperName + "Template")).addSuperinterface(Template.class).addJavadoc(templateDocs.build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        templateBuilder.addRecordComponent(ContractAbi.class, "abi");
        templateBuilder.addRecordComponent(Tvc.class, "tvc");
        MethodSpec defaultAbiFunction = MethodSpec.methodBuilder((String)"DEFAULT_ABI").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get(ContractAbi.class)).addException(JsonProcessingException.class).addStatement("return ContractAbi.ofString($S)", new Object[]{ContextBuilder.DEFAULT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL).writeValueAsString((Object)abi)}).build();
        wrapperBuilder.addMethod(defaultAbiFunction);
        templateBuilder.addMethod(defaultAbiFunction);
        MethodSpec.Builder tvcOnlyConstructorBuilder = MethodSpec.constructorBuilder();
        tvcOnlyConstructorBuilder.addStatement("this(DEFAULT_ABI(), tvc)", new Object[0]).addParameter(ParameterSpec.builder(Tvc.class, (String)"tvc", (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(JsonProcessingException.class);
        templateBuilder.addMethod(tvcOnlyConstructorBuilder.build());
        if (hasTvc) {
            templateBuilder.addMethod(MethodSpec.methodBuilder((String)"DEFAULT_TVC").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get(Tvc.class)).addStatement("return Tvc.ofBase64String($S)", new Object[]{tvc.base64String()}).build());
            MethodSpec.Builder noArgsConstructorBuilder = MethodSpec.constructorBuilder();
            noArgsConstructorBuilder.addStatement("this(DEFAULT_ABI(),DEFAULT_TVC())", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(JsonProcessingException.class);
            templateBuilder.addMethod(noArgsConstructorBuilder.build());
        }
        for (Abi.AbiFunction func : abi.functions()) {
            ClassName handleParamTypeName;
            ClassName handleTypeName;
            MethodSpec.Builder methodBuilder = null;
            boolean isConstructor = Strings.notEmptyEquals((String)func.name(), (String)"constructor");
            if (isConstructor) {
                methodBuilder = MethodSpec.methodBuilder((String)"prepareDeploy");
                logger.log(System.Logger.Level.INFO, "constructor!");
                methodBuilder.addParameter(ParameterSpec.builder(Sdk.class, (String)"sdk", (Modifier[])new Modifier[0]).build());
                methodBuilder.addParameter(ParameterSpec.builder(Credentials.class, (String)"credentials", (Modifier[])new Modifier[0]).build());
                StringBuilder fieldsMapBuilder = new StringBuilder("$T initialDataFields = $T.of(");
                ArrayList<String> fieldsList = new ArrayList<String>();
                ArrayList<Object> fieldArgsList = new ArrayList<Object>();
                fieldArgsList.add(ParameterizedTypeName.get((ClassName)TypeName.MAP, (TypeName[])new TypeName[]{TypeName.STRING, TypeName.OBJECT}));
                fieldArgsList.add(TypeName.MAP);
                if (Objs.isNotNull((Object)abi.data())) {
                    for (Abi.AbiData field : abi.data()) {
                        TypeName typeName = ContractWrapper.toTypeName(field.type());
                        ParameterSpec paramSpec = ParameterSpec.builder((TypeName)typeName, (String)field.name(), (Modifier[])new Modifier[0]).build();
                        methodBuilder.addParameter(paramSpec);
                        fieldsList.add("$S, $N");
                        fieldArgsList.add(field.name());
                        fieldArgsList.add(paramSpec);
                    }
                }
                fieldsMapBuilder.append(String.join((CharSequence)", \n", fieldsList));
                fieldsMapBuilder.append(")");
                CodeBlock.Builder bodyBuilder = CodeBlock.builder();
                bodyBuilder.addStatement(fieldsMapBuilder.toString(), fieldArgsList.toArray());
                methodBuilder.addCode(bodyBuilder.build());
            } else {
                methodBuilder = MethodSpec.methodBuilder((String)func.name());
            }
            logger.log(System.Logger.Level.INFO, func.name());
            methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
            StringBuilder mapStringBuilder = new StringBuilder("$T params = $T.of(");
            ArrayList<String> mapParams = new ArrayList<String>();
            ArrayList<Object> mapArgsBuilder = new ArrayList<Object>();
            mapArgsBuilder.add(ParameterizedTypeName.get((ClassName)TypeName.MAP, (TypeName[])new TypeName[]{TypeName.STRING, TypeName.OBJECT}));
            mapArgsBuilder.add(TypeName.MAP);
            TypeSpec resultOfFunctionType = null;
            if (func.outputs().length > 0) {
                TypeSpec.Builder resultTypeBuilder = TypeSpec.recordBuilder((String)("ResultOf" + ParserUtils.capitalize((String)func.name()))).addModifiers(new Modifier[]{Modifier.PUBLIC});
                for (Abi.AbiParam param : func.outputs()) {
                    TypeName resultTypeName = ContractWrapper.toTypeName(param.type());
                    ParameterSpec paramSpec = ParameterSpec.builder((TypeName)resultTypeName, (String)param.name(), (Modifier[])new Modifier[0]).build();
                    resultTypeBuilder.addRecordComponent(paramSpec);
                }
                resultOfFunctionType = resultTypeBuilder.build();
                wrapperBuilder.addType(resultOfFunctionType);
            }
            for (Abi.AbiParam param : func.inputs()) {
                if (param.name().equals("answerId")) continue;
                TypeName typeName = ContractWrapper.toTypeName(param.type());
                ParameterSpec paramSpec = ParameterSpec.builder((TypeName)typeName, (String)param.name(), (Modifier[])new Modifier[0]).build();
                methodBuilder.addParameter(paramSpec);
                mapParams.add("$S, $N");
                mapArgsBuilder.add(param.name());
                mapArgsBuilder.add(paramSpec);
            }
            mapStringBuilder.append(String.join((CharSequence)", \n", mapParams));
            mapStringBuilder.append(")");
            CodeBlock.Builder bodyBuilder = CodeBlock.builder();
            bodyBuilder.addStatement(mapStringBuilder.toString(), mapArgsBuilder.toArray());
            if (isConstructor) {
                handleTypeName = ClassName.get(DeployHandle.class);
                handleParamTypeName = ClassName.get((String)wrapperPackage, (String)wrapperName, (String[])new String[0]);
            } else {
                handleTypeName = ClassName.get(FunctionHandle.class);
                handleParamTypeName = Objs.isNull((Object)resultOfFunctionType) ? ClassName.get(Void.class) : ClassName.bestGuess((String)resultOfFunctionType.name);
            }
            ParameterizedTypeName resultName = ParameterizedTypeName.get((ClassName)handleTypeName, (TypeName[])new TypeName[]{handleParamTypeName});
            methodBuilder.returns((TypeName)resultName);
            if (isConstructor) {
                bodyBuilder.addStatement("return new $T($T.class, sdk, abi(), tvc(), sdk.clientConfig().abi().workchain(), credentials, initialDataFields, params, null)", new Object[]{resultName, handleParamTypeName});
                methodBuilder.addCode(bodyBuilder.build());
                templateBuilder.addMethod(methodBuilder.build());
                continue;
            }
            bodyBuilder.addStatement("return new $T(sdk(), address(), abi(), credentials(), $S, params, null)", new Object[]{resultName, func.name()});
            methodBuilder.addCode(bodyBuilder.build());
            wrapperBuilder.addMethod(methodBuilder.build());
        }
        JavaFile contractFile = JavaFile.builder((String)wrapperPackage, (TypeSpec)wrapperBuilder.build()).build();
        contractFile.writeTo(targetDirectory);
        JavaFile templateFile = JavaFile.builder((String)templatePackage, (TypeSpec)templateBuilder.build()).build();
        templateFile.writeTo(targetDirectory);
    }
}

