/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.template;

import java.util.Map;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Account;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.Tvc;
import tech.deplant.java4ever.framework.datatype.Address;

public interface Template {
    public static final System.Logger logger = System.getLogger(Template.class.getName());

    public ContractAbi abi();

    public Tvc tvc();

    default public String calculateAddress(Sdk sdk, Map<String, Object> initialData, Credentials credentials) throws EverSdkException {
        String address = Address.ofFutureDeploy(sdk, new CustomTemplate(this.abi(), this.tvc()), 0, initialData, credentials);
        logger.log(System.Logger.Level.INFO, () -> "Future address: " + address);
        return address;
    }

    default public Map<String, Object> decodeInitialData(Sdk sdk) throws EverSdkException {
        return this.tvc().decodeInitialData(sdk, this.abi());
    }

    default public String decodeInitialPubkey(Sdk sdk) throws EverSdkException {
        return this.tvc().decodeInitialPubkey(sdk, this.abi());
    }

    default public String addressFromEncodedTvc(Sdk sdk) throws EverSdkException {
        return String.format("0:%s", Boc.getBocHash((Context)sdk.context(), (String)this.tvc().base64String()).hash());
    }

    default public boolean isDeployed(Sdk sdk) throws EverSdkException {
        return Account.ofAddress(sdk, this.addressFromEncodedTvc(sdk)).isActive();
    }

    public record CustomTemplate(ContractAbi abi, Tvc tvc) implements Template
    {
    }
}

