/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.datatype;

import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.Bool;
import tech.deplant.java4ever.framework.datatype.ByteString;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.datatype.TypePrefix;
import tech.deplant.java4ever.framework.datatype.Uint;

public interface AbiType<JAVA_TYPE, JSON_TYPE> {
    public static AbiType of(TypePrefix prefix, int size, Object inputValue) throws EverSdkException {
        return switch (prefix) {
            default -> throw new IncompatibleClassChangeError();
            case TypePrefix.UINT, TypePrefix.INT -> Uint.fromJava(size, inputValue);
            case TypePrefix.STRING, TypePrefix.BYTES, TypePrefix.BYTE -> ByteString.fromJava(inputValue);
            case TypePrefix.ADDRESS -> Address.fromJava(inputValue);
            case TypePrefix.BOOL -> Bool.fromJava(inputValue);
            case TypePrefix.CELL, TypePrefix.SLICE, TypePrefix.BUILDER -> TvmCell.fromJava(inputValue);
            case TypePrefix.TUPLE -> {
                EverSdkException ex = new EverSdkException(new EverSdkException.ErrorResult(-301, "ABI Parsing unexpected! Shouldn't get here!"), (Throwable)new RuntimeException());
                System.getLogger(AbiType.class.getName()).log(System.Logger.Level.WARNING, () -> ex.toString());
                throw ex;
            }
        };
    }

    public JAVA_TYPE toJava();

    public JSON_TYPE toABI();
}

