/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tech.deplant.java4ever.binding.ContextBuilder;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.LogUtils;
import tech.deplant.java4ever.framework.Tvc;
import tech.deplant.java4ever.framework.artifact.JsonFile;
import tech.deplant.java4ever.framework.artifact.Solc;
import tech.deplant.java4ever.framework.artifact.TvmLinker;
import tech.deplant.java4ever.framework.template.Template;

public record EnvironmentConfig(String serializationPath, Solc compiler, TvmLinker linker, String sourcePath, String buildPath, Map<String, String> abis, Map<String, String> tvcs, Map<String, String> keys) {
    private static System.Logger logger = System.getLogger(EnvironmentConfig.class.getName());

    public static EnvironmentConfig EMPTY(String serializationPath, String solcPath, String linkerPath, String stdLibPath, String sourcePath, String buildPath) throws IOException {
        EnvironmentConfig config = new EnvironmentConfig(serializationPath, new Solc(solcPath), new TvmLinker(linkerPath, stdLibPath), sourcePath, buildPath, new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, String>());
        config.sync();
        return config;
    }

    public static EnvironmentConfig LOAD(String serializationPath) throws JsonProcessingException {
        return (EnvironmentConfig)ContextBuilder.DEFAULT_MAPPER.readValue(new JsonFile(serializationPath).get(), EnvironmentConfig.class);
    }

    public Template compileTemplate(String filename, String contractName) throws JsonProcessingException, EverSdkException {
        return this.compileTemplate(this.sourcePath(), this.buildPath(), filename, contractName);
    }

    public Template compileTemplate(String sourcePath, String buildPath, String filename, String contractName) throws JsonProcessingException, EverSdkException {
        int compilerResult = this.compiler().compileContract(contractName, filename, sourcePath, buildPath);
        if (compilerResult == 0) {
            int linkerResult = this.linker().assemblyContract(contractName, buildPath);
            if (linkerResult == 0) {
                return new Template.CustomTemplate(ContractAbi.ofFile(buildPath + "/" + contractName + ".abi.json"), Tvc.ofFile(buildPath + "/" + contractName + ".tvc"));
            }
            LogUtils.error(logger, () -> "TvmLinker exit code:" + linkerResult);
            return null;
        }
        LogUtils.error(logger, () -> "Solc exit code:" + compilerResult);
        throw new EverSdkException(new EverSdkException.ErrorResult(-600, "Compilation failed. Solc exit code:" + compilerResult), (Throwable)new Exception());
    }

    public ContractAbi abi(String name) throws JsonProcessingException {
        return ContractAbi.ofFile(this.abis().get(name));
    }

    public Credentials credentials(String name) throws JsonProcessingException {
        return Credentials.ofFile(this.keys().get(name));
    }

    public Tvc tvc(String name) {
        return Tvc.ofFile(this.tvcs().get(name));
    }

    public void addAbiPath(String name, String pathStr) throws IOException {
        this.abis().put(name, pathStr);
        this.sync();
    }

    public void addTvcPath(String name, String pathStr) throws IOException {
        this.tvcs().put(name, pathStr);
        this.sync();
    }

    public void addKeypairPath(String name, String pathStr) throws IOException {
        this.keys().put(name, pathStr);
        this.sync();
    }

    public void sync() throws IOException {
        new JsonFile(this.serializationPath()).accept(ContextBuilder.DEFAULT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this));
    }
}

