/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.template;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.Future;
import jdk.incubator.concurrent.StructuredTaskScope;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.framework.Account;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.abi.ContractAbi;
import tech.deplant.java4ever.framework.abi.datatype.Address;
import tech.deplant.java4ever.framework.contract.Giver;
import tech.deplant.java4ever.framework.contract.OwnedContract;
import tech.deplant.java4ever.framework.crypto.Credentials;
import tech.deplant.java4ever.framework.template.ContractTvc;

public class ContractTemplate {
    private static System.Logger logger = System.getLogger(ContractTemplate.class.getName());
    private final ContractAbi abi;
    private final ContractTvc tvc;

    public ContractTemplate(ContractAbi abi, ContractTvc tvc) {
        this.abi = abi;
        this.tvc = tvc;
    }

    public ContractAbi abi() {
        return this.abi;
    }

    public ContractTvc tvc() {
        return this.tvc;
    }

    protected OwnedContract doDeploy(Sdk sdk, int workchainId, String address, Map<String, Object> initialData, Credentials credentials, Map<String, Object> constructorInputs) throws EverSdkException {
        OwnedContract ownedContract;
        StructuredTaskScope.ShutdownOnFailure scope = new StructuredTaskScope.ShutdownOnFailure();
        try {
            Future deploySetFuture = scope.fork(() -> new Abi.DeploySet(this.tvc.base64String(), Integer.valueOf(workchainId), this.abi().convertInitDataInputs(initialData), credentials.publicKey()));
            Future callSetFuture = scope.fork(() -> new Abi.CallSet("constructor", null, this.abi().convertFunctionInputs("constructor", constructorInputs)));
            scope.join();
            Processing.processMessage((Context)sdk.context(), (Abi.ABI)this.abi().ABI(), (String)address, (Abi.DeploySet)((Abi.DeploySet)deploySetFuture.resultNow()), (Abi.CallSet)((Abi.CallSet)callSetFuture.resultNow()), (Abi.Signer)credentials.signer(), null, (Boolean)false);
            ownedContract = new OwnedContract(sdk, address, this.abi(), credentials);
        }
        catch (Throwable throwable) {
            try {
                try {
                    scope.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        scope.close();
        return ownedContract;
    }

    public OwnedContract deploy(Sdk sdk, int workchainId, Map<String, Object> initialData, Credentials credentials, Map<String, Object> constructorInputs) throws EverSdkException {
        return this.doDeploy(sdk, workchainId, this.calculateAddress(sdk, initialData, credentials), initialData, credentials, constructorInputs);
    }

    public String calculateAddress(Sdk sdk, Map<String, Object> initialData, Credentials credentials) throws EverSdkException {
        String address = Address.ofFutureDeploy(sdk, this, 0, initialData, credentials);
        logger.log(System.Logger.Level.INFO, () -> "Future address: " + address);
        return address;
    }

    public OwnedContract deployWithGiver(Sdk sdk, Giver giver, BigInteger value, int workchainId, Map<String, Object> initialData, Credentials credentials, Map<String, Object> constructorInputs) throws EverSdkException {
        String address = this.calculateAddress(sdk, initialData, credentials);
        giver.give(address, value);
        return this.doDeploy(sdk, workchainId, address, initialData, credentials, constructorInputs);
    }

    public Map<String, Object> decodeInitialData(Sdk sdk) throws EverSdkException {
        return this.tvc().decodeInitialData(sdk, this.abi());
    }

    public String decodeInitialPubkey(Sdk sdk) throws EverSdkException {
        return this.tvc().decodeInitialPubkey(sdk, this.abi());
    }

    public String addressFromEncodedTvc(Sdk sdk) throws EverSdkException {
        return String.format("0:%s", Boc.getBocHash((Context)sdk.context(), (String)this.tvc().base64String()).hash());
    }

    public boolean isDeployed(Sdk sdk) throws EverSdkException {
        return Account.ofAddress(sdk, this.addressFromEncodedTvc(sdk)).isActive();
    }

    public ContractTemplate withUpdatedInitialData(Sdk sdk, Map<String, Object> initialData, String publicKey) throws EverSdkException {
        return new ContractTemplate(this.abi(), this.tvc().withUpdatedInitialData(sdk, this.abi(), initialData, publicKey));
    }
}

