/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.framework.Account;
import tech.deplant.java4ever.framework.Address;
import tech.deplant.java4ever.framework.Data;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.abi.AbiUint;
import tech.deplant.java4ever.framework.abi.ContractAbi;
import tech.deplant.java4ever.framework.crypto.Credentials;

public class OwnedContract {
    private static Logger log = LoggerFactory.getLogger(OwnedContract.class);
    protected final Sdk sdk;
    protected final Address address;
    protected final ContractAbi abi;
    protected final Credentials credentials;

    public OwnedContract(Sdk sdk, Address address, ContractAbi abi, Credentials credentials) {
        this.sdk = sdk;
        this.address = address;
        this.abi = abi;
        this.credentials = credentials;
    }

    public OwnedContract(Sdk sdk, Address address, ContractAbi abi) {
        this(sdk, address, abi, Credentials.NONE);
    }

    public Sdk sdk() {
        return this.sdk;
    }

    public Address address() {
        return this.address;
    }

    public ContractAbi abi() {
        return this.abi;
    }

    public BigInteger balance() throws EverSdkException {
        return AbiUint.deserialize(128, this.account().balance());
    }

    public Account account() throws EverSdkException {
        return Account.ofAddress(this.sdk, this.address);
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public String tvmPubkey() throws EverSdkException {
        return this.account().tvmPubkey(this.sdk(), this.abi());
    }

    public String encodeInternalPayload(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) throws EverSdkException {
        return Abi.encodeMessageBody((Context)this.sdk().context(), (Abi.ABI)this.abi().ABI(), (Abi.CallSet)new Abi.CallSet(functionName, functionHeader, this.abi().convertFunctionInputs(functionName, functionInputs)), (Boolean)true, (Abi.Signer)Credentials.NONE.signer(), null, (String)this.address().makeAddrStd()).body();
    }

    public Map<String, Object> runGetter(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials) throws EverSdkException {
        return this.account().runGetter(this.sdk(), this.abi(), functionName, functionInputs, functionHeader, credentials);
    }

    private Processing.ResultOfProcessMessage processExternalCall(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials) throws EverSdkException {
        return Processing.processMessage((Context)this.sdk.context(), (Abi.ABI)this.abi().ABI(), (String)this.address().makeAddrStd(), null, (Abi.CallSet)new Abi.CallSet(functionName, functionHeader, this.abi().convertFunctionInputs(functionName, functionInputs)), (Abi.Signer)credentials.signer(), null, (Boolean)false, null);
    }

    public Map<String, Object> callExternalDebugTree(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials, Long debugQueryTimeout, boolean debugThrowOnTreeErrors, Net.ResultOfQueryTransactionTree debugOutResult, List<ContractAbi> debugAbisForDecode) throws EverSdkException {
        Net.TransactionNode[] transactions;
        debugAbisForDecode.add(this.abi());
        Abi.ABI[] abis = (Abi.ABI[])debugAbisForDecode.stream().map(ContractAbi::ABI).toArray(Abi.ABI[]::new);
        long debugTimeout = Optional.ofNullable(debugQueryTimeout).orElse(30000L);
        Processing.ResultOfProcessMessage resultOfProcess = this.processExternalCall(functionName, functionInputs, functionHeader, credentials);
        String msgId = resultOfProcess.transaction().get("in_msg").toString();
        debugOutResult = Net.queryTransactionTree((Context)this.sdk().context(), (String)msgId, (Abi.ABI[])abis, (Number)debugTimeout);
        Net.MessageNode[] messages = debugOutResult.messages();
        for (Net.TransactionNode tr : transactions = debugOutResult.transactions()) {
            Net.MessageNode msg = Arrays.stream(messages).filter(msgElem -> msgElem.id().equals(tr.inMsg())).findFirst().get();
            String msgSource = msg.src().length() > 0 ? msg.src() : "ext";
            String msgDest = msg.dst().length() > 0 ? msg.dst() : "ext";
            BigDecimal msgValue = msg.value() == null ? BigDecimal.ZERO : Data.hexToDec(msg.value(), 9);
            BigDecimal fees = Data.hexToDec(tr.totalFees(), 9);
            String outMessages = "\"" + String.join((CharSequence)"\",\"", tr.outMsgs()) + "\"";
            Number error_code = tr.exitCode();
            String logBlock = "\n-----------------------------------------------------------\nTRANSACTION: {\"id\":\"" + tr.id() + "\",\"msg_id\":\"" + msg.id() + "\"}\n  [" + msgSource + "] -(" + msgValue.toPlainString() + " E)-> [" + msgDest + "]\n  Result: " + String.valueOf(error_code) + "\n  Fees: " + fees.toPlainString() + " E\n  Out Messages: [" + outMessages + "]\n-----------------------------------------------------------\n";
            if (tr.aborted().booleanValue() && debugThrowOnTreeErrors) {
                log.error(logBlock);
                throw new EverSdkException(new EverSdkException.ErrorResult(tr.exitCode().intValue(), "One of the message tree transaction was aborted!"), (Throwable)new Exception());
            }
            if (tr.aborted().booleanValue()) {
                log.warn(logBlock);
                continue;
            }
            log.info(logBlock);
        }
        return Optional.ofNullable(resultOfProcess.decoded().output()).orElse(new HashMap());
    }

    public Map<String, Object> callExternal(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials) throws EverSdkException {
        Processing.ResultOfProcessMessage resultOfProcess = this.processExternalCall(functionName, functionInputs, functionHeader, credentials);
        BigDecimal balanceDeltaStr = Data.hexToDec(resultOfProcess.transaction().get("balance_delta").toString(), 9);
        log.info("\n-----------------------------------------------------------\nTRANSACTION: (" + resultOfProcess.transaction().get("id").toString() + ")\n  Message: [ext] -(0 E)-> [" + resultOfProcess.transaction().get("account_addr").toString() + "] (id: " + resultOfProcess.transaction().get("in_msg").toString() + ")\n  Account: " + resultOfProcess.transaction().get("account_addr").toString() + "\n  Balance change: " + balanceDeltaStr.toPlainString() + " E\n-----------------------------------------------------------\n");
        return Optional.ofNullable(resultOfProcess.decoded().output()).orElse(new HashMap());
    }

    public Map<String, Object> callExternal(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) throws EverSdkException {
        return this.callExternal(functionName, functionInputs, functionHeader, this.credentials);
    }

    public Map<String, Object> runGetter(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) throws EverSdkException {
        return this.runGetter(functionName, functionInputs, functionHeader, this.credentials);
    }
}

