/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.math.BigInteger;
import java.util.Map;
import lombok.Generated;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.framework.ContractTemplate;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.Data;
import tech.deplant.java4ever.framework.Sdk;

public final class Address {
    public static final Address ZERO = new Address(0, BigInteger.ZERO);
    private final int wid;
    private final BigInteger value;

    public Address(int wid, BigInteger value) {
        this.wid = wid;
        this.value = value;
    }

    public Address(String address) {
        String[] splitted = address.split(":");
        this.wid = Integer.valueOf(splitted[0]);
        this.value = new BigInteger(splitted[1], 16);
    }

    public Address(BigInteger value) {
        this(0, value);
    }

    public static Address ofFutureDeploy(Sdk sdk, ContractTemplate template, int workchainId, Map<String, Object> initialData, Credentials credentials) throws Sdk.SdkException {
        return new Address(((Abi.ResultOfEncodeMessage)sdk.syncCall(Abi.encodeMessage((Context)sdk.context(), (Abi.ABI)template.abi().abiJson(), null, (Abi.DeploySet)new Abi.DeploySet(template.tvc().tvcString(), (Number)workchainId, initialData, credentials.publicKey()), null, (Abi.Signer)credentials.signer(), null))).address());
    }

    public boolean isNone() {
        return this.value.equals(BigInteger.ZERO);
    }

    public int getType() {
        return 0;
    }

    public String makeAddrStd() {
        return this.wid() + ":" + Data.padLeftZeros(this.value().toString(16), 64);
    }

    @Generated
    public int wid() {
        return this.wid;
    }

    @Generated
    public BigInteger value() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (this.wid() != other.wid()) {
            return false;
        }
        BigInteger this$value = this.value();
        BigInteger other$value = other.value();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.wid();
        BigInteger $value = this.value();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Address(wid=" + this.wid() + ", value=" + this.value() + ")";
    }
}

