/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tech.deplant.java4ever.framework.Account;
import tech.deplant.java4ever.framework.Address;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.Sdk;

public class AccountController {
    @Generated
    private static final Logger log = LogManager.getLogger(AccountController.class);
    private Account account;
    private Credentials externalOwner;
    private AccountController internalOwner;

    public AccountController(Account account, Credentials externalOwner, AccountController internalOwner) {
        this.account = account;
        this.externalOwner = externalOwner;
        this.internalOwner = internalOwner;
    }

    public static AccountController ofAddress(ContractAbi abi, Address address, Sdk sdk, Credentials externalOwner, AccountController internalOwner) throws Sdk.SdkException {
        return new AccountController(Account.ofAddress(sdk, address, abi), externalOwner, internalOwner);
    }

    public Map<String, Object> callExternalFromOwner(@NonNull String functionName, Map<String, Object> functionInputs) throws Sdk.SdkException {
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        this.convertInputs(functionName, functionInputs);
        Map<String, Object> result = this.account.callExternal(this.externalOwner, functionName, functionInputs);
        this.account(this.refreshAcc());
        return result;
    }

    public Map<String, Object> callInternalFromCustom(AccountController customSender, @NonNull String functionName, Map<String, Object> functionInputs, BigInteger functionValue, boolean functionBounce) throws Sdk.SdkException {
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        if (this.account.abi().hasFunction(functionName)) {
            this.convertInputs(functionName, functionInputs);
            Map<String, Object> result = this.account.callInternalFromMsig(customSender.externalOwner(), customSender.account().address(), functionValue, functionName, functionValue, functionInputs, functionBounce);
            this.account(this.refreshAcc());
            return result;
        }
        log.error(() -> "Function (" + functionName + ") not found in ABI of " + this.account.address().makeAddrStd());
        return new HashMap<String, Object>();
    }

    public Map<String, Object> callInternalFromOwner(@NonNull String functionName, Map<String, Object> functionInputs, BigInteger functionValue, boolean functionBounce) throws IOException, Sdk.SdkException {
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        return this.callInternalFromCustom(this.internalOwner, functionName, functionInputs, functionValue, functionBounce);
    }

    public Map<String, Object> runGetter(@NonNull String abiFunction, Map<String, Object> input) {
        if (abiFunction == null) {
            throw new NullPointerException("abiFunction is marked non-null but is null");
        }
        this.convertInputs(abiFunction, input);
        return this.account.runGetter(abiFunction, input);
    }

    public void refresh() throws Sdk.SdkException {
        this.account(this.refreshAcc());
    }

    private Account refreshAcc() throws Sdk.SdkException {
        return Account.ofAddress(this.account.sdk(), this.account.address(), this.account.abi());
    }

    private void convertInputs(String functionName, Map<String, Object> functionInputs) {
        if (functionInputs != null) {
            functionInputs.forEach((key, value) -> {
                if (this.account.abi().hasInput(functionName, (String)key)) {
                    String type;
                    functionInputs.replace((String)key, switch (type = this.account.abi().inputType(functionName, (String)key)) {
                        case "uint128", "uint256", "uint64", "uint32" -> {
                            Object v0 = value;
                            Objects.requireNonNull(v0);
                            Object selector3837$temp = v0;
                            int 3873index = 0;
                            block20: while (true) {
                                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigInteger.class, Instant.class, String.class, String.class}, (Object)selector3837$temp, 3873index)) {
                                    case 0: {
                                        BigInteger b = (BigInteger)selector3837$temp;
                                        yield "0x" + b.toString(16);
                                    }
                                    case 1: {
                                        Instant i = (Instant)selector3837$temp;
                                        yield "0x" + BigInteger.valueOf(i.getEpochSecond()).toString(16);
                                    }
                                    case 2: {
                                        String s = (String)selector3837$temp;
                                        if (!"0x".equals(s.substring(0, 2))) {
                                            3873index = 3;
                                            continue block20;
                                        }
                                        yield s;
                                    }
                                    case 3: {
                                        String s = (String)selector3837$temp;
                                        yield "0x" + s;
                                    }
                                }
                                break;
                            }
                            yield value;
                        }
                        case "address" -> {
                            Object v2 = value;
                            Objects.requireNonNull(v2);
                            Object selector4403$temp = v2;
                            int 4439index = 0;
                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Address.class}, (Object)selector4403$temp, 4439index)) {
                                case 0: {
                                    Address a = (Address)selector4403$temp;
                                    yield a.makeAddrStd();
                                }
                            }
                            yield value;
                        }
                        default -> value;
                    });
                } else {
                    log.error(() -> "Function " + functionName + " doesn't contain input (" + key + ") in ABI of " + this.account.address().makeAddrStd());
                }
            });
        }
    }

    @Generated
    public Account account() {
        return this.account;
    }

    @Generated
    public AccountController account(Account account) {
        this.account = account;
        return this;
    }

    @Generated
    public Credentials externalOwner() {
        return this.externalOwner;
    }

    @Generated
    public AccountController externalOwner(Credentials externalOwner) {
        this.externalOwner = externalOwner;
        return this;
    }

    @Generated
    public AccountController internalOwner() {
        return this.internalOwner;
    }

    @Generated
    public AccountController internalOwner(AccountController internalOwner) {
        this.internalOwner = internalOwner;
        return this;
    }
}

